#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ad4jmgr/ad4jmgr_cleanup.pl /main/2 2010/10/14 12:02:29 sauchatt Exp $
#
# step5script.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      step5script.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    atejaswy    06/02/10 - Cleanup command
#    atejaswy    06/02/10 - Creation
#

#First argument is the absolute location %emd_root%
#Second argument is the name of the temp directory

use File::Spec();

#my $EMD_ROOT = "/ade/atejaswy_mockup_may26th_ag/emagent/sysman/emd";
#my $tempdir = "temp_ad4jdir";

my $EMD_ROOT = $ARGV[0];
my $tempdir = $ARGV[1];

my $destination_dir = File::Spec->catfile( $EMD_ROOT , $tempdir );

print("Deleting directory $destination_dir\n");
cleanup($destination_dir);

#This short perl function will recursively delete a directory and everything in it. All directories and file will be removed including the specified directory.

sub cleanup {
        my $dir = shift;
	local *DIR;

	opendir DIR, $dir or die "opendir $dir: $!";
	for (readdir DIR) {
	        next if /^\.{1,2}$/;
	        my $path = "$dir/$_";
		unlink $path if -f $path;
		cleanup($path) if -d $path;
	}
	closedir DIR;
	rmdir $dir or print "error - $!";
}
