#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ad4jmgr/ad4jmgr_deploymgr.pl /main/14 2012/05/31 06:41:33 nehaa Exp $
#
# step4script.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      step4script.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sauchatt    05/24/10 - Step 4: Creating server and deploying app
#    sauchatt    05/24/10 - Creation
# 
use File::Path;
use File::Spec();
use IPC::Open3;
use IO::Handle;
use IO::Select;

#Secure and unsecure modes

my $PYTHON_SCRIPT = $ARGV[0];
my $STOP_SCRIPT = $ARGV[1];
my $EMD_ROOT = $ARGV[2];
my $JAMMANAGER_LOCATION = $ARGV[3];
my $JAMMANAGER_DUMMY_LOCATION = $ARGV[4];

my $ADMIN_HOST_NAME = $ARGV[5];
my $ADMIN_WL_HOME = $ARGV[6];
my $portnumber= $ARGV[7];
my $connectiontype= $ARGV[8];

my $EMGC_MACHINE= $ARGV[9];
my $MODULES_DIR= $ARGV[10];
my $WL_HOME = $ARGV[11];
my $ExistingOMSServerName= $ARGV[12];
my $DOMAIN_HOME= $ARGV[13];
my $ORACLE_HOME = $ARGV[14];

my $ServerName= $ARGV[15];
my $ListenAddress= $ARGV[16];
my $ListenPort= $ARGV[17];
my $SSLListenPort= $ARGV[18];
my $IS_NEW_SERVER = $ARGV[19];
my $AGENT_STATE_DIR = $ARGV[20];
my $IS_DEPLOYED_APP = $ARGV[21];

print("Printing parameters passed to perl script \n");
print("WL_HOME: $WL_HOME \n");
print("ADMIN_HOST_NAME: $ADMIN_HOSTNAME \n");
print("portnumber: $portnumber \n");
print("EMGC_MACHINE: $EMGC_MACHINE \n");
print("MODULES_DIR: $MODULES_DIR \n");
print("ServerName: $ServerName \n");
print("ListenAddress: $ListenAddress \n");
print("ListenPort: $ListenPort \n");
print("SSLListenPort: $SSLListenPort \n");
print("connectiontype: $connectiontype \n");
print("ExistingOMSServerName: $ExistingOMSServerName \n");
print("DOMAIN_HOME: $DOMAIN_HOME \n");
print("PYTHON_SCRIPT: $PYTHON_SCRIPT \n");
print("ORACLE_HOME: $ORACLE_HOME \n");
print("JAMMANAGER_LOCATION: $JAMMANAGER_LOCATION \n");
print("JAMMANAGER_DUMMY_LOCATION: $JAMMANAGER_DUMMY_LOCATION \n");
print("IS_NEW_SERVER: $IS_NEW_SERVER \n");
print("EMD_ROOT: $EMD_ROOT \n");
print("STOP_SCRIPT: $STOP_SCRIPT\n");
print("IS_DEPLOYED_APP: $IS_DEPLOYED_APP\n\n\n");

my $inp = <STDIN>;

my $comma_pos = index($inp, ",");

my $username = substr($inp, 0, $comma_pos);
my $password = substr($inp, $comma_pos+1 );

my $IS_WINDOWS = &IsWindows();

my $KEYSTORE_LOC = File::Spec->catfile( $AGENT_STATE_DIR,'sysman','config','montrust','AgentTrust.jks');

my $DEPLOY_CMD = "$EMD_ROOT/jdk/bin/java -cp $ADMIN_WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC weblogic.WLST  $PYTHON_SCRIPT $ADMIN_HOST_NAME $portnumber $username $EMGC_MACHINE $ORACLE_HOME $WL_HOME $MODULES_DIR $ServerName $ListenAddress $ListenPort $SSLListenPort $connectiontype $ExistingOMSServerName $DOMAIN_HOME $JAMMANAGER_LOCATION $JAMMANAGER_DUMMY_LOCATION $IS_NEW_SERVER $IS_WINDOWS $IS_DEPLOYED_APP";

print("Deploy command: $DEPLOY_CMD\n");

if($IS_NEW_SERVER eq "false")
{	
my $DEPLOY_CMD2 =  "$EMD_ROOT/jdk/bin/java -cp $ADMIN_WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true  -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC weblogic.WLST $STOP_SCRIPT $ADMIN_HOST_NAME $portnumber $username $ServerName $connectiontype";

print("Shutting down managed server\n");
print("$DEPLOY_CMD2\n");

#Running deploycommand 2 -----------
if(&IsWindows())
   {

   local (*HANDLE_IN, *HANDLE_OUT);
   open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD2)  or die "open3 failed $!\n" ;

         print HANDLE_IN "$password\r\n";
	 my $nextLine;
    while(<HANDLE_OUT>) {
        $nextLine= $_;
        print $nextLine;
    }

        close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
    close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
}
else
{
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD2);

         print HANDLE_IN "$password\r\n";

        my $sel = new IO::Select;
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

        while(my @ready = $sel->can_read) {
            foreach my $fh (@ready)
            {
                my $line = <$fh>;
                if(not defined $line){
                    $sel->remove($fh);
                    next;
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {
                    print $line;

                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print  $line;
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
}
#-----------------------------------


}

#Deploying making sure of the failure/success status
# don't use select function for windows
my $STATUS="true";

if(&IsWindows())
   {

   local (*HANDLE_IN, *HANDLE_OUT);
   open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD)  or die "open3 failed $!\n" ;

	 print HANDLE_IN "$password\r\n";

    my $nextLine;
    while(<HANDLE_OUT>) {		
        $nextLine= $_;	
        print $nextLine;

        # i for case insensitive match
        if($nextLine =~ m/ERROR | Exception | WLSTException | Traceback/i) {
            $STATUS = "false";
        }
    }
 
	close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
    close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
}
else
{
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR); 
        open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD);

	 print HANDLE_IN "$password\r\n";

        my $sel = new IO::Select; 
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

        while(my @ready = $sel->can_read) { 
            foreach my $fh (@ready) 
            {
                my $line = <$fh>; 
                if(not defined $line){
                    $sel->remove($fh); 
                    next;              
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {     
                    print $line; 

                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print  $line;
                    $STATUS = "false";
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
}

if( $STATUS eq "false" ) 
{	exit -1;}
else
{	exit 0;}

#End	

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
