#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ad4jmgr/ad4jmgr_enablesecuremode.pl /main/4 2011/03/23 22:17:18 sauchatt Exp $
#
# ad4jmgr_changeports.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ad4jmgr_changeports.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sauchatt    07/12/10 - Creation
#

use IPC::Open3;
use File::Path;
use File::Spec();
use File::Copy;
use Cwd;
use IO::Handle;
use IO::Select;

#Arguments: emd root, temp ad4jdir ( will only be run if secure )
my $EMD_ROOT = $ARGV[0];
my $tempdir = $ARGV[1];
my $UNZIP = File::Spec->catfile($EMD_ROOT,"bin","unzip");
my $JAR = File::Spec->catfile($EMD_ROOT,"jdk","bin","jar");

my $jammanager_location = File::Spec->catfile( $EMD_ROOT,$tempdir,"jammanager.ear");
my $extract_location = File::Spec->catfile( $EMD_ROOT, $tempdir,"secure" );

#system("jar -xvf $jammanager_location ");
#We need to use unzip command to extract to the proper directory since jar doesnt work

print(" Unzipping $jammanager_location to $extract_location \n");
system("$UNZIP $jammanager_location -d $extract_location");

my $jamservlet_location = File::Spec->catfile( $extract_location, "jamservlet.war" );
      
#Unzip jamservlet.war
print(" Unzipping $jamservlet_location to $extract_location \n");
system("$UNZIP $jamservlet_location -d $extract_location");

#Now web.xml will be in the directory WEB-INF

my  $INPUT_XML_LOC =  File::Spec -> catfile ($extract_location,"WEB-INF","web.xml" );

          print "INPUT_XML_LOC : $INPUT_XML_LOC\n";

             #perform inplace substitution for src and destn store loc in input xml
                 open FILE_HANDLE, "+<$INPUT_XML_LOC"
                           or die "Cannot open $INPUT_XML_LOC: $!";
                               #flock LOG, 2;
                                   @data = <FILE_HANDLE>;
                                       seek FILE_HANDLE, 0, 0;
                                           truncate FILE_HANDLE, 0;

 
print("Changing jamsecureCommunication to 0 for secure mode \n");
                               my  $rep="0";
                        my $cnt=0;
                                               foreach my $line (@data)
                                                   {
                                                           if ($line =~ /jamsecureCommunication/)

                {
                         if ( $data[$cnt+1] =~ /$rep/)
                         {
                                $data[$cnt+1]=~ s/$rep/0/ ;
                                print " $data[$cnt+1] is modified one ";
                                print "inside the matching loop";
                         }
                        print "$data[$cnt+1] is the modified line ";
                }
                                         $cnt++;
                        #                print " $data[$cnt] is the linne";
                                          print FILE_HANDLE $line;
                                                                          }
        close FILE_HANDLE;

#zip it back up
chdir( $extract_location);
my $UPDATE_CMD="$JAR -uf jamservlet.war WEB-INF/web.xml";
print("Update cmd $UPDATE_CMD \n");
system($UPDATE_CMD);

my $ZIP_CMD = "$JAR -cvf jammanager.ear jammanager.jar jamservlet.war META-INF ewallet.p12";

print("Zip command: $ZIP_CMD \n");

system($ZIP_CMD);

print("Copying jammanager.ear to $jammanager_location");
copy( File::Spec->catfile($extract_location,"jammanager.ear") ,$jammanager_location) or die "Copy failed: $!";
#Done
