#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ad4jmgr/ad4jmgr_remote_deploymgr.pl /main/10 2012/05/31 06:41:33 nehaa Exp $
#
# step4script.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      step4script.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sauchatt    05/24/10 - Step 4: Creating server and deploying app
#    sauchatt    05/24/10 - Creation
# 
use File::Path;
use File::Spec();
use IPC::Open3;
use IO::Handle;
use IO::Select;

#Secure and unsecure modes

my $WL_HOME = $ARGV[0];
my $PYTHON_SCRIPT = $ARGV[1];
my $local_weblogichostname = $ARGV[2];
my $local_weblogicportnumber = $ARGV[3];
my $remoteServerName = $ARGV[4];
my $connectiontype= $ARGV[5];
my $JAMMANAGER_LOCATION= $ARGV[6];
my $ExistingOMSServerName= $ARGV[7];
my $JAMMANAGER_DUMMY_LOCATION= $ARGV[8];
my $AGENT_STATE_DIR = $ARGV[9];
my $EMD_ROOT = $ARGV[10];
my $IS_DEPLOYED_APP = $ARGV[11];

print("Printing parameters passed to perl script \n");
print("Local WL home: $WL_HOME \n");
print("PYTHON_SCRIPT:  $PYTHON_SCRIPT \n");
print("local_weblogichostname: $local_weblogichostname \n");
print("local_weblogicportnumber: $local_weblogicportnumber \n");
print("remoteServerName: $remoteServerName \n");
print("connectiontype: $connectiontype \n");
print("JAMMANAGER_LOCATION: $JAMMANAGER_LOCATION \n");
print("ExistingOMSServerName: $ExistingOMSServerName \n");
print("JAMMANAGER_DUMMY_LOCATION: $JAMMANAGER_DUMMY_LOCATION \n");

my $inp = <STDIN>;

my $comma_pos = index($inp, ",");

my $local_username = substr($inp, 0, $comma_pos);
my $local_password = substr($inp, $comma_pos+1 );

my $KEYSTORE_LOC = File::Spec->catfile( $AGENT_STATE_DIR,'sysman','config','montrust','AgentTrust.jks');

my $DEPLOY_CMD = "$EMD_ROOT/jdk/bin/java -cp $WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true  -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC weblogic.WLST $PYTHON_SCRIPT $local_weblogichostname $local_weblogicportnumber $local_username $remoteServerName $connectiontype $JAMMANAGER_LOCATION  $ExistingOMSServerName $JAMMANAGER_DUMMY_LOCATION $IS_DEPLOYED_APP";

print("$DEPLOY_CMD \n");


#system($DEPLOY_CMD);

#Deploying making sure of the failure/success status
# don't use select function for windows
my $STATUS="true";

if(&IsWindows())
   {

   local (*HANDLE_IN, *HANDLE_OUT);
   open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD)  or die "open3 failed $!\n" ;
         print HANDLE_IN "$local_password\r\n";

    my $nextLine;
    while(<HANDLE_OUT>) {		
        $nextLine= $_;	
        print $nextLine;

        # i for case insensitive match
        if($nextLine =~ m/ERROR | Exception | WLSTException | Traceback/i) {
            $STATUS = "false";
        }
    }
 
	close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
    close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
}
else
{
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR); 
        open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD);
         print HANDLE_IN "$local_password\r\n";

        my $sel = new IO::Select; 
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

        while(my @ready = $sel->can_read) { 
            foreach my $fh (@ready) 
            {
                my $line = <$fh>; 
                if(not defined $line){
                    $sel->remove($fh); 
                    next;              
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {     
                    print $line; 

                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print  $line;
                    $STATUS = "false";
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
}

if( $STATUS eq "false" ) 
{	exit -1;}
else
{	exit 0;}

#End	

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
