#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ad4jmgr/ad4jmgr_repackage.pl /main/4 2010/12/13 21:07:24 sauchatt Exp $
#
# step3script.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      step3script.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sauchatt    05/24/10 - Step 3: repackaging
#    sauchatt    05/24/10 - Creation
#

#First argument is emdroot
#Second is temp directory. We must unzip the file here
#Third is wallet location

use File::Copy;
use File::Spec();

#Remember this must be secure

my $EMD_ROOT = $ARGV[0];
my $tempdir = $ARGV[1];
my $nz_wallet_location = $ARGV[2];

my $nz_wallet_password = <STDIN>;

print("Modifiying jammanager.ear to include wallet \n");

my $jammanager_location = File::Spec->catfile( $EMD_ROOT,$tempdir,"jammanager.ear");
my $extract_location = File::Spec->catfile( $EMD_ROOT, $tempdir );

#system("jar -xvf $jammanager_location ");
#We need to use unzip command to extract to the proper directory since jar doesnt work

print(" Unzipping $jammanager_location to $extract_location \n");
system("unzip $jammanager_location -d $extract_location");

my $newtempdir = File::Spec->catfile( $EMD_ROOT, $tempdir, "temp");

print("Making temporary directory $newtempdir\n");
mkdir $newtempdir;

my $jamservlet_location = File::Spec->catfile( $EMD_ROOT, $tempdir, "jamservlet.war" );
my $new_jamservlet_location = File::Spec->catfile( $EMD_ROOT, $tempdir, "temp","jamservlet.war" );

print("Moving file jamservlet.war to $new_jamservlet_location \n");
move($jamservlet_location, $new_jamservlet_location);

my $nzhelper_location = File::Spec->catfile( $EMD_ROOT, $tempdir, "jamnzhelper.jar" );

print("Running java Nzhelper\n");
system("java -cp $nzhelper_location NzHelper 1 $nz_wallet_password $extract_location");

#Deletes jammanager.ear file
print("Deleting jammanager.ear file\n");
unlink($jammanager_location);

my $new_wallet_location = File::Spec->catfile( $EMD_ROOT, $tempdir, "ewallet.p12");
print("Copying wallet from $nz_wallet_location to $new_wallet_location \n");
copy($nz_wallet_location,$new_wallet_location);

#Original command: jar -cvf jammanager.ear jammanager.jar jamservlet.war META-INF ewallet.p12

print("Jarring stuff \n");
#system("jar -cvf $jammanager_location $extract_location\/jammanager.jar $jamservlet_location $extract_location\/META-INF $new_wallet_location");

chdir( $extract_location);

my $ZIP_CMD = "jar -cvf jammanager.ear jammanager.jar jamservlet.war META-INF ewallet.p12";

print("Zip command: $ZIP_CMD \n");

system($ZIP_CMD);


