#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/apacheresponse.pl /main/2 2010/09/18 18:15:52 vepadman Exp $
#
# apache_response.pl
# 
# Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#     apache_response.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#
#    MODIFIED   (MM/DD/YY)
#    vaudinar   07/10/08 - bug 7037742
# 
use strict;
#use Config;
use ias::Apache_confFileParser;
use ias::asecm;
#require "iasresourceusage.pl";

my $LONG_PS_CMD_PID_COL = 1;
my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";

my $osType = $^O;

# See we if find any apache server pids
# Get the pidd for the http server and see if we find some pids.
#passing two args : argv0 = conf file path, argv1 = binaries home  
my $status  = getApacheStatus( $ARGV[0]);
my $version = getApacheVersion( $ARGV[1] );


#print "em_result=$status|$version";
printResult($status, 'string',$version, 'string',);
#print "em_result=1\n";

# Get the pid list for the Apache Server 
# parameters:
#   install_home - the install home in which the Apache instance is running
sub getApacheStatus 

{
  my $conf_file = shift(@_);
  my $status  = 0;

  if( !(-e $conf_file) )
  {
      exit 1;
  }
  my $pidList = "";
  #my $httpd_pid_file = $install_home.$sep."logs".$sep."httpd.pid";

#  my $httpd_pid_file = getPidFile($conf_file);
my $hash = parseConfFile($conf_file);
my $serverRoot = peek($$hash{'ServerRoot'});
my $httpd_pid_file = peek($$hash{'PidFile'});
#print "pid file value from parser",$httpd_pid_file,"\n";

if(defined $httpd_pid_file) {
if(!-e $httpd_pid_file) {
$httpd_pid_file =  File::Spec->catfile($serverRoot,$httpd_pid_file);
}

}
else {
$httpd_pid_file = File::Spec->catfile($serverRoot,"logs","httpd.pid");
}
#print "pid file full path",$httpd_pid_file,"\n";

  my $pidFound = 0; 
  my $pid;
  


  
 # The process id of apache server
    if(!(-e $httpd_pid_file) )
     {
             return 0;
     }
    
    open(process_id_file, $httpd_pid_file);
    while( $pid = <process_id_file> )
    {
        chomp( $pid );
        if($pid =~ m/[0-9]+/)
        {
	    $pidFound = 1;
            last;
        }
    }
    close process_id_file;
   
    if($pidFound==0)
   {
       return 0;
   }


  if ($osType eq "MSWin32")
  {


		    my $ps_output = `wmic process  where processid=$pid get ProcessId`;

		    # Get the ps output lines and walk through them Looking for the pids
		    my $line;
		    my @lines = split( "\n", $ps_output );
		    my @tokens;
		    foreach $line (@lines)
		    {
				chomp($line);
				$line  =~ s/\s+$//;
			    if($line eq $pid)
			    {
                    $status = 1 ;    
			    }
		    } # end foreach line
		

  } 
  
  # For Linux
  else 
  {
   
#		    # The ps command is platform specific
		    my $ps_command = getPsCommand();

		    # Get the apache pids from ps
		    # The output will be in the following form:
		    # USER       PID %CPU %MEM   SZ  RSS TT       S    START  TIME COMMAND
		    # my $key = getHttpServerKey( $install_home );
		    # For standalone apache key will be install homw
		    my $key = "httpd";
		    my $ps_output = `$ps_command | egrep "$key"`;
		    #print "$ps_command | egrep $key\n";

		    # Get the ps output lines and walk through them Looking for the pids
		    my $line;
		    my @lines = split( "\n", $ps_output );
		    my @tokens;
		    foreach $line (@lines)
		    {
			    #print $line . "\n";
			    @tokens = split( " ", $line );
			    #print "$tokens[10]\n";
			    if($tokens[$LONG_PS_CMD_PID_COL] eq "$pid")
			    {
                    #print "\n PS LINE  = $line ";
                    $status = 1 ;    
				    # Get the pid; it is the second token
				    if( $pidList eq "" )
				    {
					    $pidList = "$tokens[$LONG_PS_CMD_PID_COL]";
				    } 
				    else
				    {
					    $pidList = "$pidList,$tokens[$LONG_PS_CMD_PID_COL]";
				    }
			    }
		    } # end foreach line


		  } # end if MSWin32
          # print "\n returning status  = $status";
  return $status; 
}

# Get the version for the Apache Server 
# parameters:
#   install_home - the install home in which the Apache instance is running
sub getApacheVersion 
{
  my $binaries_home = shift(@_);
  my $command = "";

  # on Win32, get the pids from DMS
  if ($osType eq "MSWin32" || $osType eq "Windows_NT")
  {
	      $command =   File::Spec->catfile($binaries_home,"Apache.exe");
	 if( !-e $command )
     {
	      $command =   File::Spec->catfile($binaries_home,"httpd.exe");
      }

  } 

  # For linux
  else   
  {
      $command = File::Spec->catfile($binaries_home,"httpd");
      # print "\nFInding the version command  = $command";
      
  } # end if MSWin32
  
  my $output = `"$command" -v`;
  #print $output."\n";
  #print "$ps_command | egrep $key\n";
  #

  # Get the ps output lines and walk through them Looking for the pids
  my @lines = split( "\n", $output );

  chomp($lines[0]);
  #print "$lines[0]\n";
  if($lines[0] =~ m/Apache\//)
  {
      my @tokens = split("Apache\/", $lines[0]);
      #print $tokens[1];
      chomp($tokens[1]);
      return $tokens[1];
  }  
  return "";
}

# Get a ps command that returns the the username followed by the pid
# plus the full command line.  Note that this command is plateform
# specific.
sub getPsCommand
{
  $ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/lib";

  my $osType = `uname -s`;
  chomp($osType);

  SWITCH:
  {
    $osType eq "SunOS" && do
    {
      return "/usr/ucb/ps auxww";
    };
    $osType eq "HP-UX" && do
    {
      $ENV{UNIX95} = "XPG4";
      return "/bin/ps -efxo user,pid,pcpu,comm";
    };
    $osType eq "Linux" && do
    {
      return "/bin/ps auxww";
    };
    die "Unsupported Operating System\n";
  }
}

