#!/usr/local/bin/perl
# 
# $Header: appmbeansdiscovery.pl 21-mar-2007.13:04:24 jsmoler Exp $
#
# appmbeansdiscovery.pl
# 
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
#    NAME
#      appmbeansdiscovery.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     03/21/07 - emSDK log4j cutover
#    spandita    02/09/05 - changes for LibraryPath 
#    kchander    01/28/05 - kchander_discoverappmbeans
#    kchander    01/19/05 - 
#    spandita    01/14/05 - Creation
#
discover(@ARGV);
sub discover
{
    open(LOG,">mbeansdiscover.txt") || die $!;
    my $args = @_[0];
    print LOG "Args Are$args\n";

    my $libPath = @_[1];
    print LOG "Library Path=$libPath\n";
    
    my $result;
    my $oraHome = $ENV{ORACLE_HOME};
    my $targetType;
    if ( $args =~ m/weblogic_j2eeserver/)
    {
        $targetType="weblogic_j2eeserver";
    }
    else
    {
        $targetType="websphere_j2eeserver";
    }
    my $classpath = getClasspath($targetType, $libPath, $oraHome);
    
    $command = 
    "java -cp ".$classpath." oracle.sysman.util.discover.AppMBeanDiscovery  ".$args;

    print LOG "Command is$command\n";
    $result =`$command`;
    print $result;
}

sub getClasspath
{
    my $type = @_[0];
    my $libpath = @_[1];
    my $oraHome = @_[2];
    my $classpath;
    if($type eq "weblogic_j2eeserver")
    {
        $classpath= $oraHome."/lib/xmlparserv2.jar:".$libpath."/weblogic.jar:".$oraHome."/emagent/lib/emagentSDK.jar:".$oraHome."/dms/lib/dms.jar:".$oraHome."/dms/lib/ojdl.jar";
    }
    else
    {
        $classpath = $libpath."/lib/admin.jar:".$libpath."/lib/jmxc.jar:".$libpath."/lib/wsexception.jar:".$libpath."/lib/wasjmx.jar:".$libpath."/lib/wlmclient.jar:".$libpath."/lib/soap.jar:".$libpath."/lib/idl.jar:".$libpath."/java/jre/lib/security.jar:".$libpath."/java/jre/lib/ext/mail.jar:".$libpath."/java/jre/lib/ext/log.jar:".$oraHome."/lib/xmlparserv2.jar:".$oraHome."/emagent/lib/emagentSDK.jar:".$oraHome."/dms/lib/dms.jar:".$oraHome."/dms/lib/ojdl.jar";            
    }

    return $classpath;
}
