#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/bi/biadmin.pl /st_emasgc_11.1/1 2009/12/07 22:13:10 vdwaram Exp $
#
# biadmin.pl
# 
# Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      biadmin.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vdwaram     11/19/09 - Bug# 8221097
#    vdwaram     11/12/09 - Big# 8225138
#    ckannusa    06/11/07 - Creation
#    ckannusa    06/11/07 - Creation
#
use biutil;
my $oper = $ARGV[0];
my $target;
my $type;
my $hostname;
my $port;
my $username;
my $password;
my $lib;
my $keystoreFilename;
my $oraHome = $ENV{ORACLE_HOME};
my $biHome,$biDatahome;
my $dacHome = "";
my $is64BitMode = "NO";

my $MSG_START_ANS	=	"Oracle BI Server startup initiated";
my $MSG_START_CC	=	"Oracle BI Cluster Controller startup initiated";
my $MSG_START_PS	=	"Oracle BI Presentation Services startup initiated";
my $MSG_START_PS_HOST	=	"Oracle BI Java Host startup initiated";
my $MSG_START_SCH	=	"Oracle BI Scheduler startup initiated";
my $MSG_START_DAC	=	"TBD";


my $MSG_STOP_ANS	=	"Shutting down Oracle BI Server";
my $MSG_STOP_CC		=	"Shutting down Oracle BI Cluster Controller";
my $MSG_STOP_PS		=	"Stopping Oracle BI Presentation Services";
my $MSG_STOP_SCH	=	"Shutting down Oracle BI Scheduler";
my $MSG_STOP_DAC	=	"TBD";
#require $oraHome."/sysman/admin/scripts/emd_common.pl";

foreach $t (@ARGV)
{
	#print TEST  "in for loo : $t\n";
    my @arg = split("=", $t);
    if ($arg[0] eq "targetName")
    {
        $target = $arg[1];
    }
    elsif ($arg[0] eq "targetType")
    {
        $type = $arg[1];
    }
    elsif ($arg[0] eq "MachineName")
    {
        $hostname = $arg[1];
    }
    elsif ($arg[0] eq "Port")
    {
        $port = $arg[1];
    }
    elsif ($arg[0] eq "BIHome")
    {
        $biHome = $arg[1];
    }
    elsif ($arg[0] eq "BIDataHome")
    {
        $biDataHome = $arg[1];
    }
    elsif ($arg[0] eq "is64BitMode")
    {
        $is64BitMode = $arg[1];
    }
    elsif ($arg[0] eq "DACHOME")
    {
        $dacHome = $arg[1];
    }
}
my $os=biutil::get_osType();
if ($os eq 'WIN')
{
	my $status;
	if ($type  eq "oracle_bi_dac") {
		$status=&biutil::adminDACWindows($target,$oper,$biHome,$dacHome);
	}
	else
	{
		my $winServiceName=&biutil::getWindowsService($type);
		#print "Service Name $winServiceName";
		$status=&biutil::adminWindowsService($target,$winServiceName,$oper);
	}
	print $status;
}
else
{
	my $statusLinux;
	if ($type  eq "oracle_bi_dac") {
		$statusLinux=&biutil::adminDACLinux($target,$oper,$biHome,$dacHome);
	}
	else
	{
		$statusLinux=&biutil::execCommandLinux($oper,$biHome,$biDataHome,$type,$target,$is64BitMode);
	}
	print $statusLinux;
}
