#!/usr/local/bin/perl

use strict;
use biutil;
my @procs;
my $prog = $ARGV[0];
my $rc = 0;

my $os=biutil::get_osType();
if ($os eq 'WIN')
{
	my $status;
	if ($ARGV[1] eq "com.siebel.etl.net.QServer")
	{
		$prog=$prog."\\DAC ".$ARGV[1];
		$status=biutil::getWindowsStatusDAC($prog);
	}
	else
	{
		$status=biutil::getGetWindowsStatus($prog);
	}
	if($status == 0){
		print "em_result=0\n";
	}
	else{
		print "em_result=1\n";
	}
	
}
elsif($os eq 'SOL'){
    if ($ARGV[1] eq "com.siebel.etl.net.QServer")
    {
        $prog=$ARGV[1];	
        $rc=biutil::getDACStatusForSolaris($ARGV[0]);                
    }
    else
    {
        @procs = `/usr/ucb/ps -aguxwww`;
        foreach my $line (@procs){
            if ( ($line =~ /$prog/i) and ($line !~/getStatus.pl/i)){
               $rc = 1;
               last;
            }
        }
            
    }

    if($rc == 0){
        print "em_result=0\n";
    }
    else{
        print "em_result=1\n";
    } 
}
else
{
	if ($ARGV[1] eq "com.siebel.etl.net.QServer")
	{
		$prog=$ARGV[1];	
                $rc=biutil::getDACStatusForLinux($ARGV[0]);
                
	}
        else
        {
            @procs = `ps -ef`;
            foreach my $line (@procs){
                    if ( ($line =~ /$prog/i) and ($line !~/getStatus.pl/i)){
            #	print "The Selected :: $line";
                            $rc = 1;
                            last;
                    }
            }
            
        }

	if($rc == 0){
		print "em_result=0\n";
	}
	else{
		print "em_result=1\n";
	}
}

