#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/bi/procResUsage.pl /main/6 2010/03/30 08:54:14 vdwaram Exp $
#
# procResUsage.pl
# 
# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      procResUsage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vdwaram     03/29/10 - Bug# 9466486
#    vdwaram     11/18/09 - Bug# 8225138
#    vdwaram     11/11/09 - Bug# 9084910
#    vdwaram     05/12/09 - Fix for bug# 8508310
#    vdwaram     05/22/08 - Fix for solaris
#    msathe      05/17/07 - process resource usage script. developed for BI
#                           processes
#    msathe      05/17/07 - Creation
# 
use biutil;
@processList = ();
@sortProcessList = ();
%topPmemS = ();
%topProcS = ();
$count=0;
$result="";
$processName = $ARGV[0].$ARGV[1];
my $os=biutil::get_osType();
if ($os eq 'WIN')
{	
	my $cpu,$memory;
	if ($ARGV[1] eq "com.siebel.etl.net.QServer")
	{
		$prog=$ARGV[0]."\\DAC ".$ARGV[1];
		($cpu,$memory)=biutil::getWindowsResourcesDAC($prog);
	}
	else
	{
		($cpu,$memory)=biutil::getGetWindowsResources($processName);
	}
	print"em_result=".$cpu."|".$memory."\n";
}
else
{
	if ($ARGV[1] eq "com.siebel.etl.net.QServer")
	{
		$processName=$ARGV[1];
		
	}
#print"process: $processName";
 $ENV{PATH} = "/usr/bin:/usr/sbin:/bin:/usr/local/bin";
# Get the type of Operating System
chomp ($os = `uname -s`) or die "em_error=Could not run uname -s\n";
SWITCH: {
  $os eq "SunOS" && do {
                         chomp ($ver = `uname -r`);
                         if ( $ver !~ /^4./ ) {
			     $os = "SOL";
                             @processList = `/bin/ps -efo \"pcpu, rss, pid, args\" | grep "$processName" | egrep -v "pcpu, rss, pid, args|grep $processName|procResUsage"`;
                              for
                                $result (@processList) {

                                $rc = 1;
                                if ($ARGV[1] eq "com.siebel.etl.net.QServer") {
                                    $rc = 0;
                                    $processID=$result;
                                    $processID =~s/\s+/\|/g;
                                    $processID =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$3/;
                                    $processID =~s/\|(.*)/$1/;

                                    my $lsContent=`ls -l /proc/$processID/fd/`;
                                    if ($lsContent =~/$ARGV[0]/){
                                            $rc = 1;
                                    } else {
                                        if  (-e "/proc/$processID/fd") {
                                            if(-r "/proc/$processID/fd"){
                                            }else {
                                                $rc = 1;
                                            }
                                        }
                                    }
                                }
                                    
                                if ($rc eq "1") {
                                    $result =~s/\s+/\|/g;
                                    $result =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$1\|$2/;
                                    $result =~s/\|(.*)/$1/;
                                    print "em_result=$result";
                                    last SWITCH;
                                }
                              }
                             last SWITCH;
                         }
                       };
  $os eq "HP-UX" && do {
                            $ENV{UNIX95} = "XPG4";
			    $os = "HP-UX";
			    $pgsize=`getconf SC_PAGE_SIZE`;
                            @processList = `/bin/ps -efo "pcpu vsz pid args" | grep "$processName" | egrep -v "pcpu vsz pid args|grep $processName|procResUsage"`;
                              for
                                $result (@processList) {

                                $rc = 1;
                                if ($ARGV[1] eq "com.siebel.etl.net.QServer") {
                                    $rc = 0;
                                    $processID=$result;
                                    $processID =~s/\s+/\|/g;
                                    $processID =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$3/;
                                    $processID =~s/\|(.*)/$1/;

                                    my $lsContent=`ls -l /proc/$processID/fd/`;
                                    if ($lsContent =~/$ARGV[0]/){
                                            $rc = 1;
                                    } else {
                                        if  (-e "/proc/$processID/fd") {
                                            if(-r "/proc/$processID/fd"){
                                            }else {
                                                $rc = 1;
                                            }
                                        }
                                    }
                                }

                                if ($rc eq "1") {
                                    $result =~s/\s+/\|/g;
                                    $result =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$1\|$2/;
                                    $result =~s/\|(.*)/$1/;
                                    print "em_result=$result";
                                    last SWITCH;
                                }
                              }

                            last SWITCH; 
                       }; 
  $os eq "Linux" && do { 
			      $os = "Linux";
			      @processList = `/bin/ps -www -eo "pcpu rss pid args" | grep "$processName" | egrep -v "pcpu rss pid args|grep $processName|procResUsage"`;
			      for 
			    	$result (@processList) {

                                $rc = 1;
                                if ($ARGV[1] eq "com.siebel.etl.net.QServer") {
                                    $rc = 0;
                                    $processID=$result;
                                    $processID =~s/\s+/\|/g;
                                    $processID =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$3/;
                                    $processID =~s/\|(.*)/$1/;

                                    my $lsContent=`ls -l /proc/$processID/fd/`;
                                    if ($lsContent =~/$ARGV[0]/){
                                            $rc = 1;
                                    } else {
                                        if  (-e "/proc/$processID/fd") {
                                            if(-r "/proc/$processID/fd"){
                                            }else {
                                                $rc = 1;
                                            }
                                        }
                                    }
                                }
                                    
                                if ($rc eq "1") {
                                    $result =~s/\s+/\|/g;
                                    $result =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$1\|$2/;
                                    $result =~s/\|(.*)/$1/;
                                    print "em_result=$result";
                                    last SWITCH;
                                }
			      }
			      last SWITCH;
                       };
  $os eq "AIX" && do {
                              @processList = `/bin/ps -efo "pcpu rssize pid args" | grep "$processName" | egrep -v "pcpu rssize pid args|grep $processName|procResUsage"`;
                              for
                                $result (@processList) {

                                $rc = 1;
                                if ($ARGV[1] eq "com.siebel.etl.net.QServer") {
                                    $rc = 0;
                                    $processID=$result;
                                    $processID =~s/\s+/\|/g;
                                    $processID =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$3/;
                                    $processID =~s/\|(.*)/$1/;

                                    my $lsContent=`ls -l /proc/$processID/fd/`;
                                    if ($lsContent =~/$ARGV[0]/){
                                            $rc = 1;
                                    } else {
                                        if  (-e "/proc/$processID/fd") {
                                            if(-r "/proc/$processID/fd"){
                                            }else {
                                                $rc = 1;
                                            }
                                        }
                                    }
                                }

                                if ($rc eq "1") {
                                    $result =~s/\s+/\|/g;
                                    $result =~s/\|(.+?)\|(.+?)\|(.+?)\|(.*)/\|$1\|$2/;
                                    $result =~s/\|(.*)/$1/;
                                    print "em_result=$result";
                                    last SWITCH;
                                }
                              }
                              last SWITCH;
                     };
  $os eq "OSF1" && do {
                            @processList = `ps -eo "pmem pcpu time vsz rss user pid args"`;
                            last SWITCH;
                       };
  die "em_error=Unupported Operating System\n";
}

}

