package biutil;

use Exporter;
use ias::simpleXPath;
use Time::Local;
@ISA         = ('Exporter');
@EXPORT_OK      = ('getDefaultAttribs','trim','getPropValues','isMemoryUnit','convert2KB','get_osType','getContent','getWinEnvVariables','getOC4JConfigs','getIISConnectStrFor7Dot8','getSchConfigFromRegistry','parseHostPortSchedulerAssoc','getOC4JSSLConfig','getConfigFilePath','getDSNHostPortForPS','getHostNameForIP','getVersion','execCommandLinux');
my  %hashAdmin = (
	'oracle_bi_ans' => {
		'start_script'=>'/setup/run-sa.sh',
		'stop_script'=> '/setup/run-sa.sh', 
		'start_msg'=>'Oracle BI Server started',
                'start_msg64'=>'Oracle BI Server \(64-bit\) started',
		'stop_msg'=>'Oracle BI Server shutdown',
		'log_path'=>'/server/Log/NQServer.log'},
	
	'oracle_bi_cc' => {
		'start_script'=>'/setup/run-ccs.sh',
		'stop_script'=> '/setup/run-ccs.sh', 
		'start_msg'=>'Cluster Controller started',
                'start_msg64'=>'Cluster Controller started',
		'stop_msg'=>'Cluster Controller exiting',
		'log_path'=>'/server/Log/NQCluster.log'},

	'oracle_bi_ps' => {
		'start_script'=>'/setup/run-saw.sh',
		'stop_script'=> '/setup/run-saw.sh', 
		'start_msg'=>'Oracle BI Presentation Services have started successfully',
                'start_msg64'=>'Oracle BI Presentation Services have started successfully',
		'stop_msg'=>'Oracle BI Presentation Services are shutting down',
		'log_path'=>'/web/log/sawserver.out.log'},

	'oracle_bi_sch' => {
		'start_script'=>'/setup/run-sch.sh',
		'stop_script'=> '/setup/run-sch.sh', 
		'start_msg'=>'Service started',
                'start_msg64'=>'Service started',
		'stop_msg'=>'Service stopped',
		'log_path'=>'/server/Log/NQScheduler.log'},

	'oracle_bi_dac' => {
		'start_script'=>'/DAC/startserver.sh',
		'stop_script'=> '/DAC/stopserver.sh', 
		'start_msg'=>' ',
		'stop_msg'=>' ',
		'log_path'=>' '},
	 );
my $INTERVAL=2;
my $RETRY=15;
sub trim($)
{
        my $string = shift;
        $string =~ s/^\s+//;
        $string =~ s/\s+$//;
        return $string;
}

sub isMemoryUnit
{
        my $config = shift(@_);
        my $value  = shift(@_);
        if ( ($config =~ /SIZE$/) and ( ( $value=~/KB/i ) or ( $value=~/MB/i ) or ( $value=~/GB/i ) ) )
        {
                return "TRUE";
        }
        else 
        {       
                return "FALSE";
        }

}
sub convert2KB
{
        my $sizeKB=0;
        my $value  = shift(@_);
        if  ( $value=~/KB/i )
        {
                $sizeKB = substr($value,0,-2);
        }
        elsif  ( $value=~/MB/i )
        {
                $sizeKB = substr($value,0,-2);
                $sizeKB=$sizeKB*1024;
        }
        elsif  ( $value=~/GB/i )
        {
                $sizeKB = substr($value,0,-2);
                $sizeKB=$sizeKB*1024*1024;
        }
        return $sizeKB;
}
sub getConfigFilePath
{
	my $oracleHome = shift(@_);
	my $targetType = shift(@_);
	my $configPath;
	my $version =getVersion($oracleHome);
	if ($version=~/^7.8/)
	{
		$path="/Config/";
	}
	else 
	{
		$path="/server/Config/";
	} 

	if ($targetType eq "oracle_bi_ans")
	{
		$configPath=sprintf("%s%s", $path, "NQSConfig.INI");
	}
	elsif ($targetType eq "oracle_bi_cc")
	{
		$configPath=sprintf("%s%s", $path, "NQClusterConfig.INI");
	}
	return $configPath;

}
sub getVersion
{
	my $version;
	my $oracleHome= shift(@_);
	my $versionFile="version.txt";
	my $versionPath=sprintf("%s/%s",$oracleHome,$versionFile);
	if(-f $versionPath)
	{
		open FILE,$versionPath;
		while( $line = <FILE>)
		{
				my $index=index($line,"Oracle Business Intelligence");
				if ($index ne -1 )
				{
						$version=substr($line,($index+length("Oracle Business Intelligence")+1));
				}
		}
		close FILE;
	}
	else
	{
		$versionPath=sprintf("%s%s%s",$oracleHome,"/Document/",$versionFile);
		if(-f $versionPath)
		{
			open FILE,$versionPath;

			while( $line = <FILE>)
			{
					my $index=index($line,"Siebel Analytics");
					if ($index ne -1 )
					{
							$version=substr($line,($index+length("Siebel Analytics")+1));
					}
			}
			close FILE;
		}


	}
	$version=~s/\s//;
	return $version;
}
sub getDefaultAttribs
{
        my $file=shift(@_);
        my $path=shift(@_);
        my @startParams =ias::simpleXPath::simpleXPathQueryForNodes($file,$path);
        my %allAttribs;
        for my $resultRef (@startParams)
        {
                my %somemap = %$resultRef;
                my @attribs=split('\n',ias::simpleXPath::getStringValue($resultRef));
                my $name=trim($attribs[1]);
                my $value=trim($attribs[6]);
                $allAttribs{$name}=$value;
        }
#       while(($key,$value)=each %AllAttribs)
#        {
#               print "$key is $AllAttribs{$key}  \n";
#        }
 return %allAttribs;
}
sub getOC4JConfigs
{
        my $filename=shift(@_);
        my %allAttribs;
		my $configQry="web-app/servlet/init-param";
		my @confRoot = ias::simpleXPath::simpleXPathQueryForNodes($filename,$configQry);
		for my $resultRef (@confRoot)
		{
			#print simpleXPath::getStringValue($resultRef);
	        my @childRef=ias::simpleXPath::getChildren($resultRef,"param-name");
		    my $name = trim(ias::simpleXPath::getStringValue(@childRef));
	        my @childRefVal=ias::simpleXPath::getChildren($resultRef,"param-value");
		    my $value = trim(ias::simpleXPath::getStringValue(@childRefVal));
			$allAttribs{$name}=$value;
		}
		 return %allAttribs;


}
sub getPropValues
{
	my %props;
        my $commonFile = shift(@_);
        open (COMMONFILE, $commonFile);
        my $SAROOTDIR;
        my $SADATADIR;
        $count = 0;
        while ($record = <COMMONFILE>)
        {
		$record=trim($record);
		if(index($record,"#") == 0) 
		{
			next;
		}
                my $eqIndex=index($record,"=");
                my $name = substr($record,0,$eqIndex);
                my $value = substr($record,$eqIndex+1);
		$name=trim($name);
		$value=trim($value);
                $props{$name}=$value;
		

		$count++;
              #print $record;
           }
        close(COMMONFILE);
        return %props;
	
}
sub getContent()
{
	my $content = shift(@_);
	open FILE, $content or die "Couldn't open file: $!";
	$string = join("", <FILE>); 
	close (FILE);
	return $string;
}
sub getWinEnvVariables
{
	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $saroot = $Registry->{"HKEY_LOCAL_MACHINE/SYSTEM/CurrentControlSet/Control/Session Manager/Environment/SAROOTDIR"};
	my $sadata = $Registry->{"HKEY_LOCAL_MACHINE/SYSTEM/CurrentControlSet/Control/Session Manager/Environment/SADATADIR"};
	$saroot=trim($saroot);
	$sadata=trim($sadata);
	if(length($saroot)==0)
	{
		$saroot = $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Common/7.8/ProgramDir"};
		$saroot=trim($saroot);
	}
	if(length($sadata)==0)
	{
		$sadata = $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Common/7.8/DataDir"};
		$sadata=trim($sadata);
	}
	
	return $saroot,$sadata;
}
sub getDSNHostPortForPS
{
	my $dsn = shift(@_);
	my $hostQry,$portQry,$ecmTarget,$secClustQry;
	my $secClust="";
	$portQry=sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/Port");
	my $isClusteredQry =sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/IsClusteredDSN"); 

	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $isClustered = $Registry->{$isClusteredQry};
	if (lc($isClustered) eq "yes")
	{
		$hostQry=sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/PrimaryCCS");  
		$secClustQry=sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/SecondaryCCS");  
		$secClust = $Registry->{$secClustQry};
		$ecmTarget="oracle_bi_cc";
	}
	else
	{
		$hostQry=sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/ServerMachine"); 
		$ecmTarget="oracle_bi_ans";
	}

	my $server = $Registry->{$hostQry};
	my $port = $Registry->{$portQry};
	
	$server=trim($server);
	$port=trim($port);
	$secClust=trim($secClust);	
	return $ecmTarget,$server,$port,$secClust;
}

sub parseHostPortSchedulerAssoc
{
	#format host:port
	my $url = shift(@_);
	my $index = rindex($url,":");
	my $host,$port;
	if ($index == -1 )
	{
		$host=$url;
		$port="9705";
	}
	else
	{
		$port=substr($url,$index+1);
		$host=substr($url,0,$index);
	}
	$host=trim($host);
	$port=trim($port);
	return $host,$port;

}
sub getIISConnectStrFor7Dot8
{
	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $connectStr = $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Web/7.8/ISAPI/ServerConnectString"};
	my $indexColon = rindex($connectStr,":");
	my $indexPtcl = rindex($connectStr,"/");
	my $port=substr($connectStr,$indexColon+1);
	my $host=substr($connectStr,0,$indexColon);
	$host=substr($host,$indexPtcl+1);
	$host=trim($host);
	$port=trim($port);
	return $host,$port;

}
sub getOC4JSSLConfig
{
	#hard coded values for oc4j ssl config
	my $version = shift(@_);
	my $config = shift(@_);
	my $conVal;
	if ($version=~/^7.8/)
	{
		if ($config eq "address")
		{
			$conVal="com.siebel.analytics.web.SAWServer.Host";
		}
		elsif ($config eq "port")
		{
			$conVal="com.siebel.analytics.web.SAWServer.Port";
		}

	}
	else
	{
		if ($config eq "address")
		{
			$conVal="oracle.bi.presentation.sawserver.Host";
		}
		elsif ($config eq "port")
		{
			$conVal="oracle.bi.presentation.sawserver.Port";
		}
		elsif ($config eq "ssl")
		{
			$conVal="com.siebel.analytics.Secure";
		}
		elsif ($config eq "path")
		{
			$conVal="com.siebel.analytics.SSL.CertStoreFile";
		}
		elsif ($config eq "credentialAlias")
		{
			$conVal="com.siebel.analytics.SSL.CertAlias";
		}

	}
	return $conVal;
}
sub getSchConfigFromRegistry
{
	my $configQry = shift(@_);
	my $config = shift(@_);
	if ($configQry eq "ServerInstance")
	{
		$configQry="";
	}
	elsif ($configQry eq "ServerInstance/Mail")
	{
		$configQry="Mail";
	}
	elsif ($configQry eq "ServerInstance/iBots")
	{
		$configQry="IBots";
	}
	if ($config eq "SMTP_Port")
	{
		$config="SMTP Port";
	}
	elsif ($config eq "SMTP_Server")
	{
		$config="SMTP Server";
	}
	elsif ($config eq "Log_Dir")
	{
		$config="Log Dir";
	}

	elsif ($config eq "Web_Server")
	{
		$config="Web Server";
	}

	my $qry=sprintf("%s/%s/%s", "HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Scheduler/7.8",$configQry,$config); 
	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $value = $Registry->{$qry};
	$value=trim($value);
	return $value;
}
sub get_osType
{
    if (( $^O eq "Windows_NT") ||
        ( $^O eq "MSWin32")) {
        return "WIN";
    }

    my $os = `uname -s`;
    my $ver = `uname -r`;
    chomp ($os);

    if ( $os eq "SunOS" ) {
        if ( chomp($ver) !~ /^4./ ) {
            return "SOL";
        }
    } elsif ( $os eq "HP-UX" ) {
        return "HP";
    } elsif ( $os eq "Linux" ) {
        return "LNX";
    } elsif ( $os eq "AIX" ) {
        return "AIX";
    } elsif ( $os eq "OSF1" ) {
        return "OSF1";
    } elsif ( $os eq "Darwin" ) {
        return "MAC OS X";
    } else {
        # Unsupported Operating System
        return -1;
    }
}
sub getHostNameForIP
{
        my $server = shift(@_);
        my $temp=$server;
        $temp=~ s/\.//g;
        if ($temp =~ /^\d+$/)
        {
                my @numbers = split(/\./, $server);
                my $ip_number = pack("C4", @numbers);
                my ($name) = (gethostbyaddr($ip_number, 2))[0];
                if ($name)
                {
                        #print "The host is: $name";
                        return $name;
                }
                return $server;
        }
        else
        {
                return $server;
        }
}
sub getGetWindowsResources
{
	my $processName = shift(@_);
	eval 'use Win32::OLE qw(in);';	
	$processName=~s/\//\\/g;
        @startandend = split(/[0-9]\*\\/, $processName);
	$startandend[0] = lc($startandend[0]);
	$startandend[0]=~s/\\/\\\\/g;
	$startandend[1] = lc($startandend[1]);
	$startandend[1]=~s/\\/\\\\/g;
	#print "Process Name after $processName";
	my $strComputer = '.';
	my $intMaxMemKB = 1024 * 10000;
	#my $processName="C:\\OracleBI\\server\\Bin\\NQScheduler.exe";
	#my $processName="System Idle Process";
	my $objWMI = Win32::OLE->GetObject('winmgmts:\\\\' . $strComputer . '\\root\\cimv2');
	my $colProcesses = $objWMI->ExecQuery('Select * from Win32_Process');
	my $cpuTotal =0.0;
	my $cpuTarget=0.0;
	my $cpuUsedinSec=0.0;
	my $cpuPer=0.0;
	my $memUsage=0;
	foreach my $objProcess (in $colProcesses) {
		$cpuUsedinSec = ($objProcess->KernelModeTime + $objProcess->UserModeTime);
		$cpuTotal=$cpuTotal+$cpuUsedinSec;
		#my $exePath=$objProcess->ExecutablePath;
		my $exePath=$objProcess->ExecutablePath;		
                $exePath = lc($exePath);
		if ($exePath =~ m/$startandend[0].*$startandend[1].*\.exe/)
                {
			
			$cpuTarget= ($objProcess->KernelModeTime + $objProcess->UserModeTime);	
			#print  $objProcess->KernelModeTime . ','.$objProcess->ExecutablePath . ','. $objProcess->Name . ', ' . $objProcess->WorkingSetSize / 1024, "\n";
			$memUsage=$objProcess->WorkingSetSize / 1024;
		}
	}
	$cpuPer= (($cpuTarget*100) / $cpuTotal) ;	
	my $intVal= sprintf("%.2f",$cpuPer);
	return $intVal,$memUsage;
}
sub getGetWindowsStatus
{
	my $processName = shift(@_);
	eval 'use Win32::OLE qw(in);';	
	$processName=~s/\//\\/g;
        @startandend = split(/[0-9]\*\\/, $processName);
	$startandend[0] = lc($startandend[0]);
	$startandend[0]=~s/\\/\\\\/g;
	$startandend[1] = lc($startandend[1]);
	$startandend[1]=~s/\\/\\\\/g;
        my $strComputer = '.';
	my $objWMI = Win32::OLE->GetObject('winmgmts:\\\\' . $strComputer . '\\root\\cimv2');
	my $colProcesses = $objWMI->ExecQuery('Select * from Win32_Process');
	my $status=0;
	foreach my $objProcess (in $colProcesses) {
		my $exePath=$objProcess->ExecutablePath;		
	        $exePath = lc($exePath);
                if ($exePath =~ m/$startandend[0].*$startandend[1].*\.exe/) 
                {
				$status=1;
				#print "Wow found  matching string  for ...$processName";
				last;
		}
	}
	return $status;
}
sub getDACStatusForLinux
{
        my $className="com.siebel.etl.net.QServer";
        my $biHome = shift(@_);        
        @procs = `ps -ef|grep $className`;
        my $rc=0;
        foreach my $line (@procs){
                if ( ($line =~ /$className/i) and ($line !~/getStatus.pl/i) and ($line !~/biadmin.pl/i)  ){
                        my @data=split(' ', $line);
                        my $processID=$data[1];
                        my $lsContent=`ls -l /proc/$processID/fd/`;
                        if ($lsContent =~/$biHome/){
                                $rc = 1;
                                last;
                        }
                        if  (-e "/proc/$processID/fd") {
                            if(-r "/proc/$processID/fd"){
                            }else {
				if  (-e "/proc/$processID/fd") {
                                        $rc = 1;
                                        last;
                                }
                            }
                        }

                }
        }
        return $rc;

}

sub getDACStatusForSolaris
{
    my $className="com.siebel.etl.net.QServer";
    my $biHome = shift(@_);        
    @procs = `/usr/ucb/ps -aguxwww|grep $className`;
    my $rc=0;
    foreach my $line (@procs){
        if ( ($line =~ /$className/i) and ($line !~/getStatus.pl/i) and ($line !~/biadmin.pl/i)  ){
            my @data=split(' ', $line);
            my $processID=$data[1];
            unless (-e "/proc/$processID/fd") {
                next;
            }
            my $lsContent=`/usr/bin/pfiles $processID`;
            if ($lsContent =~/$biHome/){
                $rc = 1;
                last;
            }
        }
    }
    return $rc;

}

sub getWindowsStatusDAC
{
	my $processName = shift(@_);
	eval 'use Win32::OLE qw(in);';	
	$processName=~s/\//\\/g;
	$processName=~s/\\/\\\\/g;
	my $strComputer = '.';
	my $objWMI = Win32::OLE->GetObject('winmgmts:\\\\' . $strComputer . '\\root\\cimv2');
	my $colProcesses = $objWMI->ExecQuery('Select * from Win32_Process');
	my $status=0;	
	foreach my $objProcess (in $colProcesses) {
		my $exePath=$objProcess->CommandLine;	
		
		if($exePath =~/$processName$/i)
		{
				$status=1;				
				last;
		}
		
	}
	return $status;
}

sub getWindowsResourcesDAC
{
	my $processName = shift(@_);
	eval 'use Win32::OLE qw(in);';	
	$processName=~s/\//\\/g;
	$processName=~s/\\/\\\\/g;	
	#print "Process Name after $processName";
	my $strComputer = '.';
	my $intMaxMemKB = 1024 * 10000;
	#my $processName="C:\\OracleBI\\server\\Bin\\NQScheduler.exe";
	#my $processName="System Idle Process";
	my $objWMI = Win32::OLE->GetObject('winmgmts:\\\\' . $strComputer . '\\root\\cimv2');
	my $colProcesses = $objWMI->ExecQuery('Select * from Win32_Process');
	my $cpuTotal =0.0;
	my $cpuTarget=0.0;
	my $cpuUsedinSec=0.0;
	my $cpuPer=0.0;
	my $memUsage=0;
	foreach my $objProcess (in $colProcesses) {
		$cpuUsedinSec = ($objProcess->KernelModeTime + $objProcess->UserModeTime);
		$cpuTotal=$cpuTotal+$cpuUsedinSec;
		#my $exePath=$objProcess->ExecutablePath;
		my $exePath=$objProcess->CommandLine;		
		if($exePath =~/$processName$/i)
		{
			
			$cpuTarget= ($objProcess->KernelModeTime + $objProcess->UserModeTime);	
			#print  $objProcess->KernelModeTime . ','.$objProcess->ExecutablePath . ','. $objProcess->Name . ', ' . $objProcess->WorkingSetSize / 1024, "\n";
			$memUsage=$objProcess->WorkingSetSize / 1024;
		}
	}
	$cpuPer= (($cpuTarget*100) / $cpuTotal) ;	
	my $intVal= sprintf("%.2f",$cpuPer);
	return $intVal,$memUsage;
}
sub adminDACWindows
{
	my $targetName=  shift(@_);
	my $command = shift(@_);
	my $biHome = shift(@_);
        my $dacDir = shift(@_);
	
	#`set PATH=C:\OracleBI\server\Bin;C:\OracleBI\web\bin;%PATH%`;
	`echo off`;
	my $output1;
	my $dacHome=$biHome."\\DAC";
        if ($dacDir ne "")
        {
            $dacDir =~ s/\//\\/g;
            $dacHome = $dacDir;
        }
	chdir  $dacHome;
	my $count=0;
	my $status=-1;
	my $prog=$dacHome." com.siebel.etl.net.QServer";
	if ($command eq "stop") {

		system("start ".$dacHome."\\stopserver.bat");
                sleep(10);
		while($status != 0 && $count<=$RETRY)
		{
			sleep($INTERVAL);
			$status=getWindowsStatusDAC($prog);
			$count++;
		}
		if ($status==0){
			return getProcessStatusXML($targetName,"0","SUCCESS");
		}else{
			return getProcessStatusXML($targetName,"1","Unable to stop DAC server.Please check the logs.");
		}

	}elsif($command eq "start") {
		system("start ".$dacHome."\\startserver.bat");
                sleep(10);
		while($status != 1 && $count<=$RETRY)
		{
			sleep($INTERVAL);
			$status=getWindowsStatusDAC($prog);
			$count++;
		}
		if ($status==1){
			 return getProcessStatusXML($targetName,"0","SUCCESS");
		}else{
			 return getProcessStatusXML($targetName,"1","Unable to start DAC server.Please check the logs");
		}
	}		
	
		
}
sub adminDACLinux
{

	my $targetName=  shift(@_);
	my $command = shift(@_);
	my $biHome = shift(@_);
        my $dacDir = shift(@_);
	
	#`set PATH=C:\OracleBI\server\Bin;C:\OracleBI\web\bin;%PATH%`;	
	my $output1;
	my $dacHome=$biHome."/DAC";
        if ($dacDir ne "")
        {
            $dacHome = $dacDir;
        }
        
	#print $dacHome;
	chdir  $dacHome;
	if ($command eq "stop") {
		$scriptPath=$dacHome."/stopserver.sh &";
		$out= system($scriptPath);	
		  my $pid;
		  if ($pid = fork){ 
		    #parent
                    sleep(10);
                    my $status=biutil::getDACStatusForLinux($biHome);
                    my $count=0;
                    while($status != 0 && $count<=$RETRY)
                    {
                            sleep($INTERVAL);
                            $status=biutil::getDACStatusForLinux($biHome);
                            $count++;
                    }
                    if ($status==0){
                            return getProcessStatusXML($targetName,"0","SUCCESS");
                    }else{
                            return getProcessStatusXML($targetName,"1","Unable to stop DAC server.Please check the logs.");
                    }
     
		  }else    
		  {
			    #child
		    die "CANNOT FORK!!\n" unless defined $pid;
		    open(STDOUT, "/dev/null");    
		    {exec($scriptPath);};
		    exit(1);    
		  } 
	
	}elsif($command eq "start") {
		$scriptPath=$dacHome."/startserver.sh &";
		#$out= system($scriptPath);		
                 my $pid;

                  if ($pid = fork){
                    #parent
                    sleep(10);
                    my $status=biutil::getDACStatusForLinux($biHome);
                    my $count=0;
                    while($status != 1 && $count<=$RETRY)
                    {
                            sleep($INTERVAL);
                            $status=biutil::getDACStatusForLinux($biHome);
                            $count++;
                    }
                    if ($status==1){
                            return getProcessStatusXML($targetName,"0","SUCCESS");
                    }else{
                            return getProcessStatusXML($targetName,"1","Unable to start DAC server.Please check the logs.");
                    }
                  }else
                  {
                            #child
                    die "CANNOT FORK!!\n" unless defined $pid;
                    open(STDOUT, "/dev/null");
                    {exec($scriptPath);};
                    exit(1);
                  }


	}		
	#print "OUTPUT $output1";
	
		
}
sub getWindowsService()
{
	my $type=  shift(@_);
	if ($type eq "oracle_bi_ans")
	{
		return "Oracle BI Server";
	}
	elsif($type eq "oracle_bi_cc")
	{
		return "Oracle BI Cluster Controller";
	}
	elsif($type eq "oracle_bi_ps")
	{
		return "sawsvc";
	}
	elsif($type eq "oracle_bi_sch")
	{
		return "Oracle BI Scheduler";
	}
	return "";
}

sub adminWindowsService()
{
	eval 'use Win32::Service';
	eval 'use Win32::OLE;';
	my $targetName=  shift(@_);
	my $serviceName= shift(@_);
	my $command = shift(@_);
	my $TIMEOUTTRY=30;
	my $INTERVAL=2;#seconds
	my $erMsg;
	my %status =
		(1 => 'STOPPED',
	2 => 'START_PENDING',
	3 => 'STOP_PENDING',
	4 => 'RUNNING',
	5 => 'CONTINUE_PENDING',
	6 => 'PAUSE_PENDING',
	7 => 'PAUSED',
	8 => 'ERROR');

	$ADsPath = "WinNT://./$serviceName,service";
	$s = Win32::OLE->GetObject($ADsPath) or "die Unable to retrieve the object for $ADsPath\n";
	my $cur_status = $status{$s->{status}};
	if ( $command eq "stop")
	{		
		$s->Stop();
	}
	if ( $command eq "start")
	{
		$s->Start();
	}

	if ( $command eq "restart")
	{
		$s->Stop();
		sleep(60);
		$s->Start();
	}
	$cur_status = $status{$s->{status}};
	my $count=0;
	while( ($cur_status eq "START_PENDING" || $cur_status eq "ERROR" ||  $cur_status eq "STOP_PENDING" ||$cur_status eq "") && $count<=$TIMEOUTTRY)
	{
		sleep($INTERVAL);
		$cur_status = $status{$s->{status}};
		$count++;		

	}

	if ( $cur_status eq "START_PENDING" || $cur_status eq "ERROR" ||  $cur_status eq "STOP_PENDING")
	{
		$erMsg="Timed Out.";
	}

	if( ( ($command eq "start") ||   ($command eq "restart")) && ($cur_status eq "RUNNING"))
	{
		return getProcessStatusXML($targetName,"0","SUCCESS");
	}
	elsif( ($command eq "stop") && ($cur_status eq "STOPPED"))
	{

		return getProcessStatusXML($targetName,"0","SUCCESS");
	}
	else
	{
		if ($cur_status eq "")
		{
			$erMsg=$erMsg."Could not complete command [".$command."] - Windows OLE unable to control Service ,Status :: Unknown";
		}
		else
		{
			$erMsg=$erMsg."Could not complete command [".$command."] - Windows OLE Service Status :: ".$cur_status;
		}
		return getProcessStatusXML($targetName,"1",$erMsg);
	}
}

sub getProcessStatusXML()
{	
	my $targetName=  shift(@_);
	my $exitCode=  shift(@_);
	my $respMessage= shift(@_);
	my $target = "localhost";
	my $responseXML = "<Responses><Response><ExitCode>".$exitCode."</ExitCode><ResponseMessage>".$respMessage."</ResponseMessage><TargetName>".$targetName."</TargetName></Response></Responses>";
	return $responseXML;
}
sub execCommandLinux
{
	my $oper=shift(@_);
	my $biHome=shift(@_);
	my $biDataHome=shift(@_);
	my $targetType=shift(@_);
	my $targetName=shift(@_);
        my $is64BitMode=shift(@_);
	my $now=`date +%s`;
	my $log_path;
	if($targetType eq "oracle_bi_ps")
	{
		$log_path=$biDataHome.$hashAdmin{'oracle_bi_ps'}->{'log_path'};
	}
	elsif($targetType eq "oracle_bi_dac")
	{
		if($oper eq "start")
		{
			my $exeScriptDAC=$biHome.$hashAdmin{$targetType}->{'start_script'};
			my $outputDAC = `$exeScriptDAC`;		
		}
		elsif ($oper eq "stop")
		{
			my $exeScriptDAC=$biHome.$hashAdmin{$targetType}->{'stop_script'};
			my $outputDAC = `$exeScriptDAC`;		
		}
		elsif ($oper eq "restart")
		{
			my $exeScriptDAC=$biHome."/DAC/stopstart.sh";
			my $outputDAC = `$exeScriptDAC`;	
		}
		return &getProcessStatusXML($targetName,"0","SUCCESS");
	}
	else
	{
		$log_path=$biHome.$hashAdmin{$targetType}->{'log_path'};
	}
	my $status=0;
	if($oper eq "start") 
	{
		my $exeScript=$biHome.$hashAdmin{$targetType}->{'start_script'}." "."start";
                my $start_msg='start_msg';
                if ($is64BitMode eq "YES") {
                    $exeScript = $exeScript."64";
                    $start_msg = $start_msg."64";
                }
		my $output = `$exeScript`;		
		$status =isCommandDone($now,$hashAdmin{$targetType}->{$start_msg},$log_path);
		my $count=0;
		while(($status == 0) && ($count <= $RETRY))
		{
			sleep($INTERVAL);
			$status =isCommandDone($now,$hashAdmin{$targetType}->{$start_msg},$log_path);
			$count++;
		}
		
	}
	elsif($oper eq "stop")
	{
		my $exeScript=$biHome.$hashAdmin{$targetType}->{'stop_script'}." "."stop";
		my $output = `$exeScript`;		
		$status =isCommandDone($now,$hashAdmin{$targetType}->{'stop_msg'},$log_path);
		my $count=0;
		while(($status == 0) && ($count <= $RETRY))
		{
			sleep($INTERVAL);
			$status =isCommandDone($now,$hashAdmin{$targetType}->{'stop_msg'},$log_path);
			$count++;
		}

	}
	elsif($oper eq "restart")
	{
		my $exeScript=$biHome.$hashAdmin{$targetType}->{'stop_script'}." "."stop";
		my $output = `$exeScript`;		
		sleep(20);
		my $exeScript=$biHome.$hashAdmin{$targetType}->{'start_script'}." "."start";
                my $start_msg='start_msg';
                if ($is64BitMode eq "YES") {
                    $exeScript = $exeScript."64";
                    $start_msg = $start_msg."64";
                }
		my $output = `$exeScript`;		
		$status =isCommandDone($now,$hashAdmin{$targetType}->{$start_msg},$log_path);
		my $count=0;
		while(($status == 0) && ($count <= $RETRY))
		{
			sleep($INTERVAL);
			$status =isCommandDone($now,$hashAdmin{$targetType}->{$start_msg},$log_path);
			$count++;
		}
	}
	if($status==0) 
	{
		my $erMsg="Unable to ".$oper." ".$targetName.".Please verify ".$log_path." for details";
		return &getProcessStatusXML($targetName,"1",$erMsg);		
	}
	elsif($status==1) 
	{
		return &getProcessStatusXML($targetName,"0","SUCCESS");		
	
	}
	
}
sub isCommandDone
{
	my $now =shift(@_);
	#my $now =`date +%s`;
	#my $now = `date -d 'Fri Jun 29 10:37:07 2007' +%s`;
	my $searchStr=shift(@_);
	my $file=shift(@_);
	my $dateReg1 = qr/[0-9]{4}-[0-9]{2}-[0-9]{2}\s[0-9]{2}:[0-9]{2}:[0-9]{2}/;
	my $dateReg2 = qr/[a-zA-Z]{3}\s[a-zA-Z]{3}\s[\w\s]{2}\s[0-9]{2}:[0-9]{2}:[0-9]{2}\s[0-9]{4}/;	
	open (COMMONFILE, $file);
        $count = 0;
	my $tsFound=0;
	my $os = get_osType();
        while ($record = <COMMONFILE>)
        {
		if($tsFound == 1)
		{
			if ($record=~/$searchStr/)
			{
				close COMMONFILE;
				return 1;
			}
		}
		else
		{

                	foreach $val ($record=~m/$dateReg1/g )
	                {
                            if (($os eq 'HP') or ($os eq 'AIX')) {
                                my $logTime= getDateRange1Time($val);
                                my $iff =$logTime-$now ;
                                if ($logTime >= $now) {$tsFound=1;}
                            }else {

                                my $logTime= `date -d '$val' +%s`;
                                my $iff =$logTime-$now ;
                                if ($logTime >= $now) {$tsFound=1;}
                            }
	                }
			if ($tsFound != 1)
			{
				foreach $val ($record=~m/$dateReg2/g )
	        	        {
                                    if (($os eq 'HP') or ($os eq 'AIX')) {
                                        my $logTime= getDateRange2Time($val);
                                        my $iff =$logTime-$now ;
                                        if ($logTime >= $now) {$tsFound=1;}
                                    } else {
                                        my $logTime= `date -d '$val' +%s`;
                                        my $iff =$logTime-$now ;
                                        if ($logTime >= $now) {$tsFound=1;}
                                    }
        	        	}
			}

		}

        }
	close COMMONFILE;
	return 0;

	
}

sub getDateRange2Time() {
        my $filetime =shift(@_);
        %mon2num = qw(
                jan 0  feb 1  mar 2  apr 3  may 4  jun 5 jul 6  aug 7  sep 8  oct 9 nov 10 dec 11
        );

        my @attribs=split('\s', $filetime);
        my $month = $mon2num{ lc substr($attribs[1], 0, 3) };
        my $year = $attribs[4];
        my $day = $attribs[2];

        my @attrib = split(':', $attribs[3]);
        my $hour =  $attrib[0];
        my $min = $attrib[1];
        my $sec =  $attrib[2];

        my $time = timelocal($sec, $min, $hour, $day, $month, $year);
        return $time;
#        return '12585350521';
}

sub getDateRange1Time() {
        my $filetime =shift(@_);
        %mon2num = qw(
                jan 0  feb 1  mar 2  apr 3  may 4  jun 5 jul 6  aug 7  sep 8  oct 9 nov 10 dec 11
        );

        my @attribs1=split('\s', $filetime);
        my @attrib1 = split(':', $attribs1[1]);
        my $hour = $attrib1[0];
        my $min = $attrib1[1];
        my $sec = $attrib1[2];
        my @attrib2 = split('-', $attribs1[0]);
        my $year = $attrib2[0];
        my $month = $attrib2[1] -1;
        my $day = $attrib2[2];

        my $time = timelocal($sec, $min, $hour, $day, $month, $year);
        return $time;
#        return '12585350521';
}


1;
# End of Program

