#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/cammMgrDeploy/adpmgr_remote_changepath.pl /main/4 2012/02/01 22:31:06 ajamil Exp $
#
# adpmgr_remote_changepath.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      adpmgr_remote_changepath.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajamil      02/01/11 - Creation
# 
use File::Path;
use File::Spec();
use IPC::Open3;
use IO::Handle;
use IO::Select;

#Secure and unsecure modes

my $PYTHON_SCRIPT = $ARGV[0];
my $local_weblogichostname = $ARGV[1];
my $local_weblogicportnumber = $ARGV[2];
my $connectiontype= $ARGV[3];
my $ExistingOMSServerName= $ARGV[4];
my $remoteServerName = $ARGV[5];
my $remote_wlhome= $ARGV[6];
my $jar_lib= $ARGV[7];
my $JAMMANAGER_DUMMY_LOCATION= $ARGV[8];
my $WL_HOME = $ARGV[9];
my $AGENT_STATE_DIR = $ARGV[10];
my $EMD_ROOT = $ARGV[11];

print("Printing parameters passed to perl script \n");
print("PYTHON_SCRIPT:  $PYTHON_SCRIPT \n");
print("local_weblogichostname: $local_weblogichostname \n");
print("local_weblogicportnumber: $local_weblogicportnumber \n");
print("connectiontype: $connectiontype \n");
print("ExistingOMSServerName: $ExistingOMSServerName \n");
print("remoteServerName: $remoteServerName \n");
print("remote_wlhome: $remote_wlhome \n");
print("jar_lib: $jar_lib \n");
print("JAMMANAGER_DUMMY_LOCATION: $JAMMANAGER_DUMMY_LOCATION \n");
print("Local WL home: $WL_HOME \n");

my $inp = <STDIN>;

my @values = split(',', $inp);

my $local_username = $values[0];
my $local_password = $values[1];

my $IS_WINDOWS = &IsWindows();

print("Operating system is windows:  $IS_WINDOWS \n");

my $KEYSTORE_LOC = File::Spec->catfile( $AGENT_STATE_DIR,'sysman','config','montrust','AgentTrust.jks');
print("Deploy command: \n");

my $DEPLOY_CMD = "$EMD_ROOT/jdk/bin/java -cp $WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true  -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC  weblogic.WLST $PYTHON_SCRIPT $local_weblogichostname $local_weblogicportnumber $local_username $local_password $connectiontype $ExistingOMSServerName $remoteServerName $remote_wlhome $jar_lib $JAMMANAGER_DUMMY_LOCATION  $IS_WINDOWS";

print("$DEPLOY_CMD \n");

print("python script path: $PYTHON_SCRIPT \n");


#system($DEPLOY_CMD);

#Deploying making sure of the failure/success status
# don't use select function for windows
my $STATUS="true";

if(&IsWindows())
   {

   local (*HANDLE_IN, *HANDLE_OUT);
   open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD)  or die "open3 failed $!\n" ;


    my $nextLine;
    while(<HANDLE_OUT>) {		
        $nextLine= $_;	
        print $nextLine;

        # i for case insensitive match
        if($nextLine =~ m/ERROR | Exception | WLSTException | Traceback/i) {
            $STATUS = "false";
        }
    }
 
	close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
    close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
}
else
{
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR); 
        open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD);

        my $sel = new IO::Select; 
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

        while(my @ready = $sel->can_read) { 
            foreach my $fh (@ready) 
            {
                my $line = <$fh>; 
                if(not defined $line){
                    $sel->remove($fh); 
                    next;              
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {     
                    print $line; 

                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print  $line;
                    $STATUS = "false";
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
}

if( $STATUS eq "false" ) 
{	exit -1;}
else
{	exit 0;}

#End	

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
