#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/cammMgrDeploy/deployADP.pl /main/9 2012/02/01 22:31:06 ajamil Exp $
#
# deployADP.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      deployADP.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajamil      11/26/10 - Creation
# 
use File::Path;
use File::Spec();
use IPC::Open3;
use IO::Handle;
use IO::Select;

#Secure and unsecure modes
my $PYTHON_SCRIPT= $ARGV[0];
my $WL_HOME= $ARGV[5];		
my $SERVERNAME = $ARGV[1];
my $HostAddress= $ARGV[2];
my $port_number= $ARGV[3];
my $EMGC_MACHINE= $ARGV[4];
my $ADMIN_HOST_NAME= $ARGV[6];
my $SelectedServer= $ARGV[8];
my $ListenPort= $ARGV[9];
my $SSLListenPort= $ARGV[10];
my $connectiontype= $ARGV[7];

my $ADPManagerName= $ARGV[11];
my $ADPManagerPort= $ARGV[12];
my $OracleHome= $ARGV[13];
my $EMGC_DOMAIN_HOME= $ARGV[14];

my $ORACLE_HOME = $ARGV[15];
my $PLUGIN_ROOT_PATH = $ARGV[16];
my $NEW_DIR = $ARGV[17];
my $EMD_ROOT = $ARGV[18];
my $STOP_SERVER_SCRIPT = $ARGV[19];
my $IS_NEW_SERVER = $ARGV[20];
my $AGENT_STATE_DIR = $ARGV[21];
my $HOSTSERVERNAME = $ARGV[22];

my $APPLICATION_NAME = "ADPManager_".$SERVERNAME;
my $ARCHIVES = "archives";
my $OCAMM = "ocamm";
my $EAR_FILE = "ADPManager.ear";

my $source_earfile =  File::Spec->catfile( $EMGC_DOMAIN_HOME, $SERVERNAME, $EAR_FILE );
my $source_jvmd_earfile =  File::Spec->catfile( $EMD_ROOT, $NEW_DIR, "jammanager_dummy.ear" );

my $inp = <STDIN>;

my $comma_pos = index($inp, ",");

my $username = substr($inp, 0, $comma_pos); 		 		
my $password = substr($inp, $comma_pos+1 );

my $KEYSTORE_LOC = File::Spec->catfile( $AGENT_STATE_DIR,'sysman','config','montrust','AgentTrust.jks');		 	

my $DEPLOY_CMD = "$EMD_ROOT/jdk/bin/java -cp $WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC weblogic.WLST $PYTHON_SCRIPT $SERVERNAME $HostAddress $port_number $EMGC_MACHINE $WL_HOME $ADMIN_HOST_NAME $SelectedServer $ListenPort $SSLListenPort $connectiontype $ADPManagerName $ADPManagerPort $username $OracleHome $EMGC_DOMAIN_HOME $source_earfile $source_jvmd_earfile $APPLICATION_NAME $IS_NEW_SERVER $HOSTSERVERNAME";

print("$DEPLOY_CMD\n");

if($IS_NEW_SERVER eq "false")
{	
my $STOP_SERVER_CMD =  "$EMD_ROOT/jdk/bin/java -cp $WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true  -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC weblogic.WLST $STOP_SERVER_SCRIPT $ADMIN_HOST_NAME $port_number $username $password $SERVERNAME $connectiontype";

print("Shutting down managed server\n");

system($STOP_SERVER_CMD);
}



#Deploying making sure of the failure/success status

my $STATUS="true";


if(&IsWindows())
   {

   local (*HANDLE_IN, *HANDLE_OUT);
   open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD)  or die "open3 failed $!\n" ;

  print HANDLE_IN "$password\r\n";
    my $nextLine;
    while(<HANDLE_OUT>) {		
        $nextLine= $_;	
        print $nextLine;

        # i for case insensitive match
        if($nextLine =~ m/ERROR | Exception | WLSTException | Traceback/i) {
            $STATUS = "false";
        }
    }
 
	close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
    close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
}
else
{
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR); 
        open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD);

	 print HANDLE_IN "$password\r\n";
        my $sel = new IO::Select; 
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

        while(my @ready = $sel->can_read) { 
            foreach my $fh (@ready) 
            {
                my $line = <$fh>; 
                if(not defined $line){
                    $sel->remove($fh); 
                    next;              
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {     
                    print $line; 

                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print  $line;
                    $STATUS = "false";
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
}


system("sleep 60s");

if( $STATUS eq "false" ) 
{	exit -1;}
else
{	exit 0;}

#End	

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
