#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/cammMgrDeploy/startManagedRemoteServer.pl /main/3 2012/02/01 22:31:06 ajamil Exp $
#
# startManagedRemoteServer.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      startManagedRemoteServer.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajamil      02/03/11 - Creation
# 

use File::Path;
use File::Spec();
use IPC::Open3;
use IO::Handle;
use IO::Select;


my $WL_HOME= $ARGV[0];
my $HOSTSERVERNAME = $ARGV[1];
my $portnumber= $ARGV[2];
my $ServerName= $ARGV[3];
my $connectiontype= $ARGV[4];
my $PYTHON_SCRIPT2 = $ARGV[5];
my $AGENT_STATE_DIR = $ARGV[6];
my $EMD_ROOT = $ARGV[7];

my $inp = <STDIN>;



my @values = split(',', $inp);

my $username = $values[0];
my $password = $values[1];

my $KEYSTORE_LOC = File::Spec->catfile( $AGENT_STATE_DIR,'sysman','config','montrust','AgentTrust.jks');

my $DEPLOY_CMD =  "$EMD_ROOT/jdk/bin/java -cp $WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC weblogic.WLST $PYTHON_SCRIPT2 $HOSTSERVERNAME $portnumber $username $ServerName $connectiontype";

print("Starting managed server\n");
print("$DEPLOY_CMD\n");

#system($DEPLOY_CMD2);


if(&IsWindows())
   {

   local (*HANDLE_IN, *HANDLE_OUT);
   open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD)  or die "open3 failed $!\n" ;
	print HANDLE_IN "$password\r\n";

    my $nextLine;
    while(<HANDLE_OUT>) {
        $nextLine= $_;
        print $nextLine;

        # i for case insensitive match
        if($nextLine =~ m/ERROR | Exception | WLSTException | Traceback/i) {
            $STATUS = "false";
        }
    }

        close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
    close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
}
else
{
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD);
	print HANDLE_IN "$password\r\n";

        my $sel = new IO::Select;
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

        while(my @ready = $sel->can_read) {
            foreach my $fh (@ready)
            {
                my $line = <$fh>;
                if(not defined $line){
                    $sel->remove($fh);
                    next;
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {
                    print $line;

                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print  $line;
                    $STATUS = "false";
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
}

if( $STATUS eq "false" )
{       exit -1;}
else
{       exit 0;}

#End    

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
