#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/cammMgrDeploy/unzipRemotefiles.pl /main/2 2011/11/22 20:16:39 trachuri Exp $
#
# unzipRemotefiles.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      unzipRemotefiles.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajamil      02/01/11 - Creation
# 

use File::Copy;
use File::Spec();

my $EMD_ROOT = $ARGV[0];
my $tempdir = $ARGV[1];
my $zipfile = $ARGV[2];
my $destfolder = $ARGV[3];
#my $lib_folder = $ARGV[3];

my $source_zipfile =  $zipfile;
my $extract_location = File::Spec->catfile( $EMD_ROOT, $tempdir );

my $BIN         = "bin";
my $AGENT_HOME_BIN_LOCATION = File::Spec->catfile( $EMD_ROOT, $BIN );
my $MBEANTYPES         = "mbeantypes";


my $UNZIP = "unzip";
    if ( IsWindows() ) {
        $UNZIP = $UNZIP . ".exe";
    }
    $UNZIP_COMMAND = File::Spec->catfile( $AGENT_HOME_BIN_LOCATION, $UNZIP );
    if ( !-e $UNZIP_COMMAND ) {
        print(
"Unable to locate UNZIP command. Please set the PATH correctly  on each of the nodes so that the command unzip can be executed from these nodes.  Once the path is set please execute this step again"
        );
        exit 1;
    }



print("$UNZIP_COMMAND -o $source_zipfile to $extract_location \n");
system("$UNZIP_COMMAND -o $source_zipfile -d $extract_location");



my $jar1 = File::Spec->catfile($extract_location,"com.bea.core.apache.log4j_1.2.13.jar");
my $dest_jar1 = File::Spec->catfile($destfolder,"com.bea.core.apache.log4j_1.2.13.jar");
print("Copying $jar1 to $dest_jar1 \n");

copy($jar1,$dest_jar1) or die "Copy failed:$jar1 $!";

my $jar2 = File::Spec->catfile($extract_location,"emagentSDK.jar");
my $dest_jar2 = File::Spec->catfile($destfolder,"emagentSDK.jar");
print("Copying $jar2 to $dest_jar2 \n");

copy($jar2,$dest_jar2) or die "Copy failed:$jar2 $!";

my $jar3 = File::Spec->catfile($extract_location,"emCORE.jar");
my $dest_jar3 = File::Spec->catfile($destfolder,"emCORE.jar");
print("Copying $jar3 to $dest_jar3 \n");

copy($jar3,$dest_jar3) or die "Copy failed:$jar3 $!";

my $jar4 = File::Spec->catfile($extract_location,"emreposauthbean.jar");
my $dest_jar4 = File::Spec->catfile($destfolder,$MBEANTYPES,"emreposauthbean.jar");
print("Copying $jar4 to $dest_jar4 \n");

copy($jar4,$dest_jar4) or die "Copy failed:$jar4 $!";

my $jar5 = File::Spec->catfile($extract_location,"log4j-core.jar");
my $dest_jar5 = File::Spec->catfile($destfolder,"log4j-core.jar");
print("Copying $jar5 to $dest_jar5 \n");

copy($jar5,$dest_jar5) or die "Copy failed:$jar5 $!";

my $jar6 = File::Spec->catfile($extract_location, "emCoreSDK.jar");
my $dest_jar6 = File::Spec->catfile($destfolder, "emCoreSDK.jar");
print("Copying $jar6 to $dest_jar6 \n");

copy($jar6,$dest_jar6) or die "Copy failed:$jar6 $!";

my $jar7 = File::Spec->catfile($extract_location,"emCoreSDKImpl.jar");
my $dest_jar7 = File::Spec->catfile($destfolder,"emCoreSDKImpl.jar");
print("Copying $jar7 to $dest_jar7 \n");

copy($jar7,$dest_jar7) or die "Copy failed:$jar7 $!";


sub IsWindows 
{
  $osname = $^O;
  if ($osname eq "Windows_NT" || 
      $osname eq "MSWin32" || 
      $osname eq "MSWin64" ||
      $osname eq "cygwin")
  {
    return 1;
  }
  else 
  {
    return 0;
  }  
}

