#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/cammMgrDeploy/unzip_ADPManagerRemote.pl /main/2 2011/11/22 20:16:39 trachuri Exp $
#
# unzip_ADPManagerRemote.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      unzip_ADPManagerRemote.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajamil      02/01/11 - Creation
# 

use File::Copy;
use File::Spec();

my $EMD_ROOT = $ARGV[0];
my $tempdir = $ARGV[1];

my $BIN         = "bin";
my $AGENT_HOME_BIN_LOCATION = File::Spec->catfile( $EMD_ROOT, $BIN );

my $WL_HOME = $ARGV[2];
my $SERVER = $ARGV[3];
my $MGR_DIR = "ADP_".$SERVER;

my $DOMAIN_HOME= $ARGV[4];




my $ZIP_FILE = "ADPManager.zip";

my $source_zipfile =  File::Spec->catfile( $EMD_ROOT, $tempdir, $ZIP_FILE );

my $destination_dir = File::Spec->catfile( $DOMAIN_HOME, $SERVER );


print("Source :$source_zipfile \n Destination :$destination_dir  \n");

mkdir ($destination_dir, 0777);

print(" Making dir with permission \n");

copy($source_zipfile,$destination_dir) or die "Copy failed:$source_zipfile $!";

my $source = File::Spec->catfile( $DOMAIN_HOME, $SERVER, $ZIP_FILE );



my $UNZIP = "unzip";
    if ( IsWindows() ) {
        $UNZIP = $UNZIP . ".exe";
    }
    $UNZIP_COMMAND = File::Spec->catfile( $AGENT_HOME_BIN_LOCATION, $UNZIP );
    if ( !-e $UNZIP_COMMAND ) {
        print(
"Unable to locate UNZIP command. Please set the PATH correctly  on each of the nodes so that the command unzip can be executed from these nodes.  Once the path is set please execute this step again"
        );
        exit 1;
    }




print("$UNZIP_COMMAND -o $source to $destination_dir \n");
system("$UNZIP_COMMAND -o $source -d $destination_dir");



sub IsWindows 
{
  $osname = $^O;
  if ($osname eq "Windows_NT" || 
      $osname eq "MSWin32" || 
      $osname eq "MSWin64" ||
      $osname eq "cygwin")
  {
    return 1;
  }
  else 
  {
    return 0;
  }  
}

