#!/usr/local/bin/perl

#
# Sample script to demonstrate starting of following Coherence nodes.
# When this script is passed in as a start script in Coherence Node Provisioning
# Deployment Procedure, while executing start node step, deployment procedure sets
# all user entered options as environment variables. Based on the values of these
# environment variables, you can start different types of Coherence nodes.
#
#       - Management Node with Oracle Bulk Operation MBean is started when
#       "bulk_mbean" and "jmx_remote_port" variables are set. For this option,
#         oracle.sysman.integration.coherence.EMIntegrationServer Java class is executed that
#         starts a MBeanServer in this node and registers Oracle Bulk Operation MBean. You need
#         coherenceEMIntg.jar and bulkoperationsmbean.jar in the classpath.
#         Oracle recommends the usage of Bulk Operation MBean as it improves performance of
#         metric collection.
#
#       - Management Node is started when "jmx_remote_port" is set, but "bulk_mbean" is NOT set.
#
#     - Managed node when "jmx_remote_port" is not set.
#
#
# Following variables are set from the deployment procedure. Use these values to
# define required system parameters to override Coherence default settings.
#

use IPC::Open3;
use File::Path;
use File::Spec();

my $coherence_home=$ENV{'COHERENCE_HOME'};
my $start_script=$ENV{'START_SCRIPT'};
my $java_home=$ENV{'JAVA_HOME'};
my $agent_home=$ENV{'AGENT_HOME'};
my $emasAgentPluginRoot=$ENV{'EMAS_AGENT_PLUGIN_ROOT'};
my $wka_port=$ENV{'WKA_PORT'};
my $license_mode=$ENV{'LICENSE_MODE'};
my $jamhost=$ENV{'JAM_CONSOLE_HOST'};
my $jamport=$ENV{'JAM_CONSOLE_PORT'};

my $unicast_address=$ENV{'UNICAST_ADDRESS'};
my $unicast_port=$ENV{'UNICAST_PORT'};

my $member=$ENV{'tangosol_coherence_member'};
my $site=$ENV{'tangosol_coherence_site'};
my $rack=$ENV{'tangosol_coherence_rack'};
my $machine=$ENV{'tangosol_coherence_machine'};

# tangosol.coherence.machine has a limitation of 32 chars
# As a workaround, use oracle.coherence.machine to set machine name
# This parameter is used to identify hosts for cluster management features
my $oracle_coherence_machine=$ENV{'oracle_coherence_machine'};
my $role=$ENV{'tangosol_coherence_role'};

my $jmxport=$ENV{'jmx_remote_port'};
my $cluster=$ENV{'tangosol_coherence_cluster'};
my $clusteraddr=$ENV{'tangosol_coherence_clusteraddress'};
my $clusterport=$ENV{'tangosol_coherence_clusterport'};
my $bulkmbean=$ENV{'bulk_mbean'};
my $jmx_auth=$ENV{'jmx_enable_auth'};
my $perl_bin=$ENV{'PERL_BIN'};

my $SYS_OPT="";
my $JVM_OPT="";
my $param_cmd;

my $psep="";
my $dsep="";
if ( !&IsWindows() ) {
        $psep=":";
        $dsep="/";
}
else
{
        $psep=";";
        $dsep="\\";
}

print "\n\n**********************************************************************************************\n";
print "Output from default-start-script\n";
print "Starting Node : $member\n";
print "Coherence Home : $coherence_home \n";
print "Start Script : $start_script \n";
print "Java Home : $java_home \n";
print "Perl Bin : $perl_bin \n";
print "Agent Home : $agent_home \n";
print "EMAS Agent Plugin Root : $emasAgentPluginRoot \n";
print "WKA Port: $wka_port \n";
print "Unicast Host: $unicast_address \n";
print "Unicast Port: $unicast_port \n";
print "License Mode: $license_mode \n";

print "Site Name : $site \n";
print "Rack Name : $rack \n";
print "Machine Name : $machine \n";
print "Oracle Coherence Machine Name : $oracle_coherence_machine \n";
print "Role Name : $role \n";

print "Cluster Name : $cluster \n";
print "Cluster Addr : $clusteraddr \n";
print "Cluster Port : $clusterport \n";
print "JMX Port : $jmxport \n";
print "Bulk MBean : $bulkmbean \n";
print "JMX Auth Enabled : $jmx_auth \n";

#Check if coherence.jar exists to make sure COHERENCE_HOME was correct
my $cohjar = $coherence_home.$dsep."lib".$dsep."coherence.jar";
unless(-e $cohjar) {
    print "Error: $cohjar not found, check COHERENCE_HOME: $coherence_home\n";
    exit -1;
}

#
# you may run a local script as part of this script and override those
# settings.
# Override JAVA_HOME variable by setting it locally
#
#. ./set-env.sh
#echo "After setting JAVA_HOME locally, JAVA_HOME: $JAVA_HOME"

# Options for Java Virtual Machine.
$JVM_OPT="-server -Xms512m -Xmx512m -Xincgc -verbose:gc";

#
# Set system parameters to Coherence node
$SYS_OPT="-Djava.net.preferIPv4Stack=true";

# This param allows the mbeans on this node to be registered to mbean servers running on management nodes
$SYS_OPT="$SYS_OPT -Dtangosol.coherence.management.remote=true";

$SYS_OPT="$SYS_OPT -Dcom.sun.management.jmxremote.ssl=false";
$SYS_OPT="$SYS_OPT -Dtangosol.coherence.cluster=$cluster";
$SYS_OPT="$SYS_OPT -Dtangosol.coherence.member=$member";
$SYS_OPT="$SYS_OPT -Dtangosol.coherence.site=$site";
$SYS_OPT="$SYS_OPT -Dtangosol.coherence.rack=$rack";
$SYS_OPT="$SYS_OPT -Dtangosol.coherence.machine=$machine";
# set this if machine name > 32 chars, tangosol.coherence.machine has a limitaion of 32 chars
$SYS_OPT="$SYS_OPT -Doracle.coherence.machine=$oracle_coherence_machine";
$SYS_OPT="$SYS_OPT -Dtangosol.coherence.role=$role";

# Set coh home and start script so they will be part of input args
$SYS_OPT="$SYS_OPT -Doracle.coherence.home=$coherence_home";
$SYS_OPT="$SYS_OPT -Doracle.coherence.startscript=$start_script";


# set jmxremote.authenticate=true if $jmx_enable_auth is present.
# username/password needs to be set in $JDK_HOME/jre/lib/management/jmxremote.password and
# $JDK_HOME/jre/lib/management/jmxremote.access files. Uncomment the following block after
# adding these files.
#
if ($jmx_auth ne "") {
       $SYS_OPT="$SYS_OPT -Dcom.sun.management.jmxremote.authenticate=$jmx_auth";
} else {
       $SYS_OPT="$SYS_OPT -Dcom.sun.management.jmxremote.authenticate=false";
}

# Default is true, so make sure to set it to false if not using authentication
#  $SYS_OPT="$SYS_OPT -Dcom.sun.management.jmxremote.authenticate=false";



# set jmxremote.port only for management nodes, if user passes in.
# It enables monitoring from remote systems through this port.
if ($jmxport ne  "") {
        $SYS_OPT="$SYS_OPT -Dcom.sun.management.jmxremote.port=$jmxport";
}


#
# Define clusteraddress and clusterport if we have valid values.
#
if($clusteraddr ne "") {
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.clusteraddress=$clusteraddr";
}

if("$clusterport" ne "") {
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.clusterport=$clusterport";
}

if("$license_mode" ne "") {
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.mode=$license_mode";
}

if("$unicast_address" ne "") {
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.localhost=$unicast_address";
}

if("$unicast_port" ne "") {
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.localport=$unicast_port";
}

if("$wka_port" ne "") {
	$wka_port = "\"".$wka_port."\"";
        $wka_script = $emasAgentPluginRoot.$dsep."scripts".$dsep."coherence".$dsep."generate-wka-override.pl";
	if(-f $wka_script) {
	    my @args = ($perl_bin.$dsep."perl", "$wka_script", "$wka_port");
	    
	    print "executing $wka_script $wka_port\n";
            local(*HIS_IN, *HIS_OUT, *HIS_ERR);
            $open_id = open3(*HIS_IN, *HIS_OUT, *HIS_ERR, "@args") or die "Could not execute $wka_script\n";
            close(HIS_IN);
            close(HIS_OUT);
            close(HIS_ERR);
	} else {
	    print "Error: $wka_script does not exist\n";
	    exit -1;
	}
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.override=em-coherence-override.xml"; 
}

my $startup_class="";
my $cmd="";

# Note that Coherence lib is under $COHERENCE_HOME/coherence. Add any application specific
# jars to this classpath, if needed.
my $CLASSPATH=$coherence_home.$dsep."lib".$dsep."coherence.jar".$psep.$coherence_home.$dsep."lib".$dsep."reporter.jar";

print "CLASSPATH: $CLASSPATH\n";

if($jamhost ne "" && $jamport ne "") {
    $CLASSPATH=$CLASSPATH.$psep.$emasAgentPluginRoot.$dsep."archives".$dsep."jlib".$dsep."jamagent.war";
    my $jamjvmid="$cluster/$member";
    print "Using Oracle JVMD - $jamjvmid\n";
    $SYS_OPT="$SYS_OPT -Doracle.coherence.jamjvmid=$jamjvmid";
    $SYS_OPT="$SYS_OPT jamagent.jamrun jamconshost=$jamhost jamconsport=$jamport jamjvmid=$jamjvmid";
}


if ($bulkmbean ne "" && $jmxport ne "") {
        # Management node with Bulk Operation MBean.
        # add Oracle supplied jars for Bulk Operation MBean
	$CLASSPATH=$CLASSPATH.$psep.$emasAgentPluginRoot.$dsep."archives".$dsep."coherence".$dsep."coherenceEMIntg.jar".$psep.$emasAgentPluginRoot.$dsep."archives".$dsep."coherence".$dsep."bulkoperationsmbean.jar";
        # Start MBeanServer
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.management=all";
        print "Starting a management node with Bulk Operation MBean \n";
        $startup_class="oracle.sysman.integration.coherence.EMIntegrationServer";
	$cmd=$java_home.$dsep."bin".$dsep."java -cp $CLASSPATH $JVM_OPT $SYS_OPT $startup_class";
} elsif ($jmxport ne "") {
        # Management Node with out Bulk Operation MBean
        # Start MBeanServer
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.management=all";
        print "Starting a management node ...\n";
        $startup_class="com.tangosol.net.DefaultCacheServer";
	$cmd=$java_home.$dsep."bin".$dsep."java -cp $CLASSPATH $JVM_OPT $SYS_OPT $startup_class";
} else {	 
        # A simple managed node. Do not start MBeanServer.
        $SYS_OPT="$SYS_OPT -Dtangosol.coherence.management=none";
        print "Starting a simple managed node ...\n";
        $startup_class="com.tangosol.net.DefaultCacheServer";
	$cmd=$java_home.$dsep."bin".$dsep."java -cp $CLASSPATH $JVM_OPT $SYS_OPT $startup_class";
}
                   
$| = 1;
   #replace \ with / in the input file
    $cmd =~ s/\\/\//g;
    #replace /+ with /
    $cmd =~ s/\/+/\//g;


if ( !&IsWindows() ) {
    if (fork() == 0) {
        print "Executing start script from child process... $cmd \n";
        exec("$cmd") or die "Could not execute $cmd\n";
    }
} else {
        # For Windows change the path  from / to \
        $cmd =~ s/\//\\\\/g;
	my $output_file = File::Spec -> catfile ($coherence_home.$dsep."coherence_node_dp.log");

        print "Command used to start node on windows = $cmd\n";
	$cmd = prepareSystemCommand($cmd, $output_file);
	system("start cmd /c $cmd") or die "Could not execute $cmd : $?\n";
}

print "exiting default start script\n";
exit 0;

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}

#suroutine used for closing parent file handlers and opening new for child
sub prepareSystemCommand{
 #1st param command
 #2nd out file

 $param_cmd= shift;
 $output_file= shift;
 print("\n output file is $output_file \n");
 $cmd=$param_cmd;
 if(IsWindows()){
        close STDOUT;
        open(STDOUT, ">>", "$output_file".".out");
        close STDERR;
        open(STDERR, ">>", "$output_file".".err");
 }
 print "Executing: $cmd"."\n";
 print "Check ".$output_file."* logs for any failures.\n";
 return $cmd;
}

