#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/coherence/generate-wka-override.pl /main/1 2011/02/01 16:51:33 shanksub Exp $
#
# generate-wka-override.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      generate-wka-override.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
# 	expects input args as:
# 	host1:port1,host2:port2,host3:port3
#	writes the wka information to em-coherence-override.xml
#	Sample xml file:
#<coherence xml-override="/tangosol-coherence-override-{mode}.xml">
#   <cluster-config>
#     <unicast-listener>
#       <well-known-addresses>
#           <socket-address id="1">
#               <address>10.232.129.69</address>
#               <port>8088</port>
#           </socket-address>
#           <socket-address id="2">
#              <address>10.232.129.69</address>
#              <port>8089</port>
#           </socket-address>
#       </well-known-addresses>
#       <port>8088</port>
#    </unicast-listener>
# </cluster-config>
#</coherence>

#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    shanksub    09/27/10 - Creation
# 

use Cwd;
use IPC::Open3;

my $host_port = $ARGV[0];
@host_port_array = split(',', $host_port);
$size = @host_port_array;

my $xmlfile="em-coherence-override.xml";
print "$xmlfile\n";
open(XMLFL,"> $xmlfile");

print XMLFL "<coherence xml-override=\"/tangosol-coherence-override-{mode}.xml\">\n";
print XMLFL   "<cluster-config>\n";
print XMLFL     "<unicast-listener>\n";
print XMLFL       "<well-known-addresses>\n";

my $id = 1;
for($i = 0; $i < $size; $i++) {
    $single_host_port = $host_port_array[$i];
    $single_host_port =~ s/^\s+|\s+$//g;
    @single_host_port_array = split(':', $single_host_port);
    $wka_host = $single_host_port_array[0];
    $wka_port = $single_host_port_array[1];
    $id = $id + $i;
    print XMLFL    "<socket-address id=\"$id\">\n";
    print XMLFL       "<address>$wka_host</address>\n";
    print XMLFL       "<port>$wka_port</port>\n";
    print XMLFL     "</socket-address>\n";
}

print XMLFL      "</well-known-addresses>\n";
print XMLFL    "</unicast-listener>\n";
print XMLFL  "</cluster-config>\n";
print XMLFL "</coherence>";

close(XMLFL);
exit 0;

