#!/usr/local/bin/perl

#
# expects input args as:
# memberName1<>processName1<>nodeId1,memberName2<>processName2<>nodeId2,memberName3<>processName3<>nodeId3
# if processName eq processId, returns process information
# else tries to look for -Dtangosol.coherence.member=memberName
#
# Output is in the form:
# MemberName<>NodeID<>PID<>ParentID<>StartTime<>ProcessDesc\n
# MemberName<>NodeID<>PID<>ParentID<>StartTime<>ProcessDesc\n
#


use Cwd;
use IPC::Open3;

my $member_process_names = $ARGV[0];
@member_process_name_array = split(',', $member_process_names);
$size = @member_process_name_array;


if(IsWindows()) {
    processInfoForWindows();
} else {
    processInfoForLinux();
}

sub processInfoForWindows {
    @all_commands = `nmefwmi wbem_classname=win32_process wbem_properties=CommandLine,Name,ProcessID,ParentProcessID,CreationDate`;

    foreach $comm (@all_commands) {
	my @commandInfoArray = split('\|', $comm);

	$process_desc_str = $commandInfoArray[0];
	@process_desc_arr = split('commandline=', $process_desc_str);
	$process_desc = $process_desc_arr[1];

	$process_id_str = $commandInfoArray[2];
	@process_id_arr = split('=', $process_id_str);
	$process_id = $process_id_arr[1];

	$parent_process_id_str = $commandInfoArray[3];
	@parent_process_id_arr = split('=', $parent_process_id_str);
	$parent_process_id = $process_id_arr[1];

	$date_str = $commandInfoArray[4];
	@date_arr = split('=', $date_str);
	$date = $date_arr[1];

        for($i = 0; $i < $size; $i++) {
            $single_member_process_name = $member_process_name_array[$i];
            @single_member_process_name_array = split('<>', $single_member_process_name);
            $member_name = $single_member_process_name_array[0];
            $node_process_name = $single_member_process_name_array[1];
            $node_id = $single_member_process_name_array[2];
	
	    #print("member name to match: $member_name \n");
	    #print("node id to match: $node_id \n");

            my $matchFound = "No";
            #check if given process name matches process id
            if($node_process_name ne 'n/a' && $process_id == $node_process_name) {
                $matchFound = "Yes";
            #check if member name matches process desc
            } elsif($process_desc =~ m/tangosol.coherence.member=$member_name\b/) {
                $matchFound = "Yes";
            }
            if($matchFound eq "Yes") {
                $output = $output."$member_name";
                $output = $output."<>";

                $output = $output."$node_id";
                $output = $output."<>";

                $output = $output."$process_id";
                $output = $output."<>";

                $output = $output."$parent_process_id";
                $output = $output."<>";

		$date =~ s/\s+$//;
                $output = $output."$date";
                $output = $output."<>";

                $output = $output."$process_desc";
                $output = $output."\n";
	    }
        }
    }
    print("$output \n");
}

sub processInfoForLinux {

    local(*HIS_IN, *HIS_OUT, *HIS_ERR);

    $command1 = "ps -ef";
    $open_id = open3(*HIS_IN, *HIS_OUT, *HIS_ERR, $command1);
    my $output = "";
    my $pid;
    while(<HIS_OUT>) { 
        chomp; 
        @processArray = split(' ', $_, 8); 
        $process_desc = $processArray[7];
        $process_id = $processArray[1];

        for($i = 0; $i < $size; $i++) {
	    $single_member_process_name = $member_process_name_array[$i];
	    @single_member_process_name_array = split('<>', $single_member_process_name);
  	    $member_name = $single_member_process_name_array[0];
	    $node_process_name = $single_member_process_name_array[1];
	    $node_id = $single_member_process_name_array[2];

 	    my $matchFound = "No";
	    #check if given process name matches process id
	    if($node_process_name ne 'n/a' && $process_id == $node_process_name) {
   	        $matchFound = "Yes";
	    #check if member name matches process desc
	    } elsif($process_desc =~ m/tangosol.coherence.member=$member_name\b/) {
	        $matchFound = "Yes";
	    }
	    if($matchFound eq "Yes") {
	        $output = $output."$member_name";
	        $output = $output."<>";

	        $output = $output."$node_id";
	        $output = $output."<>";

	        $output = $output."$processArray[1]";
	        $output = $output."<>";

	        $output = $output."$processArray[2]";
	        $output = $output."<>";

	        $output = $output."$processArray[4]";
	        $output = $output."<>";

	        $output = $output."$processArray[7]";
	        $output = $output."\n";
	    }
        }
    }
    print("$output \n");
    close(HIS_IN); 
    close(HIS_OUT); 
    close(HIS_ERR); 
}

sub IsWindows {
    $osname = $^O;
    if ($osname eq "Windows_NT" || $osname eq "MSWin32" || $osname eq "MSWin64") {
        return 1;
    } else {
        return 0;
    }
}

