#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/coherence/start-node-directive.pl /main/5 2011/08/19 11:26:35 shanksub Exp $
#
# startnode.pl
# 
# Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      startnode.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Usage: perl startnode.pl COHERENCE_HOME start_script node_name cluster_name site_name 
#                   rack_name machine_name role_name JAVA_HOME AGENT_HOME 
#                   JMX_REMOTE_PORT CLUSTER_ADDRESS CLUSTER_PORT
#      Starts a coherence node after setting all necessary system variables.
#      This script takes following input parameters. Since these are positional
#      parameters, a valid value or "n/a" string to be supplied to each parameter. A value
#      with 'n/a' will not be set in the environment and not passed to start script.
#           - ARGV[0] - COHERENCE_HOME - Absolute path to COHERENVE_HOME. Script is executed
#                                         from this location. 
#           - ARGV[1] - START_SCRIPT - Absolute path or relative pathto a system specific script
#                                      that wil bring up a coherence node.
#           - ARGV[2] - NODE_NAME - Name of the name that will be set as memberName
#           - ARGV[3] - CLUSTER_NAME - Name of the cluster in which this node is created.
#           - ARGV[4] - SITE_NAME - Site name
#           - ARGV[5] - RACK_NAME - Rack name
#           - ARGV[6] - MACHINE_NAME - Machine name. This needs to be the host name for
#                                       cross references to get host alerts.
#           - ARGV[7] - ROLE_NAME - Role name that this node is playing - storage/data node, 
#                                   management node, application/process node, proxy node
#           - ARGV[8] - JAVA_HOME - Location Java software under which bin/java is found.
#           - ARGV[9] - AGENT_HOME - Agent Home
#           - ARGV[10] - JMX_REMOTE_PORT - needed only for management nodes to start MBeanServer at this port
#           - ARGV[11] - CLUSTER_ADDRESS - needed if this node should be added to a new cluster
#           - ARGV[12] - CLUSTER_PORT - needed if this node should be added to a new cluster.
#           - ARGV[13] - BULK_MBEAN - indicates whether to use bulkoperations mbean or not. 
#           - ARGV[14] - JMX_ENABLE_AUTH - indicates whether authentication is enabled. 
#           - ARGV[15] - ORACLE_COH_MACHINE_NAME - This is used if machine name > 32 chars. 
#           - ARGV[16] - TARGET_NAME - Target Name 
#           
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    shanksub    04/16/09 - add bulk_mbean env variable
#    rbhethan    12/08/08 - add exit code check for windows
#    rbhethan    11/17/08 - bug 7519164 - check for exist status
#    rbhethan    07/30/08 - script to start a Coherence node
#    rbhethan    07/30/08 - Creation
# 

# Name of the start script to be executed to start the node. This start script
# is expected to run another script to set all common env variables except
# node identification values.

use IPC::Open3;
use File::Path;
use File::Spec();
use Cwd;
use IO::Handle;
use IO::Select;

my $pwd = getCurrDir();
print("Current working directory: $pwd\n");

my $COHERENCE_HOME = $ARGV[0];
my $START_SCRIPT = $ARGV[1];
my $NODE_NAME = $ARGV[2];
my $CLUSTER_NAME = $ARGV[3];
my $SITE_NAME = $ARGV[4];
my $RACK_NAME = $ARGV[5];
my $MACHINE_NAME = $ARGV[6];
my $ROLE_NAME = $ARGV[7];
my $JAVA_HOME = $ARGV[8];
my $AGENT_HOME= $ARGV[9];
my $JMX_REMOTE_PORT = $ARGV[10];
my $CLUSTER_ADDRESS = $ARGV[11];
my $CLUSTER_PORT = $ARGV[12];
my $BULK_MBEAN = $ARGV[13];
my $JMX_ENABLE_AUTH = $ARGV[14];
my $ORACLE_COH_MACHINE_NAME = $ARGV[15];
my $TARGET_NAME = $ARGV[16];
my $WKA_PORT = $ARGV[17];
my $EMAS_AGENT_PLUGIN_ROOT = $ARGV[18];
my $PERL_BIN = $ARGV[19];

# Change the working directory
print("Changing to COHERENCE_HOME directory: $COHERENCE_HOME \n");
chdir $COHERENCE_HOME;


$ENV{COHERENCE_HOME} = $COHERENCE_HOME;
$ENV{START_SCRIPT} = $START_SCRIPT;
$ENV{tangosol_coherence_member} = $NODE_NAME;
$ENV{tangosol_coherence_cluster} = $CLUSTER_NAME;
$ENV{tangosol_coherence_machine} = $MACHINE_NAME;

# Following identification variables can be passed to environment environment with 'n/a'
$ENV{tangosol_coherence_site} = $SITE_NAME;
$ENV{tangosol_coherence_rack} = $RACK_NAME;
$ENV{tangosol_coherence_role} = $ROLE_NAME;

# Do not set following parameters to environment if their value is 'n/a'
if ( $ORACLE_COH_MACHINE_NAME ne "n/a" ) {
    $ENV{oracle_coherence_machine} = $ORACLE_COH_MACHINE_NAME;
}
if ( $JAVA_HOME ne "n/a" ) {
    $ENV{JAVA_HOME} = $JAVA_HOME;
}
if ( $AGENT_HOME ne "n/a" ) {
    $ENV{AGENT_HOME} = $AGENT_HOME;
}
if ( $JMX_REMOTE_PORT ne "n/a" ) {
    $ENV{jmx_remote_port} = $JMX_REMOTE_PORT;
}
if ( $CLUSTER_ADDRESS ne "n/a" ) {
    $ENV{tangosol_coherence_clusteraddress} = $CLUSTER_ADDRESS;
} 
if ( $CLUSTER_PORT ne "n/a" ) {
    $ENV{tangosol_coherence_clusterport} = $CLUSTER_PORT;
}
if ( $BULK_MBEAN ne "n/a" ) {
    $ENV{bulk_mbean} = $BULK_MBEAN;
}
if ( $JMX_ENABLE_AUTH ne "n/a" ) {
    $ENV{jmx_enable_auth} = $JMX_ENABLE_AUTH;
}
if($WKA_PORT ne "n/a") {
    #convert <> into ,
    $WKA_PORT =~ s/<>/,/g; 
    $ENV{WKA_PORT} = $WKA_PORT;
}
if ( $EMAS_AGENT_PLUGIN_ROOT ne "n/a" ) {
    $ENV{EMAS_AGENT_PLUGIN_ROOT} = $EMAS_AGENT_PLUGIN_ROOT;
}


# set environment variables
print("Set environment variables: tangosol_coherence_member: $NODE_NAME, tangosol_coherence_cluster: $CLUSTER_NAME, tangosol_coherence_site: $SITE_NAME \n");
print(" tangosol_coherence_rack: $RACK_NAME, tangosol_coherence_machine: $MACHINE_NAME, tangosol_coherence_role: $ROLE_NAME  \n");
print("COHERENCE_HOME: $COHERENCE_HOME, AGENT_HOME: $AGENT_HOME\n");
print("Java Home: $JAVA_HOME\n");
print("START_SCRIPT: $START_SCRIPT\n");
print("JMX Remote Port: $JMX_REMOTE_PORT, Cluster Address: $CLUSTER_ADDRESS, Cluster Port: $CLUSTER_PORT\n");
print("Bulk MBean: $BULK_MBEAN\n");
print("JMX Enable Auth: $JMX_ENABLE_AUTH\n");
print("Oracle Coherence Machine Name: $ORACLE_COH_MACHINE_NAME\n");
print("EMAS AGENT PLUGIN ROOT: $EMAS_AGENT_PLUGIN_ROOT\n");
print("PERL BIN : $PERL_BIN\n");
print("WKA_PORT: $WKA_PORT\n");


if (-f $START_SCRIPT) {
    &startNode();
} else {
    print "$START_SCRIPT does not exist\n";
    exit -1;
}

sub startNode() {
   print "Executing $START_SCRIPT\n";
   my $STATUS = "";

   my @args = "($START_SCRIPT)";
   if($START_SCRIPT =~ m/\.pl$/) {
        @args = ("$PERL_BIN/perl", $START_SCRIPT);
	if(&IsWindows()) {
            @args = ("$PERL_BIN\perl", $START_SCRIPT);
	}
   } elsif (!&IsWindows()) {
       print("changing file permissions on script: $START_SCRIPT\n");
       system("chmod 0700 $START_SCRIPT");
   }

   my $startTime = time();
   $| = 1;

   if(&IsWindows()) {
        local (*HANDLE_IN, *HANDLE_OUT);
        $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, "@args")  or die "open3 failed $!\n";

        my $nextLine;
        while(<HANDLE_OUT>) {
            $nextLine= $_;
            print $nextLine;
            if($nextLine =~ /Exception | Error/) {
                $STATUS = "false";
                last;
            }
            $currentTime = time();
            $timeElapsed = $currentTime - $startTime;
            if($timeElapsed > 30) {
               last;
            }
        }
        close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
        close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
   } else {
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        $pid = open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, "@args");
        my $sel = new IO::Select;
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);
        while(my @ready = $sel->can_read(30)) {
            foreach my $fh (@ready) {
                $currentTime = time();
                $timeElapsed = $currentTime - $startTime;
                if($timeElapsed > 30) {
                   last;
                }
                my $line = <$fh>;
                if(not defined $line){
                    $sel->remove($fh);
                    next;
                }
                print $line;
                if($line =~ /Exception | Error/) {
                    $STATUS = "false";
                    last;
                }
            }
            $currentTime = time();
            $timeElapsed = $currentTime - $startTime;
            if($timeElapsed > 30) {
                last;
            }
            if($STATUS eq "false") {
                last;
            }
        }
        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
    }

    if ( &checkExitCode($?) ) {
       print "Failed to execute start script: $START_SCRIPT\n";
       exit -1;
    }

    if ( $STATUS eq "false" ) {
        print "Could not start coherence node\n";
        exit -1;
    } else {
        print "Coherence node successfully started\n";
    }
}


# change back to pwd
print("Changing directory to $pwd\n");
chdir $pwd;
print("Exiting from main process.\n");
exit 0;


sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}

#Subroutine to get the current directory
sub getCurrDir() {
    my $pwd = getcwd();
    if ( &IsWindows() ) {
        $pwd =~ s/\//\\/g;
    }
    return $pwd;
}

sub checkExitCode($) {
    my ($exit_value) = @_;
    $exit_value = $exit_value >> 8;
    return $exit_value;
}
