#!/usr/local/bin/perl

use Cwd;
use IPC::Open3;

my $processes = $ARGV[0];
@process_array = split(',', $processes);

my $KILL = "kill -9";
if(IsWindows()) {
    $KILL = "taskkill /F /pid";
} 

$size = @process_array;

my $err_output;

for($i = 0; $i < $size; $i++) {
    $kill_cmd = "$KILL $process_array[$i]";
    local(*HIS_IN, *HIS_OUT, *HIS_ERR);
    $open_id = open3(*HIS_IN, *HIS_OUT, *HIS_ERR, $kill_cmd) or die "Could not execute $kill_cmd\n";
    while(<HIS_ERR>) { 
	$err_output = $err_output.$_;
    }
    close(HIS_IN); 
    close(HIS_OUT); 
    close(HIS_ERR); 
}
print("$err_output");

if($err_output ne "") {
    exit -1;
}

sub IsWindows {
    $osname = $^O;
    if ($osname eq "Windows_NT" || $osname eq "MSWin32" || $osname eq "MSWin64") {
        return 1;
    } else {
        return 0;
    }
}
