#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/coreid_control.pl /main/2 2010/09/08 16:27:45 kchander Exp $
#
# coreid_control.pl
# 
# Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      coreid_control.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kchander    09/07/10 - fix bug 10074126. use emdroot, instead of
#                           oracle_home.
#    nsarkar     10/06/06 - script for Access and Identity process control
#    nsarkar     10/06/06 - Creation
# 

use File::Find;
my $oper = $ARGV[0];
my $target;
my $type;
my $hostname;
my $oracleHome = $ENV{ORACLE_HOME};
my $emdRoot = $ENV{EMDROOT};
my $coreidHome;

foreach $t (@ARGV)
{
    my @arg = split("=", $t);
    if ($arg[0] eq "targetName")
    {
        $target = $arg[1];
    }
    elsif ($arg[0] eq "targetType")
    {
        $type = $arg[1];
    }
    elsif ($arg[0] eq "OracleHome")
    {
        $coreidHome = $arg[1];
    } 
}

my $command = getCommand($oper,$coreidHome,$type);

my $result =`$command 2>&1`;

$result = createResponseXML($oper,$result,$target);
print "$result\n";


sub createResponseXML
{

    my $operation = @_[0];
    my $result = @_[1];
    my $targetName = @_[2];
    my $exitCode;
    my $respMessage;
    my $responseXML;
    my $Error = <STDERR>;

    if ( $result =~ m/was started successfully/ or $result =~ m/was stopped successfully/ 
		or $result =~ m/started with pid/ or $result =~ m/Server stopped/ )
    {
        $exitCode = "0";
        $respMessage = "SUCCESS";
    }
    else
    {
        $exitCode = "1";
        $respMessage= $result;

    }

    $responseXML = "<Responses><Response><ExitCode>".$exitCode."</ExitCode><ResponseMessage>".$respMessage."</ResponseMessage><TargetName>".$targetName."</TargetName></Response></Responses>";
    return $responseXML;
}

sub getCommand()
{
	my $operation = @_[0];
    my $tempCoreidHome = @_[1];
    my $targetType = @_[2];

	my $tempCommand;
	my $winServiceName;

	chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64")) 
    {
       $tempCommand = $emdRoot."/jdk/bin/java -classpath ".$emdRoot."/archives/jlib/coreidAgent.jar oracle.sysman.coreid.agent.process.COREidProcessControl ".$operation." ".$targetType." ".$tempCoreidHome." ".$os;
		
    }
	else
    {
	  $tempCommand = $emdRoot."\\jdk\\bin\\java -classpath ".$emdRoot."\\archives\\jlib\\coreidAgent.jar;".$emdRoot."\\lib\\xmlparserv2.jar oracle.sysman.coreid.agent.process.COREidProcessControl ".$operation." ".$targetType." ".$tempCoreidHome." ".$os;
    }

	return $tempCommand;
}


sub getServiceName()
{
	
    my $tempCoreidHome = @_[0];
	my $targetType = @_[1];
	my $instanceName;
	my $serviceName;
    
	#trim whitespace character
	$targetType =~ s/^\s+//;
    $targetType =~ s/\s+$//;

    if($targetType eq "oracle_coreid_access_server")
	{
	  my $INSTANCE_NAME_FILE = $tempCoreidHome."/oblix/config/install_options.txt";
	  open(FD, "$INSTANCE_NAME_FILE") or die("Couldn't open $INSTANCE_NAME_FILE\n");
	  while ( my $line = <FD> ) 
	  {
		   if($line =~ m/aaaInfoBean\.accessServerID/)
		   {
			   my $firstInd = index($line, "=");
			   my $secondInd = index($line, "\"",$firstInd+2);
			   $instanceName = substr($line,$firstInd+2,$secondInd-($firstInd+2));
			   last;
		   }
	   }
	   $serviceName = "Oracle Access Manager Access Server (".$instanceName.")";
	}
	else
	{
       my $INSTANCE_NAME_FILE = $tempCoreidHome."/oblix/config/install_options.txt";
	   open(FD, "$INSTANCE_NAME_FILE") or die("Couldn't open $INSTANCE_NAME_FILE\n");
	   while ( my $line = <FD> ) 
	   {
		   if($line =~ m/ntServiceNameField/)
		   {
			   my $firstInd = index($line, "=");
			   my $secondInd = index($line, "\"",$firstInd+2);
			   $instanceName = substr($line,$firstInd+2,$secondInd-($firstInd+2));
			   last;
		   }
	   }
	   $serviceName = "Oracle Access Manager Identity Server (".$instanceName.")";
	}
    
	$serviceName="\"".$serviceName."\"";
	return $serviceName;
}

