#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/coreidresourceusage.pl /main/2 2011/07/13 03:34:41 mjalan Exp $
#
# coreidresourceusage.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      coreidresourceusage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mjalan      07/07/11 - Fix bug 1021497
#    nsarkar     09/24/06 - This is script find out the memory and cpu usage of
#                           Access and Identity Server
#    nsarkar     09/24/06 - Creation
# 
use strict;
require "emd_common.pl";
require "iasresourceusage.pl";
require "iasntresourceusage.pl";

my $emd_root;
my $coreid_oracle_home;
my $coreid_target_type;

my %pids_table;
$emd_root = $ARGV[0];
$coreid_oracle_home = $ARGV[1];
$coreid_target_type = $ARGV[2];

if($coreid_oracle_home eq "NOT_DEFINED")
{
	 printf("em_result=%s|%.2f|%.2f|%.2f|%.2f|%.2f|%.2f\n",$coreid_target_type, 0, 0, 0,0, 0,0);
	 exit ;
}

#if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
#{
#    my $tempfile = $coreid_oracle_home."\\sysman\\log\\topprocs.tmp";
#	my $dirtotest = $coreid_oracle_home."\\sysman\\log";
#	if(-e $dirtotest)
#	{
#		print "file exist\n";
#	}
#	else
#	{
#		my $tempdir = $coreid_oracle_home."\\sysman";
#		my $dircmd = "mkdir $tempdir";
#		system($dircmd);
#		$tempdir = $coreid_oracle_home."\\sysman\\log";
#		$dircmd = "mkdir $tempdir";
#		system($dircmd);
#	}
#    open(FH,"> $tempfile");
#	close FH;
#}

executePSCommand(); # required by getCPUUsageForPids()/getMemoryUsageForPids()

if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
{
    getResourceUsageForNT($emd_root, $coreid_oracle_home, $coreid_target_type);
}
else  # non-windows platforms
{
    getResourceUsage($emd_root, $coreid_oracle_home,$coreid_target_type);
}

# end of main

###########################################################################

# Get OS resource usage for the given iFS processes on UNIX platforms.
# Parameters
#   emd_root - the root of the emd tree
#   coreid_oracle_home - the oracle home of the coreid target
# Return
#   For each process type, return
#    "em_result=[process_name]|[cpu_util]|[cpu_other]|[cpu_idle]|
#    [memory_usage]|[memory_usge_percent]|[memory_total]"
#
sub getResourceUsage
{
    my ($emd_root, $coreid_oracle_home,$coreid_target_type) = @_;
    my $ps_command = getPsCommand();
    my $processors = getNumCpus();
    my $process_info;
    my $cpu_usage;
    my $cpu_total;
    my $memory_usage;
    my $cpu_usage_sum = 0;
    my $memory_usage_sum = 0;
    my $cpu_total_sum = 0;
    my $cpu_total_count = 0;
   

    # get total physical memory on the system
    my $memory_metrics = getPhysicalMemoryMetrics($emd_root);
    my ($memory_total, $memory_free_raw, $page_size) =
	split('\|', $memory_metrics);

    # check Domain Controller processes
    $process_info =
	getProcessInfo("$ps_command | grep $coreid_oracle_home", 
		       $emd_root, $processors);
    ($cpu_usage, $cpu_total, $memory_usage) = split('\|', $process_info);
    $cpu_usage_sum += $cpu_usage;
    if ($cpu_total > 0)
    {
	$cpu_total_sum += $cpu_total;
	$cpu_total_count += 1;
    }
    $memory_usage_sum += $memory_usage;
    formatOutput($coreid_target_type, $cpu_usage, $cpu_total,$memory_usage, $memory_total, $processors);

}


# Get CPU usage and memory usage for the given processes.
# Parameters
#   ps_command - ps command to get the full command line
#   emd_root - the root of the emd tree
#   processors - the number of processors on the system
# Return
#   <cpuUsage>|<cpuTotal>|<memoryUsage>
#
sub getProcessInfo
{
    my ($ps_command, $emd_root, $processors) = @_;

    # get total CPU time on the system
    my $cpu_total = getTotalCpuTime();

    # Execute the ps command to find the processes
    my $ps_output = `$ps_command`;
    my @lines = split("\n", $ps_output);
    if ($#lines > -1) 
    {
	# Get the first line
	my @tokens = split(" ", $lines[0]);
	my $pid_list = $tokens[1];

	# check for many pids
	if ($#lines > 0) 
	{
	    for (my $i = 1; $i <= $#lines; $i ++) 
	    {
		@tokens = split(" ", $lines[$i]);
		$pid_list = "$pid_list,$tokens[1]";
	    }
        }        

	# Get the resource information for the pids
	my ($cpu_usage, $memory_usage) =
	    split('\|',
		  getProcessInfoFromPids($pid_list, $emd_root, $processors));

	return "$cpu_usage|$cpu_total|$memory_usage";
    }
    else # no process returned by the ps command
    {
	return "0|$cpu_total|0";
    }
}


# Get CPU usage and memory usage from pids.
# Parameters
#   pid_list - comma separated pid list
#   emd_root - the root of the emd tree
#   processors - the number of processors on the system
# Return
#   <cpuUsage>|<memoryUsage>
#
sub getProcessInfoFromPids
{
    my ($pid_list, $emd_root, $processors) = @_;

    # If we have some pids, get the cpu and memory
    my $cpu = 0; 
    my $memory = 0;
    if ($pid_list ne "") 
    {
      $cpu = getCPUUsageForPids($pid_list, $processors); 
      $memory = getMemoryUsageForPids($pid_list, $emd_root);
      if ($memory == -1) 
      {
        $memory = 0;
      }
    } 
    
    return "$cpu|$memory";
}


# Format the output of OS resource usage data.
# Parameters
#   process_name - the name that identifies a particular type of iFS process
#   cpu_usage - the CPU utilization for the given processes
#   cpu_total - the total CPU utilization on the system
#   memory_usage - the memory utilization for the given processes
#   memory_total - the total memory on the system
#   processors - the number of CPUs on the system
# Return
#   "em_result=<process_name>|<cpu_usage>|<cpu_other>|<cpu_idle>|
#    <memory_usage>|<memory_usage_percent>|<memory_total>"
#
sub formatOutput
{
    my ($process_name, $cpu_usage, $cpu_total, $memory_usage, $memory_total, $processors) = @_;

    my $cpu_component = $cpu_usage * $processors;
    if ($cpu_total < $cpu_component)
    {
	$cpu_total = $cpu_component;
    }

    my $cpu_other = ($cpu_total/$processors) - $cpu_usage;
    if (($cpu_usage + $cpu_other) > 100) 
    {
	$cpu_other = 100 - $cpu_usage;
    }
    my $cpu_idle = 100 - $cpu_usage - $cpu_other;

    if ($memory_usage < 0)
    {
	$memory_usage = 0;
    }
  my $memory_usage_percent= 0;  
  if ($memory_total>0){
      $memory_usage_percent = ($memory_usage*100)/$memory_total;
   }
    printf("em_result=%s|%.2f|%.2f|%.2f|%.2f|%.2f|%.2f\n",
	   $process_name, $cpu_usage, $cpu_other, $cpu_idle,
	   $memory_usage, $memory_usage_percent, $memory_total);
}

###########################################################################

# Get OS resource usage for the given iFS processes on Windows platforms.
# Parameters
#   emd_root - the root of the emd tree
#   coreid_oracle_home - the oracle home of the coreid target
#   coreid_target_type - COREid target type
# Return
#   For each process type, return
#    "em_result=[process_name]|[cpu_util]|[cpu_other]|[cpu_idle]|
#    [memory_usage]|[memory_usge_percent]|[memory_total]"
#
sub getResourceUsageForNT
{
    my ($emd_root, $coreid_oracle_home, $coreid_target_type) = @_;
    my $processors = getNumCpus();
    my $process_info;
    my $cpu_usage;
    my $cpu_total;
    my $memory_usage;
    my $cpu_usage_sum = 0;
    my $memory_usage_sum = 0;
    my $cpu_total_sum = 0;
    my $cpu_total_count = 0;
	my $pid;

    # get the process ids for the domain instance
    $pid = getPidsForTarget($coreid_oracle_home, $coreid_target_type);

    # get total physical memory on the system
    my $memory_metrics = getPhysicalMemoryMetrics($emd_root);
    my ($memory_total, $memory_free_raw, $page_size) =
	split('\|', $memory_metrics);

    # check Domain Controller processes
    $process_info = getNTProcessInfo($pid,$emd_root, $processors);
    ($cpu_usage, $cpu_total, $memory_usage) = split('\|', $process_info);
    $cpu_usage_sum += $cpu_usage;
    if ($cpu_total > 0)
    {
	$cpu_total_sum += $cpu_total;
	$cpu_total_count += 1;
    }
    $memory_usage_sum += $memory_usage;
    formatOutput($coreid_target_type, $cpu_usage, $cpu_total,$memory_usage, $memory_total, $processors);
}

# Get the pid of Access and Identity from the config file
# Parameters
#   coreid_oracle_home: the oracle home of the core id target
#   coreid_target_type: core id target type
# Return

sub getPidsForTarget
{
    my ($coreid_oracle_home, $coreid_target_type) = @_;

	my $PID_FILE = $coreid_oracle_home."/oblix/config/obscoreboard_params.xml";
    my $TEMP_PID = "0";
	open(FD, "$PID_FILE") or die("Couldn't open $PID_FILE\n");

	while ( my $line = <FD> ) 
	{
	   if($line =~ m/\.osb/)
	   {
		 
		   my $firstInd = rindex($line, ".osb",length($line));
		   my $secondInd = rindex($line, "/",$firstInd);
		   $TEMP_PID = substr($line,$secondInd+1,$firstInd-($secondInd+1));
		   print "pid==$TEMP_PID\n";
		   last;
	   }
	}
	   return $TEMP_PID;
}


# Get CPU usage and memory usage for the given NT processes.
# Parameters
#   pid_list - the process ids, separated by ','
#   emd_root - the root of the emd tree
#   processors - the number of processors on the system
# Return
#   <cpuUsage>|<cpuTotal>|<memoryUsage>
#
sub getNTProcessInfo
{
    my ($pid_list, $emd_root, $processors) = @_;

    # get total CPU time on the system
    my $cpu_total = getTotalCpuTime();

    if ($pid_list ne "") 
    {
	# Get the resource information for the pids
	my ($cpu_usage, $memory_usage) =
	    split('\|',
		  getProcessInfoFromPids($pid_list, $emd_root, $processors));

	return "$cpu_usage|$cpu_total|$memory_usage";
    }
    else # no process 
    {
	return "0|$cpu_total|0";
    }
}

# EOF
