#DeployMDA.py
#=======================================================================================
 
#=======================================================================================
# This script is to deploy the MDA application hosting the Data Collection module.
# How to use this Script 
# Usage: 
#       wlst DeployMDA.py <Management server host:port> <path to app> <target> <DeploymentName> <Admin Server User> <Admin Server Pwd>
#=======================================================================================

#=======================================================================================
# Failure Scenarios handled 
# STATUS=FAIL|CONNECT EXP - Failed due to exceptions during connection
# STATUS=FAIL|COULD NOT FIND STATUS - Failed while trying to fetch the status
# STATUS=FAIL|DEPLOYMENT FAILURE - Failed with exceptions during deployment
# STATUS=FAIL|ALREADY EXISTS 
# STATUS=SUCCESS - When deployed Successfuly
#======================================================================================= 

#=======================================================================================
# Function to Find the Application status.This scripts assumes None and STATE_NEW are status
# OK to deploy a new DC application
#=======================================================================================
from java.io import *
def dcAppStatus(appName, serverName):
     cd('domainRuntime:/AppRuntimeStateRuntime/AppRuntimeStateRuntime')
     #get current real state for app in specific server
     currentState = cmo.getCurrentState(appName, serverName)
     print appName      
     return currentState

        #=======================================================================================
        # Connect to the Admin Server, where the host and port is supplied as an argument
        #=======================================================================================
try:
        earPath=sys.argv[2] #MDA DC Application ear location
        wlsTargetServer =sys.argv[3] #The target WL Server Application 
        applName = sys.argv[4]  # Name of the Application
	#Get the username and passowrd through input stream
	#Need to confirm if any more vulnerabilities are there
	input = BufferedReader(InputStreamReader(System.in))
	inputStr=input.readLine()
	inputList = inputStr.split('|')
	domainUser= inputList[0]
	domainPwd = inputList[1]
	#TO_DO Need to connect using t3s protocol , will revisit this later.
        connect(domainUser,domainPwd,sys.argv[1])
except:
        print 'STATUS=FAIL|CONNECT EXP'
        exit(exitcode=1)

try:

        status =  dcAppStatus(applName,wlsTargetServer)
        print 'Current Status ====> ', status
except:
        print 'STATUS=FAIL|COULD NOT FIND STATUS'
        exit(exitcode=1)

#=======================================================================================
# deploy the application. 
# Application Name and server/cluster are supplied as arguments
# Status is already checked in the front end , this  is to ensure 
#=======================================================================================
if status == 'STATE_NEW' or  status is None:
        try:
                deploy(appName=applName,path=earPath,targets=wlsTargetServer)
                print 'STATUS=SUCCESS|NEW - DEPLOY'
                exit (exitcode=0)
        except:
                print 'STATUS=FAIL|NEW DEPLOY - DEPLOYMENT FAILURE'
                exit(exitcode=1)
else:
        try:
		# if deployed , redeploy.
		# There is a validation in the front end to check the version upgrade to do this
                stopApplication(applName)
                undeploy(applName)
                deploy(appName=applName,path=earPath,targets=wlsTargetServer)
                print 'STATUS=SUCCESS|REDEPLOY'
                exit (exitcode=0)
        except:
                print 'STATUS=FAIL|REDEPOY DEPLOYMENT FAILURE'
                exit(exitcode=1)

