#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/controlCAMMServer.pl /main/6 2011/10/07 12:10:06 jhordes Exp $
#
# controlCAMMServer.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      controlCAMMServer.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ashigoel    04/26/11 - Creation
# 
use IPC::Open3;
use File::Path;
use File::Spec();
use Cwd;
use IO::Handle;
use IO::Select;
use Thread qw(async);


my $psep="";
my $dsep="";
if ( !&IsWindows() ) {
        $psep=":";
        $dsep="/";
} else {
        $psep=";";
        $dsep="\\";
}

my $pwd = getCurrDir();
print("Current working directory: $pwd\n");


my $PYTHON_SCRIPT_PATH = $ARGV[0];
my $WLS_HOME = $ARGV[1];
my $WLS_ADMIN_URL = $ARGV[2];
my $TARGET = $ARGV[3];
my $EMAGENT_HOME = $ARGV[4];
my $EMDSTATE_DIR = $ARGV[5];
my $AGENT_KEYSTORE_LOC=$EMDSTATE_DIR."/sysman/config/montrust/AgentTrust.jks";

my $inputLine = readline(*STDIN);
my $comma_index = index($inputLine, ',');
if ($comma_index eq '-1') {
	print "Credentials string was either not delivered or is in incorrect format\n";
	exit 1;
}
my $WLS_DOMAIN_USERNAME = substr $inputLine, 0, $comma_index;
my $WLS_DOMAIN_PASSWORD = substr $inputLine, ($comma_index + 1);

print "\nPython scripts : ".$PYTHON_SCRIPT_PATH;
print "\nWls home : ".$WLS_HOME;
print "\nWls admin url : ".$WLS_ADMIN_URL;
print "\nWls username : ".$WLS_DOMAIN_USERNAME;
print "\nTarget : ".$TARGET;
print "\nAGENT_KEYSTORE_LOC : ".$AGENT_KEYSTORE_LOC."\n";

# Change the working directory
print("Changing to WLS Home directory: $WLS_HOME \n");
chdir $WLS_HOME;

my $DEPLOY_SCRIPT_PATH=$PYTHON_SCRIPT_PATH;
my $LOG_FILE_DESTINATION=$EMDSTATE_DIR.$dsep."temp_adp_agent_logs_dir".$dsep."wlstLogs.log";
my $CLASSPATH=$WLS_HOME.$dsep."server".$dsep."lib".$dsep."weblogic_sp.jar".$psep.$WLS_HOME.$dsep."server".$dsep."lib".$dsep."weblogic.jar".$psep.$WLS_HOME.$dsep."..".$dsep."modules".$dsep."features".$dsep."weblogic.server.modules_10.3.2.0.jar".$psep.$WLS_HOME.$dsep."server".$dsep."lib".$dsep."webservices.jar".$psep.$WLS_HOME.$dsep."..".$dsep."modules".$dsep."org.apache.ant_1.7.0".$dsep."lib".$dsep."ant-all.jar".$psep.$WLS_HOME.$dsep."modules".$dsep."net.sf.antcontrib_1.0.0.0_1-0b2".$dsep."lib".$dsep."ant-contrib.jar";
my $AGENT_JAVA = $EMAGENT_HOME.$dsep."jdk".$dsep."bin".$dsep."java";
my $DEPLOY_CMD="$AGENT_JAVA -cp $CLASSPATH  -Dweblogic.security.SSL.ignoreHostnameVerify=true -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.trustedCAKeyStore=$AGENT_KEYSTORE_LOC -Dwlst.offline.log=$LOG_FILE_DESTINATION weblogic.WLST $DEPLOY_SCRIPT_PATH";

open my $oldout, ">&STDOUT" or die "Can't dup STDOUT: $!";
open my $olderr, ">&STDERR" or die "Can't dup STDERR: $!";
 
my $status = execWLSTScript();
if ($status==0) {
	print "\n **** Operation was successful ****\n";
	exit(0);
} else {
	print "\n **** Operation was NOT successful ****\n";
	exit(-1);
}

sub execWLSTScript() {
   print "Executing deploy application command : $DEPLOY_CMD\n";
    
   my $STATUS = -1;
   if(&IsWindows())
   {
        local (*HANDLE_IN, *HANDLE_OUT);
        $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD)  or die "open3 failed $!\n";
		$thr = async { 
			print HANDLE_IN "$WLS_DOMAIN_USERNAME\r\n";
			print HANDLE_IN "$WLS_DOMAIN_PASSWORD\r\n";
			print HANDLE_IN "$WLS_ADMIN_URL\r\n";     
			print HANDLE_IN "$TARGET\r\n";

			my $nextLine;
			while(<HANDLE_OUT>) {		
				$nextLine= $_;	
				print $nextLine;
			}
		 
			close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
			close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
		};		
		waitpid ($pid,0);
		$STATUS = $?;
		print "Status returned from the process is $STATUS\r\n"; 
		$thr->join; 
		return $STATUS;
    } else {
    
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        $pid = open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD);
		$thr = async { 
			print HANDLE_IN "$WLS_DOMAIN_USERNAME\r\n";
			print HANDLE_IN "$WLS_DOMAIN_PASSWORD\r\n";
			print HANDLE_IN "$WLS_ADMIN_URL\r\n";
			print HANDLE_IN "$TARGET\r\n";

			my $sel = new IO::Select; 
			$sel->add(\*HANDLE_OUT,\*HANDLE_ERR);
			
			while(my @ready = $sel->can_read) { 
				foreach my $fh (@ready) 
				{
					my $line = <$fh>; 
					if(not defined $line){
						$sel->remove($fh); 
						next;              
					}
					if(fileno($fh) == fileno(HANDLE_OUT)) {     
						print $oldout $line;
					} elsif(fileno($fh) == fileno(HANDLE_ERR)) {
						print $olderr $line;
					} else { # we read from something else?
						die "Reading wrong file handle!\n";
					}
				}
			}

			close(HANDLE_IN)  or die "Can't close filehandle! $!";
			close(HANDLE_OUT)  or die "Can't close filehandle! $!";
			close(HANDLE_ERR)  or die "Can't close filehandle! $!";
		};		
		waitpid ($pid,0);
		$STATUS = $?;
		print "Status returned from the process is $STATUS\r\n"; 
		$thr->join; 
		return $STATUS;
    }
}

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}


#Subroutine to get the current directory
sub getCurrDir() {
    my $pwd = getcwd();
    if ( &IsWindows() ) {
        $pwd =~ s/\//\\/g;
    }
    return $pwd;
}

sub checkExitCode($) {
    my ($exit_value) = @_;
    $exit_value = $exit_value >> 8;
    return $exit_value;
}
