#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/deployHttpDeployer_nonWLST.pl /main/8 2012/04/15 03:56:09 rahgupta Exp $
#
# deployHttpDeployer.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      deployHttpDeployer.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    papagupt    09/21/10 - changing ORACLE_HOME
#    ashigoel    07/13/10 - This perl script is for deploying HttpDeployer.ear
#                           on the target server.
#    ashigoel    07/13/10 - Creation
# 
use IPC::Open3;
use File::Path;
use File::Spec();
use Cwd;
use IO::Handle;
use IO::Select;
use Thread qw(async);

my $psep="";
my $dsep="";
if ( !&IsWindows() ) {
        $psep=":";
        $dsep="/";
} else {
        $psep=";";
        $dsep="\\";
}

my $pwd = getCurrDir();
print("Current working directory: $pwd\n");

my $EMAGENT_HOME = $ARGV[0];
my $EMSTATE_DIR = $ARGV[1];
#my $IS_JDK5 = $ARGV[2];
my $MIDDLEWARE_HOME = $ARGV[2];
my $IS_WEBLOGIC9 = $ARGV[3];
#my $JVM_VENDOR = $ARGV[5];
my $ACSERA_HOME = $ARGV[4];
my $WLS_ADMIN_URL = $ARGV[5];
my $TARGET = $ARGV[6];
my $WEBLOGIC_JAR_PATH = $ARGV[7];
my $APP_NAME = "HttpDeployer";
my $AGENT_KEYSTORE_LOC=$EMSTATE_DIR."/sysman/config/montrust/AgentTrust.jks";

my $inputLine = readline(*STDIN);
my $comma_index = index($inputLine, ',');
if ($comma_index eq '-1') {
	print "Credentials string was either not delivered or is in incorrect format\n";
	exit 1;
}
my $WLS_DOMAIN_USERNAME = substr $inputLine, 0, $comma_index;
my $WLS_DOMAIN_PASSWORD = substr $inputLine, ($comma_index + 1);

print "\nEM Agent home : ".$EMAGENT_HOME;
#print "\nIs JDK5 : ".$IS_JDK5;
print "\nMIDDLEWARE_HOME : ".$MIDDLEWARE_HOME;
print "\nIS_WEBLOGIC9 : ".$IS_WEBLOGIC9;
#print "\nJVM Vendor : ".$JVM_VENDOR;
print "\nem agent state dir : ".$EMSTATE_DIR;
print "\nacsera home : ".$ACSERA_HOME;
print "\nwls admin url : ".$WLS_ADMIN_URL;
print "\nwls username : ".$WLS_DOMAIN_USERNAME;
print "\ntarget : ".$TARGET;
print "\nweblogic jar path : ".$WEBLOGIC_JAR_PATH;
print "\napplication name : ".$APP_NAME;
print "\nagent keystore location : ".$AGENT_KEYSTORE_LOC."\n";

if ($WEBLOGIC_JAR_PATH eq "") {
	$WEBLOGIC_JAR_PATH = $EMAGENT_HOME.$dsep."sysman".$dsep."jlib".$dsep."wlfullclient.jar".$psep.
		                 $EMAGENT_HOME.$dsep."sysman".$dsep."jlib".$dsep."cryptoj.jar".$psep.
		                 $EMAGENT_HOME.$dsep."sysman".$dsep."jlib".$dsep."webserviceclient+ssl.jar".$psep.
		                 $EMAGENT_HOME.$dsep."sysman".$dsep."jlib".$dsep."wlcipher.jar";
	print "weblogic.jar could not be located. Using the following jars:\n";
	print "1) wlfullclient.jar\n";
	print "2) cryptoj.jar\n";
	print "3) webserviceclient+ssl.jar\n";
	print "4) wlcipher.jar\n";
	print "These jars should be present under ".$EMAGENT_HOME.$dsep."sysman".$dsep."jlib\n";
	print "(2) and (3) are required only if the deployment is happening over ssl\n";
	print "(4) is required only when the admin channel is enabled at the targeted domain\n";
}

#extracting ADPAgent.zip which is present in ACSERA_HOME
if(!&IsWindows() ) {
    chdir $ACSERA_HOME;
    system($EMAGENT_HOME.'/bin/unzip -o ADPAgent.zip -d ADPAgent');
} else {
    chdir $ACSERA_HOME;
    system($EMAGENT_HOME.'\bin\unzip.exe -o ADPAgent.zip -d ADPAgent');
}
$ACSERA_HOME=$ACSERA_HOME.$dsep."ADPAgent";
my $ARCHIVE_PATH = $ACSERA_HOME.$dsep."deploy".$dsep."HttpDeployer.ear";

my $deployer_class="com.acsera.ejb.Deployer.RemoteHttpDeployerShell";
my $CLASSPATH=$ACSERA_HOME.$dsep."lib".$dsep."mips.jar".$psep.$WEBLOGIC_JAR_PATH;
my $AGENT_JAVA = $EMAGENT_HOME.$dsep."jdk".$dsep."bin".$dsep."java";

my $jvmArgs = " -Dweblogic.security.SSL.ignoreHostnameVerify=true -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.trustedCAKeyStore=$AGENT_KEYSTORE_LOC";
#if(($IS_JDK5 eq "true") && ($JVM_VENDOR eq "Sun Microsystems Inc.")) {
$jvmArgs = $jvmArgs." -Dsun.lang.ClassLoader.allowArraySyntax=true";
#}

if ($IS_WEBLOGIC9 eq "true") {
	$jvmArgs = $jvmArgs." -Dbea.home=$MIDDLEWARE_HOME";
}

my $UNDEPLOY_CMD = "$AGENT_JAVA -cp $CLASSPATH".$jvmArgs
              ." $deployer_class -undeploy -adminurl $WLS_ADMIN_URL -targets $TARGET -username $WLS_DOMAIN_USERNAME -name $APP_NAME -usenonexclusivelock";
my $DEPLOY_CMD="$AGENT_JAVA -cp $CLASSPATH".$jvmArgs
              ." $deployer_class -deploy -adminurl $WLS_ADMIN_URL -upload -source $ARCHIVE_PATH -targets $TARGET -username $WLS_DOMAIN_USERNAME -name $APP_NAME -usenonexclusivelock";

print "Command used for deployment: ".$DEPLOY_CMD."\n";

open my $oldout, ">&STDOUT" or die "Can't dup STDOUT: $!";
open my $olderr, ">&STDERR" or die "Can't dup STDERR: $!";

print "\nThe application will be first undeployed on the targeted server\n";
my $CMD=$UNDEPLOY_CMD;
execJavaCommands();

print "\nThe application will now be deployed on the targeted server\n";
$CMD=$DEPLOY_CMD;
my $status = execJavaCommands();
if ($status==0) {
	print "\n **** Deployment was successful ****\n";
	exit(0);
} else {
	print "\n **** Deployment was NOT successful ****\n";
	exit(-1);
}

sub execJavaCommands {
   my $STATUS = -1;
   if(&IsWindows()) {
        local (*HANDLE_IN, *HANDLE_OUT);
        $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $CMD)  or die "open3 failed $!\r\n";
		$thr = async { 
			print HANDLE_IN "$WLS_DOMAIN_PASSWORD\r\n";

			my $nextLine;
			while(<HANDLE_OUT>) {		
				$nextLine= $_;	
				print $nextLine;
			}
		 
			close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
			close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
        };
		waitpid ($pid,0);
		$STATUS = $?;
		print "Status returned from the java process is $STATUS\r\n"; 
		$thr->join; 
		return $STATUS;
    } else {
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        $pid = open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $CMD);
		$thr = async { 
			print HANDLE_IN "$WLS_DOMAIN_PASSWORD\r\n";

			my $sel = new IO::Select; 
			$sel->add(\*HANDLE_OUT,\*HANDLE_ERR);
			
			while(my @ready = $sel->can_read) { 
				foreach my $fh (@ready) 
				{
					my $line = <$fh>; 
					if(not defined $line){
						$sel->remove($fh); 
						next;              
					}
					if(fileno($fh) == fileno(HANDLE_OUT)) {     
						print $oldout $line;
					} elsif(fileno($fh) == fileno(HANDLE_ERR)) {
						print $olderr $line;
					} else { # we read from something else?
						die "Reading wrong file handle!\n";
					}
				}
			}

			close(HANDLE_IN)  or die "Can't close filehandle! $!";
			close(HANDLE_OUT)  or die "Can't close filehandle! $!";
			close(HANDLE_ERR)  or die "Can't close filehandle! $!";
		};
		waitpid ($pid,0);
		$STATUS = $?;
		print "Status returned from the java process is $?\n"; 
		$thr->join; 
		return $STATUS;
    }
}

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}


#Subroutine to get the current directory
sub getCurrDir() {
    my $pwd = getcwd();
    if ( &IsWindows() ) {
        $pwd =~ s/\//\\/g;
    }
    return $pwd;
}

sub checkExitCode($) {
    my ($exit_value) = @_;
    $exit_value = $exit_value >> 8;
    return $exit_value;
}
