#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/deploy_camm.pl /main/20 2012/06/21 01:09:18 habatra Exp $
#
# deploy_camm.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      deploy_camm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    manidesh    05/29/12 - Add iterator to undeploy jamagent
#    ashivaha    04/03/12 - XbranchMerge ashivaha_bug-13734431 from
#                           st_emgc_12.1.0.1bp12.1.0.2pg
#    papagupt    05/26/10 - Creation
#
use strict;
use warnings;
use Getopt::Long;
use Cwd;
use IPC::Open3;
use File::Path;
use File::Spec();
use IO::Handle;
use IO::Select;


my $psep="";
my $dsep="";
if ( !&IsWindows() ) {
        $psep=":";
        $dsep="/";
} else {
        $psep=";";
        $dsep="\\";
}

sub IsWindows {
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}

#sub usage {
#	print "Usage: perl adpDeployAgent.pl <required arguments>\n";
#	print "   where required arguments consist of the following:-\n";
#	print "       -ACSERA_HOME - Path to the directory where the unzipped camm home is \n";
#	print "       -command - this can take a lot of values. Important ones are '-deploy', '-disable', '-remove' and '-ejbundeploy'\n";
#	print "       -adminurl - URL that can be used to connect to the AdminServer of the target WLS domain. eg: t3://localhost:7001\n";
#	print "       -version - Weblogic version. eg: 11.1.0 or 10.3.0\n";
#	print "       -targets - List of the name of the servers separated by : sign\n";
#	print "       -node_manager_selected - Boolean : true if node manager is being used with the target weblogic servers\n";
#}


#my $ACSERA_HOME='';
#my $command='';
#my $adminurl='';
#my $version='';
#my $targets=''; #list of targets separated by : sign
#my $node_manager_selected='';
#;
#
#my $username = '';
#my $password = '';
#
#my %options=();
#GetOptions('ACSERA_HOME=s'=>\$ACSERA_HOME,
#	   'command=s'=>\$command,
#	   'adminurl=s'=>\$adminurl,
#	   'version=s'=>\$version,
#	   'targets=s'=>\$targets,
#	   'node_manager_selected=s'=>\$node_manager_selected);

my $EMDROOT=$ARGV[0];
my $EMDSTATE_DIR=$ARGV[1];
my $ACSERA_HOME=$EMDSTATE_DIR."/temp_adp_agent_dir";
my $AGENT_KEYSTORE_LOC=$EMDSTATE_DIR."/sysman/config/montrust/AgentTrust.jks";
my $UNZIP=$EMDROOT."/bin/unzip";
my $command=$ARGV[2];
my $adminurl=$ARGV[3];
my $version=$ARGV[4];
my $targets=$ARGV[5]; #list of targets separated by : sign
my $node_manager_selected=$ARGV[6];
my $MIDDLEWARE_HOME = $ARGV[7];
my $httpProtocol = $ARGV[8];
my $httpPort = $ARGV[9];

my $ejbpath = "";
my $deployname = "";
my $isNonAdp ;
my $jarPath = "";

if (@ARGV==13){
	$deployname =  $ARGV[10];
	$ejbpath = $ARGV[11];
	$jarPath= $ARGV[12];
	$isNonAdp = "true";
}

my $inputLine = readline(*STDIN);
my $comma_index = index($inputLine, ',');

if ($comma_index eq '-1') {
	print "Credentials string was either not delivered or is in incorrect format\n";
	exit 1;
}

my $username = substr $inputLine, 0, $comma_index;
my $password = substr $inputLine, ($comma_index + 1);
print "ACSERA_HOME : $ACSERA_HOME\n";
print "AGENT_KEYSTORE_LOC : $AGENT_KEYSTORE_LOC\n";
print "MIDDLEWARE_HOME : $MIDDLEWARE_HOME\n";
print "Command : $command\n";
print "adminurl : $adminurl\n";
print "version : $version\n";
print "targets : $targets\n";
print "user : $username\n";
print "Node Manager Selected : $node_manager_selected\n";
print "httpProtocol : $httpProtocol\n";
print "httpPort : $httpPort\n";
print "ejbpath : $ejbpath\n";
print "deployname : $deployname\n";
print "jarPath: $jarPath\n";

$targets =~ s/\:/\,/g; #now comma separated


#extracting ADPAgent.zip which is present in ACSERA_HOME
if(!&IsWindows() ) {
    chdir $ACSERA_HOME;
    system($EMDROOT.'/bin/unzip -o ADPAgent.zip -d ADPAgent');
} else {
    chdir $ACSERA_HOME;
    system($EMDROOT.'\bin\unzip.exe -o ADPAgent.zip -d ADPAgent');
}
# now ACSERA_HOME contains camm_agent folder, so changing ACSERA_HOME so that camm_agent folder is the ACSERA_HOME
$ACSERA_HOME=$ACSERA_HOME.$dsep."ADPAgent";

open my $oldout, ">&STDOUT" or die "Can't dup STDOUT: $!";
open my $olderr, ">&STDERR" or die "Can't dup STDERR: $!";

my $result = "false";
my $success_message = "Deployment procedure completed successfully";
my $AGENT_JAVA = $EMDROOT.$dsep."jdk".$dsep."bin".$dsep."java";
my $pathSep;
my $classpathWLS;
if( &IsWindows() ) {
   $pathSep = ";";
}
else {
   $pathSep = ":";
} 

if( $command eq "-ejbundeploy" && $isNonAdp ) {
    my $original_name = $deployname;
    $result = execDeployer();                                                                                                                            
    my @servers = split(',', $targets);
    foreach my $server (@servers) {
         $deployname = $original_name . '_' . $server;
        #undeploy for each server
        $result = execDeployer();
        print "\n ***** Undeploying $deployname ******\n";
    }

}
else {
     $result = execDeployer();                                                                                                                            
 }
 if ( $result ) {
    print "\n **** Operation was successful ****\n";
    exit(0);
 } else {
    print "\n **** Operation was NOT successful ****\n";
    exit(-1);
 }


sub execDeployer
{
  my $STATUS = "false";
  if (!&IsWindows() ) {

    local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        if($isNonAdp){
            $classpathWLS="$jarPath${pathSep}";
        }
	$classpathWLS=$classpathWLS."$ACSERA_HOME/lib/core.jar${pathSep}$ACSERA_HOME/lib/commons-jxpath.jar${pathSep}$ACSERA_HOME/lib/jaxb-impl.jar${pathSep}$ACSERA_HOME/lib/xsdlib.jar${pathSep}$ACSERA_HOME/lib/relaxngDatatype.jar${pathSep}$ACSERA_HOME/lib/jaxb-libs.jar";
	print "classpathWLS : $classpathWLS\n";
	my $deployer_class="com.acsera.configuration.ADPDeployAgent";
	my @args = ($AGENT_JAVA, "-cp",$classpathWLS,"-Dweblogic.security.SSL.ignoreHostnameVerify=true","-Dbea.home=$MIDDLEWARE_HOME","-Djava.security.egd=file:/dev/./urandom","-Dacsera.home=$ACSERA_HOME","-Dacsera.lib=$ACSERA_HOME/lib","-Djava.security.policy=$ACSERA_HOME/config/policy.all","-Dacsera.log.copyout=true","-Dweblogic.security.SSL.trustedCAKeyStore=$AGENT_KEYSTORE_LOC","-Djavax.net.ssl.trustStore=$AGENT_KEYSTORE_LOC","-Dsun.lang.ClassLoader.allowArraySyntax=true",$deployer_class,$command,"-adminurl", $adminurl,"-username", $username,"-version", $version, "-targets", $targets, "-node_manager_selected", $node_manager_selected, "-httpprotocol", $httpProtocol, "-httpport", $httpPort);
	if($isNonAdp){
		my @pushedargs = ("-ejbpath", $ejbpath, "-deployname", $deployname);
		push ( @args , @pushedargs);
	}

        my $pid=open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, @args);
	    print "args @args\n";
        print HANDLE_IN "$password\n";
        
		my $sel = new IO::Select; 
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);
        
        while(my @ready = $sel->can_read) { 
            foreach my $fh (@ready) 
            {
                my $line = <$fh>; 
                if(not defined $line){
                    $sel->remove($fh); 
                    next;              
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {     
                    print $oldout $line;
					if($line =~ m/($success_message)/i) {
                        $STATUS = "true";
                    }
                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print $olderr $line;
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
    
} else {
    
    	local (*HANDLE_IN, *HANDLE_OUT);
        if($isNonAdp){
            $classpathWLS="$jarPath${pathSep}";
        }
	$classpathWLS=$classpathWLS."$ACSERA_HOME\\lib\\core.jar${pathSep}$ACSERA_HOME\\lib\\commons-jxpath.jar${pathSep}$ACSERA_HOME\\lib\\jaxb-impl.jar${pathSep}$ACSERA_HOME\\lib\\xsdlib.jar${pathSep}$ACSERA_HOME\\lib\\relaxngDatatype.jar${pathSep}$ACSERA_HOME\\lib\\jaxb-libs.jar";
	print "classpathWLS : $classpathWLS\n";
	my $deployer_class="com.acsera.configuration.ADPDeployAgent";
	my @args = ($AGENT_JAVA,"-cp",$classpathWLS,"-Dweblogic.security.SSL.ignoreHostnameVerify=true","-Dbea.home=$MIDDLEWARE_HOME","-Djava.security.egd=file:\\dev\\.\\urandom","-Dacsera.home=$ACSERA_HOME","-Dacsera.lib=$ACSERA_HOME\\lib","-Djava.security.policy=$ACSERA_HOME\\config\\policy.all","-Dacsera.log.copyout=true","-Dweblogic.security.SSL.trustedCAKeyStore=$AGENT_KEYSTORE_LOC","-Djavax.net.ssl.trustStore=$AGENT_KEYSTORE_LOC","-Dsun.lang.ClassLoader.allowArraySyntax=true",$deployer_class,$command,"-adminurl", $adminurl,"-username", $username,"-version", $version, "-targets", $targets,  "-node_manager_selected", $node_manager_selected, "-httpprotocol", $httpProtocol, "-httpport", $httpPort);
	if($isNonAdp){
		my @pushedargs = ("-ejbpath", $ejbpath, "-deployname", $deployname);
	        push ( @args , @pushedargs);
	}
        my $pid=open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_OUT, @args);
        print "args @args\n";
        print HANDLE_IN "$password\r\n";

		my $nextLine;
        while(<HANDLE_OUT>) {		
            $nextLine= $_;	
            print $nextLine;

            # i for case insensitive match
            if($nextLine =~ m/($success_message)/i) {
                $STATUS = "true";
            }
        }
     
        close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
        close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";

    }
 
    return $STATUS;

}
