#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/deploy_jvmd.pl /main/5 2012/05/07 22:59:17 habatra Exp $
#
# deployHttpDeployer.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      deployHttpDeployer.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    papagupt    09/21/10 - changing ORACLE_HOME
#    ashigoel    07/13/10 - This perl script is for deploying HttpDeployer.ear
#                           on the target server.
#    ashigoel    07/13/10 - Creation
# 
use IPC::Open3;
use File::Path;
use File::Spec();
use Cwd;
use IO::Handle;
use IO::Select;


my $psep="";
my $dsep="";
if ( !&IsWindows() ) {
        $psep=":";
        $dsep="/";
} else {
        $psep=";";
        $dsep="\\";
}

my $pwd = getCurrDir();
print("Current working directory: $pwd\n");

my $emd_root = $ARGV[0];
my $agent_trust_keystore = $ARGV[1];
my $job_dest_temp_dir = $ARGV[2];
my $weblogicJarAbsPath = $ARGV[3];
my $className = $ARGV[4];
my $target_name = $ARGV[5];
my $job_dest_war_files = $ARGV[6];
my $job_dest_war_files_rebuilt = $ARGV[7];
my $targetHosts = $ARGV[8];
my $targetWeblogicPorts = $ARGV[9];
my $weblogicTargetNames = $ARGV[10];
my $job_ad4j_manager_ip = $ARGV[11];
my $isSsl = $ARGV[12];
my $isForce = $ARGV[13];
my $job_ad4j_manager_port = $ARGV[14];
my $domain = $ARGV[15];
my $target_type = $ARGV[16];
my $isSecureIntVal = $ARGV[17];
my $walletPassEncypted = $ARGV[18];
my $job_dest_ear_files_orig = $ARGV[19];
my $job_dest_ear_files_rebuilt = $ARGV[20];
#my $JVM_VENDOR = $ARGV[21];
#my $IS_JDK5 = $ARGV[22];
my $MIDDLEWARE_HOME = $ARGV[21];
my $IS_WEBLOGIC9 = $ARGV[22];
my $jvmArgs = "";
if ($agent_trust_keystore ne "") {
	$jvmArgs = "-Dweblogic.security.SSL.ignoreHostnameVerify=true -Dweblogic.security.SSL.trustedCAKeyStore=".$agent_trust_keystore;
}

#if(($IS_JDK5 eq "true") && ($JVM_VENDOR eq "Sun Microsystems Inc.")) {
$jvmArgs = $jvmArgs." -Dsun.lang.ClassLoader.allowArraySyntax=true";
#}

if ($IS_WEBLOGIC9 eq "true") {
	$jvmArgs = $jvmArgs." -Dbea.home=$MIDDLEWARE_HOME";
}


my $username_password = readline(*STDIN);

print "\n EMD root = $emd_root";
print "\n jvmArgs = $jvmArgs";
#print "\nIs JDK5 : ".$IS_JDK5;
print "\nMIDDLEWARE_HOME : ".$MIDDLEWARE_HOME;
#print "\nJVM Vendor : ".$JVM_VENDOR;
print "\n job_dest_temp_dir = $job_dest_temp_dir";
print "\n weblogicJarAbsPath = $weblogicJarAbsPath";
print "\n className = $className";
print "\n target_name = $target_name";
print "\n job_dest_war_files = $job_dest_war_files";
print "\n job_dest_war_files_rebuilt = $job_dest_war_files_rebuilt";
print "\n targetHosts = $targetHosts";
print "\n targetWeblogicPorts = $targetWeblogicPorts";
print "\n weblogicTargetNames = $weblogicTargetNames";
print "\n job_ad4j_manager_ip = $job_ad4j_manager_ip";
print "\n isSsl = $isSsl";
print "\n isForce = $isForce";
print "\n job_ad4j_manager_port = $job_ad4j_manager_port";
print "\n domain = $domain";
print "\n target_type = $target_type";
print "\n isSecureIntVal = $isSecureIntVal";
print "\n job_dest_ear_files_orig = $job_dest_ear_files_orig";
print "\n job_dest_ear_files_rebuilt = $job_dest_ear_files_rebuilt\n\n";

my $JARSPATH = $weblogicJarAbsPath;
if ($JARSPATH eq "") {
	$JARSPATH = $emd_root.$dsep."sysman".$dsep."jlib".$dsep."wlfullclient.jar".$psep.
		        $emd_root.$dsep."sysman".$dsep."jlib".$dsep."cryptoj.jar".$psep.
		        $emd_root.$dsep."sysman".$dsep."jlib".$dsep."webserviceclient+ssl.jar".$psep.
		        $emd_root.$dsep."sysman".$dsep."jlib".$dsep."wlcipher.jar";
	print "weblogic.jar could not be located. Using the following jars:\n";
	print "1) wlfullclient.jar\n";
	print "2) cryptoj.jar\n";
	print "3) webserviceclient+ssl.jar\n";
	print "4) wlcipher.jar\n";
	print "These jars should be present under ".$emd_root.$dsep."sysman".$dsep."jlib\n";
	print "(2) and (3) are required only if the deployment is happening over ssl\n";
	print "(4) is required only when the admin channel is enabled at the targeted domain\n";
}

my $DEPLOY_CMD = "$emd_root".$dsep."jdk".$dsep."bin".$dsep."java ".$jvmArgs." -cp ".$job_dest_temp_dir.$dsep."WEB-INF".$dsep."classes".$psep.
$JARSPATH." ".$className." ".$target_name." ".$job_dest_temp_dir." ".$job_dest_war_files." ".$job_dest_war_files_rebuilt." ".
$targetHosts." ".$targetWeblogicPorts." ".$weblogicTargetNames." ".$job_ad4j_manager_ip." ".$isSsl." ".$isForce." ".$job_ad4j_manager_port." ".
$domain." ".$target_type." ".$isSecureIntVal." ".$walletPassEncypted." ".$job_dest_ear_files_orig." ".$job_dest_ear_files_rebuilt;

print "Command used for deployment: ".$DEPLOY_CMD."\n";
open my $oldout, ">&STDOUT" or die "Can't dup STDOUT: $!";
open my $olderr, ">&STDERR" or die "Can't dup STDERR: $!";

print "\nThe application will now be deployed on the targeted server\n";
my $CMD=$DEPLOY_CMD;
my $status = execJavaCommands();
if ($status==0) {
	print "\n **** Deployment was successful ****\n";
} else {
	print "\n **** Deployment was NOT successful ****\n";
}
exit($status);


sub execJavaCommands {
   my $STATUS = "false";
#This Success Message will be passed by oracle.sysman.e2e.model.ad4j.util.RebuildWar after recreating javadiagnosticagent.ear
#Please do not change the String.
   my $success_message1 = "Updation procedure completed successfully";
   my $success_message2 = "FinalState=completed";
   if(&IsWindows())
   {
        local (*HANDLE_IN, *HANDLE_OUT);
        $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $CMD)  or die "open3 failed $!\n";
        print HANDLE_IN "$username_password\r\n";

        my $nextLine;
        while(<HANDLE_OUT>) {		
            $nextLine= $_;	
            print $nextLine;

            # i for case insensitive match
            if($nextLine =~ m/($success_message1)/i) {
                $STATUS = "true";
            }
        }
     
        close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
        close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
        
    } else {
    
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        $pid = open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $CMD);
        print HANDLE_IN "$username_password\r\n";

        my $sel = new IO::Select; 
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);
        
        while(my @ready = $sel->can_read) { 
            foreach my $fh (@ready) 
            {
                my $line = <$fh>; 
                if(not defined $line){
                    $sel->remove($fh); 
                    next;              
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {     
                    print $oldout $line;
					if($line =~ m/($success_message1)/i) {
						$STATUS = "true";
					}
                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print $olderr $line;
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
    }
	
    if ( $STATUS eq "false" ) {
        return -1;
    } else {
		return 0;
	}
}

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}


#Subroutine to get the current directory
sub getCurrDir() {
    my $pwd = getcwd();
    if ( &IsWindows() ) {
        $pwd =~ s/\//\\/g;
    }
    return $pwd;
}

sub checkExitCode($) {
    my ($exit_value) = @_;
    $exit_value = $exit_value >> 8;
    return $exit_value;
}
