#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/startWeblogicServer.pl /main/1 2010/09/18 18:15:57 vepadman Exp $
#
# startWeblogicServer.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      startWeblogicServer.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rkuriako    07/14/09 - Creation
# 

use File::Path;
use File::Spec();
use File::Copy;

my $DOMAIN_HOME = $ARGV[0];
my $SERVER_NAME = $ARGV[1];
my $LOG_LOC   = "./";
print "DOMAIN_HOME: $DOMAIN_HOME\n" ;
print "SERVER_NAME: $SERVER_NAME\n" ;
print "LOG_LOC:  $LOG_LOC\n" ;

my $logfile;
my $cmd;

  $logfile = File::Spec->catfile($LOG_LOC, time());
  $logfile = $logfile . "_startup.log";

   #handle windows
    if ( IsWindows() ) {
       $cmd =  File::Spec->catfile($DOMAIN_HOME, "startWebLogic.cmd");
    }
    else{
      $cmd =  File::Spec->catfile($DOMAIN_HOME, "startWebLogic.sh");
      $cmd= $cmd . " >& $logfile &";
    }


print "$cmd\n";

system($cmd);

 if ( &checkExitCode($?) ) {
        print "WebLogic Server start up failed \n";
        exit -1;
    }
    
#wait for server start up
my $counter = 10;
my $state;
my $search_string = "Server started in RUNNING mode";

while( $counter-- && ( $state ne "RUNNING" ) ){
	print "sleep 60 seconds...\n";
	sleep(60); 
	
	$cmd="grep -c \"$search_string\" $logfile";

	print "executing: $cmd\n";

    	my $retVal=`$cmd`;
	
	if ($retVal > 0 ) {
        print "Weblogic Server $SERVER_NAME in running mode\n";
		$state = "RUNNING"; 
	}
}

if( $state eq "RUNNING" ) {
	print "Weblogic Server $SERVER_NAME started\n";
	unlink($logfile);
	exit 0;
}
else {
	print "Weblogic Server $SERVER_NAME startup failed\n";
	unlink($logfile);
	exit -1;
}

sub checkExitCode($) {
    my ($exit_value) = @_;
    $exit_value = $exit_value >> 8;
    return $exit_value;
}

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
