#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/stopCamm.pl /main/4 2011/03/24 02:37:38 ashigoel Exp $
#
# stopCamm.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      stopCamm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    papagupt    07/02/10 - To stop ocamm manager on target

use IO::Socket::INET; 
use File::Path;
use File::Spec();
use File::Copy;

my $hostname = $ARGV[0];
my $portnumber = $ARGV[1];
my $ACSERA_HOME = $ARGV[2];
my $JAVA_HOME="/usr/local/packages/jdk16";

$ENV{'ACSERA_HOME'}=$ACSERA_HOME;
$ENV{'JAVA_HOME'}=$JAVA_HOME;


print "HOST NAME : ".$hostname."\n";
print "PORT NUMBER : ".$portnumber."\n";
print "ADP_HOME : ".$ACSERA_HOME."\n";
print "JAVA_HOME : ".$JAVA_HOME."\n";
my $LOG_LOC   ="./";
my $con_status = 1;
my $cmd;
my $counter = 0;

$logfile = File::Spec->catfile($LOG_LOC, time());
$logfile = $logfile . "_stop.log";


print "$dir\n";

$con_status = check_port();
if ($con_status == 1) {
		print("ADP Manager is already stopped\n");
		unlink($logfile);
		exit 0;
}

if ( IsWindows() ) {
       $cmd =  File::Spec->catfile($ACSERA_HOME, "bin");
       $cmd =  File::Spec->catfile($cmd, "acshut.bat");
    }
    else{
      $cmd =  File::Spec->catfile($ACSERA_HOME, "bin");
      $cmd =  File::Spec->catfile($cmd, "acshut.sh");
	  $cmd= $cmd . " >& $logfile &";
    }

system($cmd);
sleep(90);
print("Waiting for ADP Manager to stop...\n");
while($counter != 5){
	$con_status = check_port();
	if ($con_status == 1) {
		print("ADP Manager STOPPED\n");
		unlink($logfile);
		exit 0;
	}
	sleep(30);
	print "sleeping for 30 secs\n";
	$counter++;
	if($counter == 5){
		print "Failed to stop ADP Manager\n";
		unlink($logfile);
		exit 1;
	}
}


sub IsWindows {
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}

sub check_port(){
	
my $host = shift || $hostname;
my $port = shift || $portnumber;
my $proto = getprotobyname('tcp');
#Attempt to connect to $host on $port. 
my $socket; 
my $success = eval { 
	$socket = IO::Socket::INET->new( PeerAddr => $host, PeerPort => $port, Proto => 'tcp' ) 
	}; 
	#If the port was opened, say it was and close it. 
	if ($success) { shutdown($socket, 2); return 0;} 
	else {return 1;}
}
