#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/stopWeblogicServer.pl /main/1 2010/09/18 18:15:57 vepadman Exp $
#
# stopWeblogicServer.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      stopWeblogicServer.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rkuriako    07/14/09 - Creation
# 

use File::Path;
use File::Spec();
use File::Copy;

my $DOMAIN_HOME = $ARGV[0];
my $SERVER_NAME = $ARGV[1];
my $LOG_LOC   = "./";#$ARGV[4];
my $ADMIN_HOST = $ARGV[2];
my $ADMIN_PORT = $ARGV[3];
print "DOMAIN_HOME: $DOMAIN_HOME\n" ;
print "SERVER_NAME: $SERVER_NAME\n" ;
print "ADMIN_HOST: $ARGV[2]\n";
print "ADMIN_PORT: $ARGV[3]\n";

my $input = readline(*STDIN);
my @credentials = split(',',$input);
my $numInput = $#credentials + 1;
if ( $numInput != 2) {
        print "Invalid number of inputs provided\n";
        print "Only two inputs are supposed to be provided: username and password\n";
        exit 1;
}
my $wl_username = $credentials[0];
my $wl_password = $credentials[1];


my $logfile;
my $cmd;

  $logfile = File::Spec->catfile($LOG_LOC, time());
  $logfile = $logfile . "_shutdown.log";  

   #handle windows
    if ( IsWindows() ) {
       $cmd =  File::Spec->catfile($DOMAIN_HOME, "bin", "stopWebLogic.cmd");
	$cmd= "$cmd $wl_username $wl_password t3://$ADMIN_HOST:$ADMIN_PORT  > $logfile";
    }
    else{
      $cmd =  File::Spec->catfile($DOMAIN_HOME, "bin", "stopWebLogic.sh");
      $cmd= "$cmd  $wl_username $wl_password t3://$ADMIN_HOST:$ADMIN_PORT  >&$logfile &";
    }

system($cmd);

 if ( &checkExitCode($?) ) {
        print "WebLogic Server shutdown failed \n";
        exit -1;
    }
    
#wait for server start up
my $counter = 10;
my $state;
my $search_string = "Shutting down the server";

while( $counter-- && ( $state ne "SHUTDOWN" ) ){
	print "sleep 60 seconds...\n";
	sleep(60); 
	
	$cmd="grep -c \"$search_string\" $logfile";

	print "executing: $cmd\n";

    	my $retVal=`$cmd`;
	
	if ($retVal > 0 ) {
        print "Weblogic Server $SERVER_NAME stopped\n";
		$state = "SHUTDOWN"; 
	}
}

if( $state eq "SHUTDOWN" ) {
	print "Weblogic Server $SERVER_NAME stopped\n";
	unlink($logfile);
	exit 0;
}
else {
	print "Weblogic Server $SERVER_NAME shutdown failed\n";
	 unlink($logfile);
	exit -1;
}

sub checkExitCode($) {
    my ($exit_value) = @_;
    $exit_value = $exit_value >> 8;
    return $exit_value;
}

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}

