#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/diagagent/wlfullclientCheck.pl /main/3 2012/06/11 04:32:12 surpraka Exp $
#
# wlfullclientCheck.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      wlfullclientCheck.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    habatra     04/09/12 - Creation
# 
use IPC::Open3;
use File::Path;
use File::Spec();
use Cwd;
use IO::Handle;
use IO::Select;
use Thread qw(async);

my $psep="";
my $dsep="";
if ( !&IsWindows() ) {
        $psep=":";
        $dsep="/";
} else {
        $psep=";";
        $dsep="\\";
}

my $pwd = getCurrDir();
print("Current working directory: $pwd\n");

my $EMAGENT_HOME = $ARGV[0];
my $WL_HOME = $ARGV[1];

print "\nEM Agent home : ".$EMAGENT_HOME;

open my $oldout, ">&STDOUT" or die "Can't dup STDOUT: $!";
open my $olderr, ">&STDERR" or die "Can't dup STDERR: $!";

my $AGENT_JAVA = $EMAGENT_HOME.$dsep."jdk".$dsep."bin".$dsep."java";
my $WORK_DIR = $WL_HOME.$dsep."server".$dsep."lib" ;
my $CREATE_WLFULLCLIENT=$AGENT_JAVA." -jar  wljarbuilder.jar";

$filename = $WORK_DIR.$dsep."wlfullclient.jar";
if (-e $filename) {
        print "\n **** Listing was successful ****\n";
        exit(0);
} else {
        print "\n **** Listing was NOT successful ****\n";
        print "\n **** Trying to create wlfullclient ****\n";
        print "\nCreate wlfullclient Command: ".$CREATE_WLFULLCLIENT;
        my $CMD=$CREATE_WLFULLCLIENT ;
        chdir $WORK_DIR ;
        my $create_status = system($CMD);
        print "\nCreate wlfullclient Command Status: ".$create_status ;
}

	if (-e $filename) {
              print "\n **** wlfullclient created successful ****\n";
               exit(0);
        }
        print "\n **** wlfullclient creation Failed ****\n";
        exit(-1);

sub execJavaCommands {
   my $STATUS = -1;
   if(&IsWindows()) {
        local (*HANDLE_IN, *HANDLE_OUT);
        $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $CMD)  or die "open3 failed $!\r\n";
                $thr = async {

                        my $nextLine;
                        while(<HANDLE_OUT>) {
                                $nextLine= $_;
                                print $nextLine;
                        }

                        close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
        };
                waitpid ($pid,0);
                $STATUS = $?;
                print "Status returned from the java process is $STATUS\r\n";
                $thr->join;
                return $STATUS;
    } else {
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR);
        $pid = open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $CMD);
                $thr = async {

                        my $sel = new IO::Select;
                        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

                        while(my @ready = $sel->can_read) {
                                foreach my $fh (@ready)
                                {
                                        my $line = <$fh>;
                                        if(not defined $line){
                                                $sel->remove($fh);
                                                next;
                                        }
                                        if(fileno($fh) == fileno(HANDLE_OUT)) {
                                                print $oldout $line;
                                        } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                                                print $olderr $line;
                                        } else { # we read from something else?
                                                die "Reading wrong file handle!\n";
                                        }
                                }
                        }

                        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
                        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
                };
                waitpid ($pid,0);
                $STATUS = $?;
                print "Status returned from the java process is $?\n";
                $thr->join;
                return $STATUS;
    }
}

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}


#Subroutine to get the current directory
sub getCurrDir() {
    my $pwd = getcwd();
    if ( &IsWindows() ) {
        $pwd =~ s/\//\\/g;
    }
    return $pwd;
}

sub checkExitCode($) {
    my ($exit_value) = @_;
    $exit_value = $exit_value >> 8;
    return $exit_value;
}


