from java.io import *
from java.lang import String
import os;
import sys;

ServerName = sys.argv[1]
weblogicportnumber = sys.argv[3]
machinename = sys.argv[4]
wlhome = sys.argv[5]
weblogichostname = sys.argv[6]
ListenAddress = sys.argv[6]
ExistingOMSServerName= sys.argv[7]
ListenPort = int(sys.argv[8])
SSLListenPort = int(sys.argv[9])
connectiontype = sys.argv[10]
ManagerName = sys.argv[11]
ManagerPort = sys.argv[12]
username = sys.argv[13]
oraclehome = sys.argv[14] 
EMGC_DOMAIN_HOME=  sys.argv[15]
ADPMANAGER_LOCATION= sys.argv[16]  
JAMMANAGER_DUMMY_LOCATION=sys.argv[17]
applicationName = sys.argv[18]
IS_NEW_SERVER= sys.argv[19]
HOSTSERVERNAME= sys.argv[20]
IS_DEPLOYED_APP=sys.argv[21]
Staging_Mode="nostage"
modulehome = ""
INSTANCE_HOME= ""

input = BufferedReader(InputStreamReader(System.in))
password = input.readLine().strip()


print "Deployment Summary: \n" "WEBLOGICHOSTNAME",weblogichostname,"\n WEBLOGICPORTNUMBER:",weblogicportnumber,"\n APPLICATIONNAME:",applicationName," \n USERNAME:",username," \n MACHINENAME:", machinename,"\n ORACLEHOME:", oraclehome,"\n WLHOME:", wlhome,"\n MODULEHOME:",modulehome,"\n SERVERNAME",ServerName,"\n LISTENADDRESS",ListenAddress,"\n LISTENPORT",ListenPort,"\n SSL LISTENPORT",SSLListenPort, "\n Existing OMS server name", ExistingOMSServerName, "\n Existing EMGC DOMAIN Home path", EMGC_DOMAIN_HOME, "\n Existing Instance Home", INSTANCE_HOME, "\nCONNECTIONTYPE",connectiontype,"\nORACLE_HOME",oraclehome,"\n NEW SERVER",IS_NEW_SERVER,"\n DEPLOYED APP",IS_DEPLOYED_APP


if(connectiontype=="http"):
	try:
		connect(username,password ,'t3://'+weblogichostname+':'+weblogicportnumber)
		print "\n"+'t3://'+weblogichostname+':'+weblogicportnumber+"\n"
                
	except:
		print "connection refused"
		sys.exit(1)
else:
	try:
		connect(username,password ,'t3s://'+weblogichostname+':'+weblogicportnumber)
	except:
		print "connection refused"
		sys.exit(1)

#Check for New Server
try: 
	cd('/Servers/' + ServerName)
	cd('../..')
	print '\n\nchecking for new server'
	if IS_NEW_SERVER == "true":
		print '===> Server \"' +ServerName+'\" already exists\n'
		print '===> Weblogic Domain is inconsistent state . createServer command may fail. Please refresh the Weblogic Domain and rerun the job in case of failure\n\n'
		pass
except:
	pass

#Check for Deployed App
try:
	print '\n\nChecking for Deployed App'
	cd('AppDeployments')
	domainRuntime()
	cd("AppRuntimeStateRuntime/AppRuntimeStateRuntime")
	intendedState = cmo.getIntendedState(applicationName)
	if intendedState :
		print 'Intended state for application  is '  + intendedState
		if IS_DEPLOYED_APP =="false":
			print '===>'+applicationName + ' is already deployed\n'
			print '===> Weblogic Domain may be inconsistent state .Please refresh the Weblogic Domain and rerun the job in case of failure\n\n\n'
except:
	pass

#Check for Edit Session
cfgManager = getConfigManager()
try:
	if cfgManager.getCurrentEditor() is None:
                ### No session
		pass
	else:
		cfgManager.getChanges()
		print '===> Currently there is a Session'
		if cfgManager.isEditor() == "true":
                        ### You are making changes!!!
			print '===> Looks like you started that session'
			print '===> You can check the console for any pending changes'
			print '===> Try rerunning job after you release or commit the pending changes'
		else:
                        ### Someone else is making changes
			userWithSession = cfgManager.getCurrentEditor().replace(' ', '')
			print '===> User \"' +userWithSession+'\" is making the changes'
			print '===> Wait until \"' +userWithSession+'\" complete the current session'
		pass
	pass
except Exception:
        ### Other Errors
	print '===> Error, see log for more info'
	exit()


#Deploy dummy jammanager on OMS box
if(IS_DEPLOYED_APP=="false"):
	print "Deploying ADP Manager Dummy on ",ExistingOMSServerName , "\n This will make jammanager entry to system-jazn-data.xml\n"
	try:
        	deploy('adpmanager_dummy',JAMMANAGER_DUMMY_LOCATION, targets=ExistingOMSServerName, timeout=300000,upload='true')
	except Exception:
        	print Exception, "\n"
        	undo("true","y")
        	disconnect()
        	exit()

	print "Undeploying ADP Manager Dummy from ",ExistingOMSServerName, "\n"
	stopApplication('adpmanager_dummy')
	undeploy('adpmanager_dummy', targets=ExistingOMSServerName)

try:
	edit()
	startEdit()

	if(IS_NEW_SERVER=="true"):
		print "Creating new Managed Server\n"
		cmo.createServer(ServerName)
		print "Created Server.\n"

	print("Now setting up properties\n")
	cd('/Servers/'+ServerName)
	if(IS_NEW_SERVER=="true"):
		cmo.setMachine(getMBean('/Machines/' + machinename))
		cmo.setListenAddress(HOSTSERVERNAME)
		cmo.setListenPort(ListenPort)
		cmo.setKeyStores('DemoIdentityAndDemoTrust')
		cd('/Servers/' + ServerName + '/SSL/' + ServerName)
		cmo.setListenPort(SSLListenPort)
		cmo.setEnabled(true)
		cmo.setTwoWaySSLEnabled(false)
		cmo.setHostnameVerificationIgnored(true)

	
	cd('/Servers/' + ServerName + '/Log/' + ServerName)
	cmo.setNumberOfFilesLimited(true)
	cmo.setFileCount(10)
	cmo.setLogFileSeverity('Warning')

	cd('/Servers/' + ServerName + '/ServerStart/' + ServerName)
	cmo.setArguments(' -DORACLE_HOME=' + oraclehome + ' -Docm.repeater.home=' + oraclehome  + ' -Ddomain.home=' + EMGC_DOMAIN_HOME + ' -DINSTANCE_HOME=' + INSTANCE_HOME)

	cmo.setClassPath(wlhome + '/server/lib/weblogic_sp.jar;' + wlhome + '/server/lib/weblogic.jar;' + modulehome + '/com.bea.core.apache.log4j_1.2.13.jar;' + oraclehome + '/sysman/jlib/emCORE.jar;' + oraclehome + '/sysman/jlib/emagentSDK.jar;' + oraclehome + '/sysman/jlib/log4j-core.jar;' + oraclehome + '/sysman/jlib/emcoreAgent.jar')

	save()
        activate()

	#Starting the server
	start(ServerName, "Server")

	edit()
	startEdit()
	#Setting the data source
	cd('/SystemResources/sysman-opss-ds')
	targets = get('Targets')
	print "Targets ",targets,"\n"

	seq=[ObjectName('com.bea:Name='+ServerName+',Type=Server')]
	newtarget=array(seq,ObjectName)

	newtargets=array(targets+newtarget,ObjectName)
	print "new Targets ",newtargets,"\n"
	set('Targets',newtargets)

	#start(ServerName, "Server")
	save()
        activate()

	#Deployment
	cd('/Servers/'+ServerName)
	if(IS_DEPLOYED_APP=="true"):
		print "Redeploying ADPManager on ",ServerName, "\n"
		redeploy('ADPManager_'+ServerName, timeout=300000)
		print "Redeployed ADP Manager \n"
	if(IS_DEPLOYED_APP=="false"):
		print "Deploying ADP Manager on ",ServerName, "\n"
		deploy(applicationName,ADPMANAGER_LOCATION, targets=ServerName, timeout=300000, stageMode=Staging_Mode)
		print "Deployed ADP Manager \n"
except Exception:
	print Exception, "\n"
	undo("true","y")
	disconnect()
	exit()
