#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/e2eEngineUpgrade/adp/adpmgr_checkprereq_upd.pl /main/2 2012/05/31 06:41:33 nehaa Exp $
#
# adpmgr_chekprereq_upd.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      adpmgr_chekprereq_upd.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nehaa       05/22/12 - Creation
# 

use IO::Socket; 
use File::Spec;
$listen_port = $ARGV[0];
$ssl_listen_port = $ARGV[1];
$isNewServer = $ARGV[2];
$ServerName = $ARGV[3];
$oldEmgcDomain =$ARGV[4];
$EMGC_DOMAIN=$ARGV[5];
$Config_Domain ="";

if($isNewServer eq "false")
{
print "\nServer already exist, skipping step";
exit 0;
}

my $WAR_FILE = "ADPManager.war";
my $EAR_FILE="ADPManager.ear";
my $ACSERA_FILE = "Acsera.properties";

print "\nIs New Server=",$isNewServer;
print "\nListen Port =",$listen_port;
print "\nssl_listen_port =", $ssl_listen_port;

# old Configuration file present
if($oldEmgcDomain ne "")
{
my $Acsera_Backup_file =File::Spec->catfile( $oldEmgcDomain,$ServerName, $EAR_FILE, $WAR_FILE, 'config', $ACSERA_FILE);
print "\nAcsera backup File=",$Acsera_Backup_file;
eval
{
$camm_port = `grep RMI.Registry.Port $Acsera_Backup_file  | cut -c 21-25`;
$cammPort_javaprovider = `grep RMI.JavaProvider.ServerPort $Acsera_Backup_file | cut -c 29-33`;
$cammPort_rsc = `grep RMI.RemoteServiceController.ServerPort $Acsera_Backup_file  | cut -c  40-44`;
$camm_port=~ s/\s+$//;
$cammPort_javaprovider=~ s/\s+$//;
$cammPort_rsc=~ s/\s+$//;
};
}
else # If old config does not exist use Default Ports
{
$camm_port ='51099';
$cammPort_javaprovider ='55003';
$cammPort_rsc ='55000';
}
print "\nRMI.Registry.Port=",$camm_port;
print "\nRMI.JavaProvider.ServerPort=",$cammPort_javaprovider;
print "\nRMI.RemoteServiceController.ServerPort=",$cammPort_rsc;
print "\n";

#check port availability
my $sock_listen_port = new IO::Socket::INET (  LocalPort => $listen_port, 
				   Proto => 'tcp', 
				   Listen => 1,  Reuse => 1,  ); 
my $sock_ssl_listen_port = new IO::Socket::INET (  LocalPort => $ssl_listen_port, 
				   Proto => 'tcp', 
				   Listen => 1,  Reuse => 1,  );
my $sock_camm_port = new IO::Socket::INET (  LocalPort => $camm_port, 
				   Proto => 'tcp', 
				   Listen => 1,  Reuse => 1,  ); 
my $sock_cammPort_javaprovider = new IO::Socket::INET (  LocalPort => $cammPort_javaprovider, 
				   Proto => 'tcp', 
				   Listen => 1,  Reuse => 1,  ); 
my $sock_cammPort_rsc = new IO::Socket::INET (  LocalPort => $cammPort_rsc, 
				   Proto => 'tcp', 
				   Listen => 1,  Reuse => 1,  ); 
if($sock_listen_port)
{
	print("Listen Port $listen_port is available \n");
}
else
{
die "Could not create socket: $!\nPrereq failed \n Listen Port $listen_port is unavailable \n" ;
exit -1;
}

if($sock_ssl_listen_port)
{
	print("SSL Listen Port $ssl_listen_port is available \n");
}
else
{
die "Could not create socket: $!\nPrereq failed \n SSL Listen Port $ssl_listen_port is unavailable \n" ;
exit -1;
}

if($sock_camm_port)
{
	print("ADP Manager Port $camm_port is available \n");
}
else
{
die "Could not create socket: $!\nPrereq failed \n ADP Manager Port $camm_port is unavailable \n" ;
exit -1;
}

if($sock_cammPort_javaprovider)
{
	print("Java Provider Port $cammPort_javaprovider is available \n");
}
else
{
die "Could not create socket: $!\nPrereq failed \n Java Provider Port $cammPort_javaprovider is unavailable \n" ;
exit -1;
}

if($cammPort_rsc)
{
	print("Remote Service Controller Port $cammPort_rsc is available \n");
	exit 0;
}
else
{
die "Could not create socket: $!\nPrereq failed \n Remote Service Controller Port $cammPort_rsc is unavailable \n" ;
exit -1;
}
