#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/e2eEngineUpgrade/jvmd/jvmd_engine_upgrade.pl /main/1 2012/04/30 00:04:29 ashivaha Exp $
#
# jvmd_engine_upgrade.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      jvmd_engine_upgrade.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nehaa       04/22/12 - Creation
# 

use File::Path;
use File::Spec();
use IPC::Open3;
use IO::Handle;
use IO::Select;

#Secure and unsecure modes

my $PYTHON_SCRIPT = $ARGV[0];
my $EMD_ROOT = $ARGV[1];
my $JAMMANAGER_LOCATION = $ARGV[2];
my $ADMIN_HOST_NAME = $ARGV[3];
my $ADMIN_WL_HOME = $ARGV[4];
my $portnumber= $ARGV[5];
my $connectiontype= $ARGV[6];
my $ServerName= $ARGV[7];
my $AGENT_STATE_DIR = $ARGV[8];

print("Printing parameters passed to perl script \n");
print("ADMIN_HOST_NAME: $ADMIN_HOSTNAME \n");
print("portnumber: $portnumber \n");
print("ServerName: $ServerName \n");
print("connectiontype: $connectiontype \n");
print("PYTHON_SCRIPT: $PYTHON_SCRIPT \n");
print("JAMMANAGER_LOCATION: $JAMMANAGER_LOCATION \n");
print("EMD_ROOT: $EMD_ROOT \n\n\n");

my $inp = <STDIN>;

my $comma_pos = index($inp, ",");

my $username = substr($inp, 0, $comma_pos);
my $password = substr($inp, $comma_pos+1 );

my $IS_WINDOWS = &IsWindows();

my $KEYSTORE_LOC = File::Spec->catfile( $AGENT_STATE_DIR,'sysman','config','montrust','AgentTrust.jks');
print("Key Location : $KEYSTORE_LOC \n");
my $DEPLOY_CMD = "$EMD_ROOT/jdk/bin/java -cp $ADMIN_WL_HOME/server/lib/weblogic.jar -Dweblogic.security.SSL.ignoreHostnameVerify=true -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.trustedCAKeyStore=$KEYSTORE_LOC weblogic.WLST  $PYTHON_SCRIPT $ADMIN_HOST_NAME $portnumber $username $ServerName $connectiontype $JAMMANAGER_LOCATION";


#Deploying making sure of the failure/success status
# don't use select function for windows
my $STATUS="true";

if(&IsWindows())
   {

   local (*HANDLE_IN, *HANDLE_OUT);
   open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_OUT, $DEPLOY_CMD)  or die "open3 failed $!\n" ;

	 print HANDLE_IN "$password\r\n";

    my $nextLine;
    while(<HANDLE_OUT>) {		
        $nextLine= $_;	
        print $nextLine;

        # i for case insensitive match
        if($nextLine =~ m/ERROR | Exception | WLSTException | Traceback/i) {
            $STATUS = "false";
        }
    }
 
	close(HANDLE_IN)   or die "Unable to close HANDLE_IN $!";
    close(HANDLE_OUT)  or die "Unable to close HANDLE_OUT! $!";
}
else
{
        local (*HANDLE_IN, *HANDLE_OUT,*HANDLE_ERR); 
        open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_ERR, $DEPLOY_CMD);

	 print HANDLE_IN "$password\r\n";

        my $sel = new IO::Select; 
        $sel->add(\*HANDLE_OUT,\*HANDLE_ERR);

        while(my @ready = $sel->can_read) { 
            foreach my $fh (@ready) 
            {
                my $line = <$fh>; 
                if(not defined $line){
                    $sel->remove($fh); 
                    next;              
                }
                if(fileno($fh) == fileno(HANDLE_OUT)) {     
                    print $line; 

                } elsif(fileno($fh) == fileno(HANDLE_ERR)) {
                    print  $line;
                    $STATUS = "false";
                } else { # we read from something else?
                    die "Reading wrong file handle!\n";
                }
            }
        }

        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
}

if( $STATUS eq "false" ) 
{	exit -1;}
else
{	exit 0;}

#End	

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
