#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ecmAssoc.pm /main/2 2009/10/12 04:38:31 djoly Exp $
#
# ecmAssoc.pm
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ecmAssoc - <one-line expansion of the name>
#
#    DESCRIPTION
#    This file contains the ECM Assocation strings, to be used by
#    all target types to describe their associations to other targets.
#    This file is used to ensure consistent naming of assocation types
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vdwaram     05/02/07 - 
#    ckannusa    01/30/07 - Add BI Target
#    ndutko      12/19/06 - JDEdwards E1 Integration
#    pparida     06/21/06 - Add target types oracle_ias_farm and 
#                           oracle_ias_cluster 
#    ndutko      08/03/05 - ndutko_code_checkin
#    dkapoor     06/24/05 - added rac_database
#    glavash     05/17/05 - creation
# 

use strict;

#*********************************
#  Global Variables
#*********************************

$ecmAssoc::CONNECTS_TO = 'connects_to';
$ecmAssoc::CONTAINS = 'contains';
$ecmAssoc::DEPENDS_ON = 'depends_on';
#
#HOSTED_BY is an implicit association.
#All targets are impliclity hosted_by the host where the collection
#script is run.  This assocation is represented in the ecm_live_link_targets
#table.  A target should only expose a HOSTED_BY assocation if the current host
#is not the Host that ultimately hosts the target.
# 
$ecmAssoc::HOSTED_BY = 'hosted_by';
$ecmAssoc::MEMBER_OF = 'member_of';
$ecmAssoc::MONITORED_BY = 'monitored_by';
$ecmAssoc::OPTIONALLY_CONNECTS_TO = 'optionally_connects_to';
$ecmAssoc::RELATES_TO = 'relates_to';
$ecmAssoc::REMOTELY_MONITORED_BY = 'remotely_monitored_by';
$ecmAssoc::RUNS_ON = 'runs_on';
$ecmAssoc::SERVICE_ACCESS_POINT = 'service_access_point';
#
# Target Types are listed here
#
#
$ecmAssoc::HOST_TYPE = 'host';
$ecmAssoc::LISTENER_TYPE = 'oracle_listener';
$ecmAssoc::NAMESERVER_TYPE = 'nameserver';
$ecmAssoc::OC4J_TYPE = 'oc4j';
$ecmAssoc::ORACLE_HOME_TYPE = 'oracle_home';
$ecmAssoc::ORACLE_APACHE_TYPE = 'oracle_apache';
$ecmAssoc::ORACLE_APACHE_CLUSTER_TYPE = 'oracle_apache_cluster';
$ecmAssoc::ORACLE_APPLICATION_TYPE = 'oracle_application';
$ecmAssoc::ORACLE_APPS_DB_TYPE = 'oracle_apps_db';
$ecmAssoc::ORACLE_APPS_INF_TYPE = 'oracle_apps_inf';
$ecmAssoc::ORACLE_APPS_SYSTEM = 'oracle_apps_system';
$ecmAssoc::ORACLE_BEACON_TYPE = 'oracle_beacon';
$ecmAssoc::ORACLE_CSA_COLLECTOR_TYPE = 'oracle_csa_collector';
$ecmAssoc::ORACLE_DATABASE_TYPE = 'oracle_database';
$ecmAssoc::ORACLE_EMD_TYPE = 'oracle_emd';
$ecmAssoc::ORACLE_EMREP_TYPE = 'oracle_emrep';
$ecmAssoc::ORACLE_JSERV_TYPE = 'oracle_jserv';
$ecmAssoc::ORACLE_LDAP_TYPE = 'oracle_ldap';
$ecmAssoc::ORACLE_IAS_TYPE = 'oracle_ias';
$ecmAssoc::ORACLE_OCSV2_TYPE = 'oracle_ocsv2';
$ecmAssoc::ORACLE_OVF_TYPE = 'oracle_ovf';
$ecmAssoc::ORACLE_PORTAL_TYPE = 'oracle_portal';
$ecmAssoc::ORACLE_WEBCACHE_TYPE = 'oracle_webcache';
$ecmAssoc::ORACLE_WIRELESS_TYPE = 'oracle_wireless';
$ecmAssoc::ORACLE_SSO_SERVER_TYPE = 'oracle_sso_server';
$ecmAssoc::RAC_DATABASE_TYPE = 'rac_database';
$ecmAssoc::ASM_INSTANCE_TYPE = 'osm_instance';
$ecmAssoc::ORACLE_IAS_FARM_TYPE = 'oracle_ias_farm';
$ecmAssoc::ORACLE_IAS_CLUSTER_TYPE = 'oracle_ias_cluster';

#
# PeopleSoft Target Types are listed here
#
$ecmAssoc::PSFT_APP_SERVER = 'oracle_psft_appsrv';
$ecmAssoc::PSFT_BAT_SERVER = 'oracle_psft_batsrv';
$ecmAssoc::PSFT_DATABASE = 'oracle_psft_database';
$ecmAssoc::PSFT_WEB_SERVER = 'oracle_psft_websrv';

#
# EnterpriseOne Target Types are listed here
#
$ecmAssoc::ORACLE_E1_CONFIG_TYPE = 'oracle_e1_config';
$ecmAssoc::ORACLE_E1_SCF_MC_TYPE = 'oracle_e1_scf_mc';
$ecmAssoc::ORACLE_E1_SCF_SA_TYPE = 'oracle_e1_scf_sa';
$ecmAssoc::ORACLE_E1_SCF_SA_WEBSERVER_TYPE = 'oracle_e1_scf_sa_webserver';
$ecmAssoc::ORACLE_E1_SCF_SA_ENTSERVER_TYPE = 'oracle_e1_scf_sa_entserver';
$ecmAssoc::ORACLE_E1_SCF_SA_PIMSYNCH_TYPE = 'oracle_e1_scf_sa_pimsynch';
$ecmAssoc::ORACLE_E1_SCF_SA_RTESERVER_TYPE = 'oracle_e1_scf_sa_rteserver';
$ecmAssoc::ORACLE_E1_SCF_SA_COLLABPORTAL_TYPE = 'oracle_e1_scf_sa_collabportal';

#
#BI Target Types are listed here
#
$ecmAssoc::ORACLE_BI_ANS = 'oracle_bi_ans';
$ecmAssoc::ORACLE_BI_CC = 'oracle_bi_cc';
$ecmAssoc::ORACLE_BI_PS = 'oracle_bi_ps';
$ecmAssoc::ORACLE_BI_SCH = 'oracle_bi_sch';

