#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/em_optic.pl /main/5 2010/07/27 09:07:53 rummadi Exp $
#
# em_optic.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      em_optic.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#       em_opticl.pl is invoked by the process control jobs. It spawns a JVM instance to execute
#       EMOptic.java class in emoptic.jar file.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nsarkar     02/27/06 - Modified to fix windows 2003 server bug 
#    vpai        01/29/05 - Added code to determine JVM versio 
#    vpai        10/25/04 - vpai_ta3grid
#    vpai        10/12/04 - Creation
#
#
my $OSNAME = $^O;

my $oracleHome = $ENV{ORACLE_HOME};
#my $emdRoot = $ENV{EMDROOT};
my $pluginRoot = $ENV{PLUGIN_ROOT};

my @cmd ;

if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT")) {
	my $javaCmd = getJavaCmd("$oracleHome\\jdk\\bin\\java", "$ARGV[0]\\jdk\\bin\\java");
	@cmd=($javaCmd, "-classpath","$ARGV[0]\\opmn\\lib\\optic.jar;$pluginRoot\\archives\\jlib\\emoptic.jar", "oracle.sysman.emSDK.ias.process.emoptic.EMOptic");
} else {
	my $javaCmd = getJavaCmd("$oracleHome/jdk/bin/java", "$ARGV[0]/jdk/bin/java");
	@cmd=($javaCmd,"-classpath","$ARGV[0]/opmn/lib/optic.jar:$pluginRoot/archives/jlib/emoptic.jar", "oracle.sysman.emSDK.ias.process.emoptic.EMOptic");
}
my $cmdindx = 4;

foreach (@ARGV) {
   $cmd[$cmdindx] = $_;
   $cmdindx = $cmdindx+1;
  
}

my $result = system @cmd;

sub getJavaCmd {
	my $agentJVM = @_[0];
	my $compJVM = @_[1];
	my $javaCmd = $compJVM;
	if (getJavaVersion($agentJVM)  gt  getJavaVersion($compJVM))
	{
		$javaCmd = $agentJVM;
	}
	return $javaCmd;
}

sub getJavaVersion {
	my $javaCmd = "@_[0] -version" ;
	my $versionOutput = `$javaCmd 2>&1`;
	my @tokens = split("\"", $versionOutput);
	my $version  = "";
	if (scalar(@tokens) >= 2) {
		$version = $tokens[1];
	}
	return $version;
}

