#!usr/bin/perl
#
# Copyright (c) 1998, 2011, Oracle and/or its affiliates. All rights reserved. 
#
# NAME:
#
#  formsjvmcontrollers.pl -- 
#
# ARGUMENTS:
#
#  argv(0) - scriptsDir
#  argv(1) - oracle_home string
#
#
# MODIFIED     (MM/DD/YY)
#  sbalacha     12/09/05 - Backport sbalacha_bug-4730160 from main 
#  sbalacha     11/24/05 - #(4730160) pass emdRoot and not oraHome to numCpus 
#                          and getPhysicalAndSharedMemory 
#  rgurubha     03/23/05 - #(4232268) Logging value must have first char in 
#                        - capitals, like On and Off.
#  sbalacha     02/23/05 - #(4176895) if jvmoptions and classpath are JVM's 
#                           default, assign default 
#  sbalacha     12/01/04 - #(4017604) remove references to dejvm90 
#  dklein       03/02/04  Removal of left over {controller}.jvm files
#  dklein       02/25/04  Moved definition of dejvmexename to formsinit.pl
#
# Include formsinit.pl
$scriptsDir=@ARGV[0];
$oraHome=@ARGV[1];
$emdRoot=@ARGV[2];
$frm_orahome=$oraHome;
#### I believe this is portable and there ain't a file separator problem with Windows
#### Need to check though.
$jvmCache=$oraHome . "/tools/jvm/cache";
$PID_FIELD=0;
$CPU_FIELD=1;


require ("$scriptsDir/formsinit.pl");
require ("$scriptsDir/iasresourceusage.pl");
#require ("$scriptsDir/iasotherresourceusage.pl");

$numCPUs = getNumCpus($emdRoot);

#
# For each Jvm controller a string is constructed of the form
# Cpu|PriMem|Jvms|Sessions|StartTime|Max|Logfile|Options|Classpath|Logging 
# 0   1      2    3        4         5   6       7       8         9
# This is stored as the value in a hash table based on controller name.
# This value gets split into an arrays of fields so individual components 
# can be accessed using the field indices indicated above.
# 
opendir DH, $jvmCache or die "Unable to open $jvmCache";

foreach $file (readdir DH) 
{
    next unless $file =~ /\.jvm$/;
    $controller=substr($file, 0, length($file) -4);
    #print "$controller\n";
    $starttime = "";
    $logging = "";
    $logdir = "";
    $classpath = "default";
    $jvmoptions = "default";
    $maxsessions = "";
    $jvms = "";
    $jvmpids = "";
    $sessions = "";
    $pids = "";
                 
    $state = `dejvm -state jvmcontroller=$controller `;
    #print "$state\n";
    my $test = substr($state, 0, 5);
    $testStartTime = index($state, "starttime");
    if ( $test eq "Error" )
    {
        #print   "ERROR NEED TO DELETE THE FILE\n";
        `rm $jvmCache/$file`;
    }
    elsif ( $testStartTime == -1 )
    {
        # print "Ouptput aint complete for $file\n";
        # The output ain't properly complete, ignore it
    }
    else
    {
        my @controllerstate = split /\n/, $state;
        foreach $line (@controllerstate)
        {
            #print "line is $line\n";
            $equalsIndex = index($line, "=");
            $name = substr($line, 0, $equalsIndex);
            #print "$name\n";
            $value = substr($line, $equalsIndex + 1);
            #print "$value\n";
            if ( $name eq "starttime") {
                 $starttime = $value;
            } elsif ( $name eq "logging" ) {
            # Bug 4232268  make logging value initially caped
                 if ( $value eq "on" ) { $value = "On"; }
                 if ( $value eq "off" ) { $value = "Off"; }
                 $logging = $value;
            } elsif ( $name eq "logdir" ) {
                 $logdir = $value;
            } elsif ( $name eq "classpath" ) {
                 unless ( $value eq "") {
                     $classpath = $value;
                 }
            } elsif ( $name eq "jvmoptions" ) {
                 unless ( $value eq "") {
                     $jvmoptions = $value;
                 }
            } elsif ( $name eq "maxsessions" ) {
                 $maxsessions = $value;
            } elsif ( $name eq "jvms" ) {
                 $jvms = $value;
            } elsif ( $name eq "jvmpids" ) {
                 $jvmpids = $value;
            } elsif ( $name eq "sessions" ) {
                 $sessions = $value;
            } elsif ( $name eq "pids" ) {
                 $pids = $value;
            }
        }
        # jvmpids is the pids of all the dejvm processes
        # controllered by this controller. Need to total up
        # their memory and cpu. First get them into a spave
        # delimited form so they can be passed to mem and cpu
        # summation functions.
        # There should always be at least on jvmpid - the
        # pid of the controling dejvm -start process.
        my @dejvmpids = split /\|/, $jvmpids;
        $pidList = " ";
        $count=0;
        foreach $dejvmpid (@dejvmpids)
        {
            $count++;
            if ( $count == 1 )
            {
                $pidList = $dejvmpid;
            }
            else
            {
                $pidList = "$dejvmpid,$pidList";
            }
        }
        #print "pidList is $pidList\n"; 
        #
        # getPhysicalAndSharedMemory is in formsinit.pl
        $physicalSharedMem=getPhysicalAndSharedMemory($pidList,$emdRoot);
        ($priMem,$sharedMem) = split('\|', $physicalSharedMem);
        $cpu = getCPUUsageForPids( $pidList, $numCPUs );
        #print "CPU usage is $cpu \n";

        # pids is the process ids of Forms sessions, need to change this from bar 
        # delimited to space delimited to include in the metric
        # Unlike jvmpids, pids could be blank.
        $formsPidList = "";
        if ( $pids ne "")
        {
            my @formspids = split /\|/, $pids;
            foreach $formspid (@formspids)
            {
                $formsPidList = "$formspid $formsPidList";
            }
        }
        # Metric is in format {name} {loadMetrics} {startup arguments}
        # ControllerName, Cpu, PriMem, Jvms, Sessions, StartTime, Max, Logdir, Options, Classpath, Logging, FormsPids
        #
        # Initially make up a string which is a composite of all the non-floating point values
        # excluding name, so
        # Jvms, Sessions, StartTime, Max, Logdir, Options, Classpath, Logging, FormsPids
        $suffix = $jvms."\|".$sessions."\|".$starttime."\|".$maxsessions."\|".$logdir."\|".$jvmoptions."\|".$classpath."\|".$logging."\|".$formsPidList;
        printf "em_result=%s\|%2.2f\|%2.2f\|%s\|\n", $controller, $cpu, $priMem, $suffix;
    }
}

