#!usr/bin/perl
#
# Copyright (c) 1998, 2011, Oracle and/or its affiliates. All rights reserved. 
#
# NAME:
#
#  formsjvmload.pl
#
# DESCRIPTION
#
#  Gets CPU and Memory totals for Forms JVM pooling processes
#
# ARGUMENTS:
#
#  argv(0) - scriptsDir
#  argv(1) - oracle_home string
#
#
# MODIFIED     (MM/DD/YY)
#  sbalacha     12/09/05 - Backport sbalacha_bug-4730160 from main 
#  sbalacha     11/24/05 - #(4730160) pass emdRoot and not oraHome to numCpus 
#                          and getPhysicalAndSharedMemory 
#  nudupi       02/21/05 - #(4178300) Modified the script so that it can 
#                          handle both ps output and nmupm.exe output to get 
#                          the pid's. 
#  sbalacha     12/01/04 - #(4017604) Remove references to dejvm90 
#  dklein       02/25/04  Moved definition of dejvmexename to 
#                         formsinit.pl 
#  dklein       01/05/04  Created
#
# Include formsinit.pl
$scriptsDir=@ARGV[0];
$oraHome=@ARGV[1];
$emdRoot=@ARGV[2];
$frm_orahome=$oraHome;
$dejvmexename = "dejvm";

require ("$scriptsDir/formsinit.pl");
require ("$scriptsDir/iasresourceusage.pl");

$pidList = "";
$totalCpu = 0;
$cpuRunningTotal = 0;
$noDejvmDetectedYet = 1;  
foreach $_ (`$getcpuusage`) 
    {
    if (/$_[0]/){
        if (/$dejvmexename/) 
        {
            $noDejvmDetectedYet = 0;
            #
            # Modified so that this script can cope with nmupm.exe
            # output on Windows as well as ps output on unix.
            # Get pid out of ps/nmupm.exe output.
            #
            my @tmp_process = split ($getcpuDelimiter, $_ );

            #
            # If we're on Windows, we have to allow for the output starting
            # with the string "em_result=" which get stripped off.
            #
            if ( index($tmp_process[$getcpuPID_COL],"em_result=") > -1 )
            {
                $pid = substr($tmp_process[$getcpuPID_COL],10);
            }
            else
            {
                $pid = $tmp_process[$getcpuPID_COL];
            }

# Get cpu usage out of ps output.
            $cpu = $tmp_process[$getcpuCPU_COL];

            if ( $pidList )
            {
                $pidList = "$pidList,$pid";
            }
            else
            {
                $pidList = $pid;
            }
            $totalCpu = $totalCpu+$cpu;
        }
    }
}
$cpuUsage = $totalCpu/getNumCpus($emdRoot);
$physicalSharedMem=getPhysicalAndSharedMemory($pidList,$emdRoot);
($privateMem,$sharedMem) = split('\|', $physicalSharedMem);
#print "privateMem for $pidList is $privateMem\n";
my $totalMem= $privateMem+ $sharedMem;

#
# Actual output will be totalCpu|privateMem|sharedMem|totalMem
#
if ( $noDejvmDetectedYet == 1 ) {
    print "em_result=0\|0\|0\|0\n";
} else {
    print "em_result=$cpuUsage\|$physicalSharedMem\|$totalMem\n";
}

