#!usr/bin/perl
#
# Copyright (c) 1998, 2011, Oracle and/or its affiliates. All rights reserved. 
#
# NAME:
#
#  formsload.pl -- Forms runtime instances discovery script
#                discovers a list of runtime instances and updates the DB
#
# ARGUMENTS:
#
#  argv(0) - scriptsDir
#  argv(1) - oracle_home
#
#
# MODIFIED     (MM/DD/YY)
#  ahousing    01/26/05  - #(4138702) Update copyright date 
#  sbalacha    12/02/04 -  #(4017604) Fix starting JVM controller
#  clowes      03/16/04 -  Taking out unnecessary port specific code
#  clowes      12/30/03 -  #(3334946) Passing emdRoot rather than frm_orahome
#                          to iasresourceusage.pl routines.
#  clowes      12/11/03 -  #(3162441) Together with modifications made to
#                          formsinit.pl, this script has been modified to
#                          allow for alternative formats from getcpuusage
#                          which is used to determine the Forms process ids.
#                          The change is restricted to Windows until patch 1.
#  clowes      08/21/03 -  #(3108671) port specific calls moved to formsinit.pl
#                          from formsproc.pl and formsload.pl
#  clowes      07/30/03 -  #(3064094) using ps rather than getCPUUsageForPids
#                          as this was always returning 0 to this script.
#  clowes      06/11/03 -  Taking advantage of iasresourceusage routines
#  diglesia    04/24/02 -  HPUX-Changes for iAS 2.0 Forms/Reports 9i M17F APR12
#                          Tick Fix for bug:   BUG 2337917 - FORMS SESSION
#                          DETAILS DOES NOT SHOW IN EMD
#  sindla      08/12/01 -  Added check to see if there is a corresponding
#                          rti file before adding to the sum. 
#  pkuhn       08/09/01 -  Modified from .tcl to .pl
#  sindla      06/06/01 -  Creation
#

$scriptsDir=@ARGV[0];
$frm_orahome=@ARGV[1];
$oraHome=$frm_orahome;
$emdRoot=@ARGV[2];
require ("$scriptsDir/formsinit.pl");
require ("$scriptsDir/iasresourceusage.pl");

$frmem_home="$frm_orahome$emhome";

#
# Main routine...
#
$proclist = "";

$os = $^O;
$numCPUs = getNumCpus($emdRoot);

#
# run ps command to get a list of runtime instances
#

$numProcesses = 0;
$totalCPU = 0;

foreach $_ (`$getcpuusage`) {
    if (/$_[0]/){
        if (/$frmexename/) {
            # Adding getcpuDelimiter (which is set in formsinit)
            # so this script can cope with nmupm.exe output on Windows as
            # well as ps output on unix.
            #
            my @tmp_process = split ($getcpuDelimiter, $_ );
            #
            #  If we're on Windows, we have to allow for the output starting
            #  with the string "em_result=" which get stripped off.
            #
            if ( index($tmp_process[$getcpuPID_COL],"em_result=") > -1 )
            {
                $pid = substr($tmp_process[$getcpuPID_COL],10);
            }
            else
            {
                $pid = $tmp_process[$getcpuPID_COL];
            }
# Get cpu usage out of ps output.
            $cpu = $tmp_process[$getcpuCPU_COL];


            $rti90file  = "$frmem_home/em_$pid.rti";

            if (-r $rti90file) {
                $rtifile = $rti90file;
            } else {
                next;
            }

            if ( $proclist )
            {
                $proclist = "$proclist,$pid";
            }
            else
            {
                $proclist = $pid;
            }
            $numProcesses++;
            $totalCPU = $totalCPU+$cpu;
         }
     }
}

($physical_mem_total, $physical_mem_free_raw, $pagesize) = 
    split( '\|', $memory_metrics );

my $physicalSharedMem = getPhysicalAndSharedMemory($proclist, $emdRoot);
($privateUsage,$sharedUsage) = split('\|', $physicalSharedMem);
my $totalUsage = $privateUsage + $sharedUsage;

$cpuUsage = $totalCPU/$numCPUs;

print "em_result=$numProcesses|$cpuUsage|$totalUsage|$sharedUsage\n";

