#!usr/bin/perl
#
# Copyright (c) 1998, 2011, Oracle and/or its affiliates. All rights reserved. 
#
# NAME:
#
#  formsproc.pl -- Forms runtime instances discovery script
#                discovers a list of runtime instances and updates the DB
#
# ARGUMENTS:
#
#  argv(0) - scriptsDir
#  argv(1) - oracle_home string
#
#
# MODIFIED     (MM/DD/YY)
#  sbalacha    11/24/05 - #(4730160) pass emdRoot and not oraHome to numCpus 
#                         and getPhysicalAndSharedMemory 
#  sbalacha    12/09/05 - Backport sbalacha_bug-4730160 from main 
#  sbalacha    12/09/05 - Backport sbalacha_bug-4439450 from main 
#  sbalacha    08/11/05 - #(4439450) Fine tune the regular expression. 
#  ahousing    01/26/05 - #(4138702) Update copyright date 
#  sbalacha    12/02/04 - #(4017604) Fix starting JVM controller
#  nudupi      04/07/04 - #(3463647) and #(3265464) Fixes problem with search 
#                          when there are pre-started processes and processes 
#                          which are not connected to the database 
#  clowes      03/16/04 -  Taking out unnecessary port specific code
#  clowes      12/11/03 -  #(3103734) Together with modifications made to
#                          formsinit.pl, this script has been modified to
#                          allow for alternative formats from getcpuusage
#                          which is used to determine the Forms process ids.
#                          This change is restricted to Windows until patch 1.
#  clowes      08/21/03 -  #(3108671) port specific calls moved to formsinit.pl
#                          from formsproc.pl and formsload.pl
#  clowes      08/19/03 -  #(2743077) need to add the thread id to the session
#  clowes      07/30/03 -  #(3064094) using ps rather than getCPUUsageForPids
#                          as this was always returning 0 to this script.
#  clowes      07/09/03 -  Reorgnisation of code to improve performance
#  clowes      01/15/03 -  Added support for Forms Trace integration
#                          and config section.
#  sindla      08/12/01 -  added scriptsDir arg.
#  pkuhn       08/09/01 -  Changed from .tcl to .pl
#  sindla      06/06/01 -  Creation
#

# Include formsinit.pl
$scriptsDir=@ARGV[0];
$frm_orahome=@ARGV[1];
$emdRoot=@ARGV[2];
$oraHome=$frm_orahome;

require ("$scriptsDir/formsinit.pl");
require ("$scriptsDir/iasresourceusage.pl");

my $now = `date`;
frmdebug (">>>formsproc.pl start --> $now");

#
# Main routine...
#
$frmem_home="$frm_orahome$emhome";
$oraHome=$frm_orahome;
frmdebug(" OraHome from oratab: $oraHome");


@plist = ();
$os = $^O;
frmdebug("OS; $os");
$numCPUs = getNumCpus($emdRoot);

#
# run ps command to get a list of runtime instances
#

foreach $_ (`$getcpuusage`) {
    if (/$_[0]/){
        if (/$frmexename/) {
            # Adding getcpuDelimiter (which is set in formsinit)
            # so this script can cope with nmupm.exe output on Windows as
            # well as ps output on unix.
            #
            my @tmp_process = split ($getcpuDelimiter, $_ );
            #
            #  If we're on Windows, we have to allow for the output starting
            #  with the string "em_result=" which get stripped off.
            #
            if ( index($tmp_process[$getcpuPID_COL],"em_result=") > -1 )
            {
                $pid = substr($tmp_process[$getcpuPID_COL],10);
            }
            else
            {
                $pid = $tmp_process[$getcpuPID_COL];
            }
# Get cpu usage out of ps output.
            $cpu = $tmp_process[$getcpuCPU_COL];

frmdebug("processing: $pid");


            $rti90file  = "$frmem_home/em_$pid.rti";

            if (-r $rti90file) {
                $rtifile = $rti90file;
            } else {
                next;
            }

            my $ipaddr = " ";
            my $username = " ";
            my $lid  = "";
            my $ctime  = "Not connected";
            my $log = "OFF";
            my $tracing = "OFF";
            my $tracefile = "";
            my $config = "";
            my $threadid = "";

            #frmdebug ($rtifile);

            open(RTI, $rtifile);
            while (<RTI>) {
                chop;
#
# For each line, get the appropriate information after the '='.
#
                if (/listener/) {
                    s/.*=\s+(.*)$/\1/;
                    $lid = $_;
                }
                elsif (/config/) {
                    s/.*=\s+(.*)$/\1/;
                    $config = $_;
                }
                elsif (/user/) {
                    s/.*=\s+(.*)$/\1/;
                    $username = $_;
                }
                elsif (/connect/) {
                    s/.*=\s+(.*)$/\1/;
                    $ctime = $_;
                }
                elsif (/ip\s*=/) {
                    s/.*=\s+(.*)$/\1/;
                    $ipaddr = $_;
                }
                elsif (/log/) {
                    s/.*=\s+(.*)$/\1/;
                    $log = $_;
                }
                elsif (/tracing/) {
                    s/.*=\s+(.*)$/\1/;
                    $tracing = $_;
                }
                elsif (/tracefile/) {
                    s/.*=\s+(.*)$/\1/;
                    $tracefile = $_;
                }
                elsif (/threadid/) {
                    s/.*=\s+(.*)$/\1/;
                    $threadid = $_;
                }
            }
            close(RTI);

            my $processMemory = getPhysicalAndSharedMemory($pid, $emdRoot);

            ($privateUsage, $sharedUsage) = split('\|',  $processMemory );

            $cpuUsage = $cpu/$numCPUs;

            print "em_result=$pid|$cpuUsage|$privateUsage|$ipaddr|$username|$ctime|$tracing|$tracefile|$config|$threadid\n";
#            frmdebug("em_result=$pid|$cpuUsage|$privateUsage|$ipaddr|$username|$ctime|$tracing|$tracefile|$config|$threadid\n");
        }

    }
}
my $now = `date`;
frmdebug (">>>formsproc.pl finish --> $now");

