#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/fusion_middleware_control.pl /main/10 2011/11/04 08:30:58 bevoss Exp $
#
# fusion_middleware_control.pl
# 
# Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      fusion_middleware_control.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      There is also an EMFA equivalent of this script at
#      emfa/agent/scripts/fusion_middleware_control.pl
#
#      The script name is hard-coded in
#      emas/jsrc/sdk/oracle/sysman/emas/sdk/pcs/model/PCSProcessUtil.java
#      as
#      private static final String PERL_SCRIPT_LOCATION =
#            "%emd_plugin_root%/scripts/fusion_middleware_control.pl";
#
#      This script is run as part of the oracle.sysman.emas.agent plugin,
#      while the equivalent EMFA script is run as part of the
#      oracle.sysman.emfa.agent plugin.  However, both scripts share       !! IMPORTANT !!
#      the same OMS side code and UI.  Thus any changes here which
#      also require OMS side changes should be compatible or coordinated 
#      with the EMFA version of this file.
#
#    MODIFIED   (MM/DD/YY)
#    bevoss      10/21/11 - Just added EMFA comment
#    rkuriako    08/29/11 - 12916145
#    sulagana    06/29/09 - Creation
# 
use File::Find;
my $flagtype = $ARGV[0];
my $oper = $ARGV[1];
my $oraHome = $ENV{EMDROOT};
my $pluginRoot = $ENV{PLUGIN_ROOT};
my $agentStateDir = $ENV{EMSTATE};
my $pathSep = getPathSep();
my $sep = "/";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $sep = "\\";
}

my $keystoreFilename = $agentStateDir."$sep"."sysman"."$sep"."config"."$sep".montrust."$sep"."AgentTrust.jks";


require $oraHome."/sysman/admin/scripts/emd_common.pl";

EMD_PERL_DEBUG("Fusion Middleware control operation for Flag Type $flagtype");

my %argMap = (); 
foreach $t (@ARGV)
{
    my @arg = split("#", $t);

	#$arg[0] possible values are targetName, targetType,MachineName,Port,WeblogicHome,Protocol,OPMNMBean,CompName,appVersion,targetServer,moduleType,simpleAppName,sso

	$argMap{$arg[0]} = $arg[1];

}

my $target = $argMap{'targetName'};
my $type   = $argMap{'targetType'};
my $hostname  = $argMap{'MachineName'};
my $port   = $argMap{'Port'};
my $weblogichome   = $argMap{'WeblogicHome'};
my $protocol   = $argMap{'Protocol'};
my $opmnmbean   = $argMap{'OPMNMBean'};
my $componentname   = $argMap{'CompName'};
my $appVersion   = $argMap{'appVersion'};
my $targetServer   = $argMap{'targetServer'};
my $moduleType   = $argMap{'moduleType'};
my $simpleAppName   = $argMap{'simpleAppName'};
my $sso   = $argMap{'sso'};
my $clusterName = $argMap{'ClusterName'};
my $customTarget= $argMap{'customTarget'};
my $customTargets= $argMap{'customTargets'};
my $extraParams = $argMap{'extraParams'};

my $classpath = 
    $oraHome."/lib/xmlparserv2.jar".
    $pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".
    $pathSep.$pluginRoot."/archives/jlib/emd_java.jar".
    $pathSep.$weblogichome."/server/lib/weblogic.jar".
    $pathSep.$weblogichome."/server/lib/wljmxclient.jar".
    $pathSep.$weblogichome."/server/lib/wlclient.jar".
    $pathSep.$pluginRoot."/archives/jlib/wljmxclient.jar".
    $pathSep.$pluginRoot."/archives/jlib/wlclient.jar".
    $pathSep.$pluginRoot."/archives/em-aiess-util-pojo.jar";


if( ((defined $customTargets) && ($customTargets =~ $type)) || ((defined $customTarget) && ($customTarget eq 'true')) ) {
    $flagtype = "custom";
}

if($flagtype eq "custom") {
	my ($exitcode,$response) = customTargetHandler();	
	print $response;
 	exit $exitcode;

}
elsif($flagtype eq "OPMNComp")
{
	EMD_PERL_DEBUG("Fusion Middleware control operation on nonj2eecomponents");
	my ($exitcode,$response) = nonj2eecomponents();
	print $response;
    exit $exitcode;

}
elsif($flagtype eq "J2eeApp")
{
	EMD_PERL_DEBUG("Fusion Middleware control operation on j2eeApplication");
	my ($exitcode,$response) = j2eeApplication();
	print $response;
	exit $exitcode;
}
elsif($flagtype eq "weblogic")
{
	EMD_PERL_DEBUG("Fusion Middleware control operation on weblogicJ2eeServer");
	my ($exitcode,$response) = weblogicJ2eeServer();
	print $response;
    exit $exitcode;

}

elsif($flagtype eq "cdbdomain")
{
	EMD_PERL_DEBUG("Fusion Middleware control operation on cdbDomain");
	 my ($exitcode,$response) = cdbDomain();
	 print $response;
     exit $exitcode;
}

chomp($os = $^O);
EMD_PERL_DEBUG("Fusion Middleware control operation for target $target and type $type");
EMD_PERL_DEBUG("Fusion Middleware control operation=$oper");
EMD_PERL_DEBUG("Fusion Middleware control hostname=$hostname and port $port");

sub getPathSep()
{
	my $sep;
	chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64")) 
    {
        $sep = ":";
    }
	else
    {
        $sep = ";";
    }
	return $sep;
	
}

	

sub nonj2eecomponents
{
    EMD_PERL_DEBUG("Fusion Middleware control operation for Non J2ee components $type");    
    EMD_PERL_DEBUG("Fusion Middleware control componentname=$componentname");
    EMD_PERL_DEBUG("Fusion Middleware control opmn mbean=$opmnmbean");

    #my $protocol = "t3"; 
    my $command = $oraHome."/jdk/bin/java ";
	if(("t3s" eq $protocol) || ("iiops" eq protocol))
    {
	    $command = $command." -Djavax.net.ssl.trustStore=".$keystoreFilename;
    } 
    $command = $command." -cp ".$classpath." oracle.sysman.emas.sdk.process.StartStopFMW ".
    "\"".$hostname. "\""." ". "\"".$port. "\""." ". "\"".$protocol. "\""." "."\"".$target. "\""." ". "\"".$type. "\""." ". "\"".$oper. "\""." ". "\"".$flagtype. "\""." ". "\"".$componentname. "\""." ". "\"".$opmnmbean."\"";
    
    EMD_PERL_DEBUG("Fusion Middleware control operation for Non J2ee components $command"); 
    
    my $result =`$command`;
    
    EMD_PERL_DEBUG("Fusion Middleware control operation result=$result");        

	return echoResult($result);
}

sub j2eeApplication
{
	EMD_PERL_DEBUG("Fusion Middleware control operation for J2ee Application $type");
	EMD_PERL_DEBUG("Fusion Middleware control appVersion $appVersion");
	EMD_PERL_DEBUG("Fusion Middleware control targetServer $targetServer");
	EMD_PERL_DEBUG("Fusion Middleware control simpleAppName $simpleAppName");
	EMD_PERL_DEBUG("Fusion Middleware control moduleType $moduleType");
	EMD_PERL_DEBUG("Fusion Middleware control sso $sso");

	#my $protocol = "t3"; 
	my $command = $oraHome."/jdk/bin/java ";
	 if(("t3s" eq $protocol) || ("iiops" eq protocol))
	{
		$command = $command." -Djavax.net.ssl.trustStore=".$keystoreFilename;
	} 

	if( (defined $clusterName) && ($clusterName ne "") && ($clusterName ne "null") ){
		$targetServer = $clusterName;
	}

	$command = $command." -cp ".
		$oraHome."/sysman/jlib/wlfullclient.jar".
		$pathSep.$oraHome."/sysman/jlib/com.bea.core.descriptor.wl_1.3.0.0.jar".
		$pathSep.$oraHome."/sysman/jlib/com.bea.core.descriptor.wl_1.1.0.0.jar".
		$pathSep.$classpath."  oracle.sysman.emas.sdk.process.StartStopFMW ".
		"\"".$hostname. "\""." ". "\"".$port. "\""." ". "\"".$protocol. "\""." ". "\"".$target. "\""." ". "\"".$type. "\""." ". "\"".$oper. "\""." ". "\"".$flagtype. "\""." ". "\"".$appVersion. "\""." ". "\"".$targetServer."\""." ". "\"".$moduleType."\""." ". "\"".$simpleAppName."\""." ". "\"".$sso."\"";
    

	EMD_PERL_DEBUG("Fusion Middleware control operation for J2ee Application $command");

	my $result =`$command`;

	EMD_PERL_DEBUG("Fusion Middleware control operation result=$result");

	return echoResult($result);
}

sub weblogicJ2eeServer
{
	EMD_PERL_DEBUG("Fusion Middleware control operation for weblogicJ2eeServer $type");
	EMD_PERL_DEBUG("Fusion Middleware control operation for weblogicJ2eeServer $componentname");

	#my $protocol = "t3"; 
	my $command = $oraHome."/jdk/bin/java ";
	if(("t3s" eq $protocol) || ("iiops" eq protocol))
	{
		$command = $command." -Djavax.net.ssl.trustStore=".$keystoreFilename;
	} 

	$command = $command." -cp ".$classpath." oracle.sysman.emas.sdk.process.StartStopFMW ".
    		"\"".$hostname. "\""." ". "\"".$port. "\""." ". "\"".$protocol. "\""." ". "\"".$target. "\""." ". "\"".$type. "\""." ". "\"".$oper. "\""." ". "\"".$flagtype. "\""." ". "\"".$componentname. "\"";

	EMD_PERL_DEBUG("Fusion Middleware control operation for weblogicJ2eeServer $command");
	my $result =`$command`;

	EMD_PERL_DEBUG("Fusion Middleware control operation result=$result");

	return echoResult($result);
}

sub customTargetHandler
{
        EMD_PERL_DEBUG("Fusion Middleware control operation for $type");

        #my $protocol = "t3"; 
        my $command = $oraHome."/jdk/bin/java ";
        if(("t3s" eq $protocol) || ("iiops" eq protocol))
        {
                $command = $command." -Djavax.net.ssl.trustStore=".$keystoreFilename;
        }
	

	# To add an additional parameter first put dot (.) for string concatination,followed by
	# a space (" ") to be left between params, followed by again dot (.),followed by double-quote start
	# ("\""), followed by actual parameter (eg $port), followed by dot and double-quote end ("\"")
        $command = $command." -cp ".$classpath." oracle.sysman.emas.sdk.process.StartStopFMW ".
                "\"".$hostname. "\""." ". "\"".$port. "\""." ". "\"".$protocol. "\""." ". "\"".$target. "\""." ". "\"".$type. "\""." ". "\"".$oper. "\""." ". "\"".$flagtype. "\""." ". "\"".$extraParams. "\"";

	#Handle custom components based on j2ee app
	if((defined $simpleAppName) && ($simpleAppName ne ""))  { 
	 $command = $command." ". "\"".$appVersion. "\""." ". "\"".$targetServer."\""." ". "\"".$moduleType."\""." ". "\"".$simpleAppName."\""." ". "\"".$sso."\"";
	}

        EMD_PERL_DEBUG("Fusion Middleware control operation for target with custom handler: $command");
        my $result =`$command`;

        EMD_PERL_DEBUG("Fusion Middleware control operation result=$result");

        return echoResult($result);
}



sub echoResult {

my $result = @_[0];

my $exitcode = 0;
my $response = "";
 if ( $result =~ m/<Responses>/)
    {
        my $ind = index($result, "<Responses>");
        my $indend = index($result, "</Responses>");
        my $offset = $indend - $ind +  length("</Responses>");
        $result = substr($result,$ind, $offset);
        # this logic fails in case of multiple Response elements and hence multiple ExitCode elements
        my $ind1 =  index($result, "<ExitCode>");
        my $offset1 = 1;
        #Get first character after <ExitCode>. It will be a number
        $exitcode =  substr($result,$ind1+length("<Response>"), $offset1);

        my $ind2 = index($result, "<ResponseMessage>");
        my $indend2 = index($result, "</ResponseMessage>");
        my $offset2 = $indend2 - $ind2 -  length("<ResponseMessage>") ;
        $response = substr($result,$ind2 + length("<ResponseMessage>"), $offset2);

    }

	return ($exitcode,$response);
}

#sub createResponseXML
#{

#    my $operation = @_[0];
#    my $result = @_[1];
#    my $targetName = @_[2];
#    my $exitCode;
#    my $respMessage;
#    my $responseXML;
#    my $Error = <STDERR>;

#    if ( $result =~ m/was started/ or $result =~ m/was shutdown successfully/
#                            or $result =~ m/was resumed successfully/)
#    {
#        $exitCode = "0";
#        $respMessage = "SUCCESS";
#    }
#    elsif ($result =~ m/NoClassDefFoundError/ )
#    {
#        $exitCode = "1";
#        $respMessage= "The operating system credentials provided may not have the required read permissions to load ".
#                "WebLogic related jar files. Such permissions are required to perform start/stop/restart operations.".
#                " Provide credentials which have the required read permissions.";
#    }

#    else
#    {
#        $exitCode = "1";
#        $respMessage= $result;

#    }

#    $responseXML = "<Responses><Response><ExitCode>".$exitCode."</ExitCode><ResponseMessage>".$respMessage."</ResponseMessage><TargetName>".$targetName."</TargetName></Response></Responses>";
#    return $responseXML;
#}
