#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/generic_apache/getCipherSuites.pl /main/3 2009/10/12 04:38:31 djoly Exp $
#
# getCipherSuites.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getCipherSuites.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vaudinar   07/10/08 - bug 7037742
#    spandita    08/14/06 - use Apache_confFileParser.
#    spandita    08/08/06 - Creation
# 
use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $rootConfFile = $ARGV[0];
my $binPath = $ARGV[1];
my $hash = parseApacheVer2xConf($rootConfFile,$binPath);

my @vhosts = getApacheVHosts($hash);

for my $vhost (@vhosts)
{
    my $addr = $$vhost{'address'};
    my $props = $$vhost{'properties'};
    if ($props)
    {
        my $ssl = peek($$props{'SSLEngine'});
        if (defined($ssl) && ($ssl eq 'on'))
        {
            my $cipherSuite = peek($$props{'SSLCipherSuite'});
            printResult(
                $addr,        'string',
                $cipherSuite, 'string(2000)',
            );
        }
    }
}
