#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/generic_apache/getListenAddresses.pl /main/3 2009/10/12 04:38:31 djoly Exp $
#
# getListenAddresses.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getListenAddresses.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vaudinar    07/28/08 - 
#    akmahesh    07/10/08 - 
#    spandita    08/14/06 - use Apache_confFileParser
#    spandita    08/08/06 - Creation
#
use strict;
use ias::Apache_confFileParser;
use ias::asecm;


my $rootConfFile = $ARGV[0];
#my $hash = parseConfFile($rootConfFile);

my $binPath = $ARGV[1];
my $hash = parseApacheVer2xConf($rootConfFile,$binPath);

my $listenRef = $$hash{'Listen'};
if (!$listenRef)
{
    exit;
}
my @listenAddrs = @{$listenRef};

my $topSSLRef = peek($$hash{'SSLEngine'});
my $topProtocol = 'http';
if ($topSSLRef && ($topSSLRef eq 'on'))
{
    $topProtocol = 'https';
}

my @vhosts = getApacheVHosts($hash);

for my $addr (@listenAddrs)
{
    my $ip;
    my $port = $addr;
    if ($addr =~ /^(.*):(.*)/)
    {
        $ip = $1;
        $port = $2;
    }
    my $protocol = $topProtocol;
    my $vhost = findMatchingVHost($port, \@vhosts);
    if (defined($vhost))
    {
        my $props = $$vhost{'properties'};
        my $sslRef = peek($$props{'SSLEngine'});
        if ($sslRef)
        {
            if ($sslRef eq 'on')
            {
                $protocol = 'https';
            }
            elsif ($sslRef eq 'off')
            {
                $protocol = 'http';
            }
        }
    }
    printResult(
        $ip,        'string',
        $port,      'number',
        $protocol,  'string',
    );
}

sub findMatchingVHost
{
    my $port = $_[0];
    my $vhosts = $_[1];

    for my $vhost (@{$vhosts})
    {
        my $vhostPort = $$vhost{'port'};
        if (defined($vhostPort) && ($vhostPort eq $port))
        {
            return $vhost;
        }
    }
    for my $vhost (@vhosts)
    {
        my $vhostPort = $$vhost{'port'};
        if (!defined($vhostPort) || ($vhostPort eq '*'))
        {
            return $vhost;
        }
    }
    return undef;
}
