#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/generic_apache/getPerformanceRelated.pl /main/3 2009/10/12 04:38:31 djoly Exp $
#
# getPerformanceRelated.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getPerformanceRelated.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vaudinar    07/28/08 - 
#    akmahesh    07/10/08 - 
#    spandita    08/14/06 - use Apache_confFileParser
#    spandita    08/08/06 - Creation
#
use strict;
use ias::Apache_confFileParser;
use ias::asecm;


my $rootConfFile = $ARGV[0];
my $binPath = $ARGV[1];
my $hash = parseApacheVer2xConf($rootConfFile,$binPath);


my $platform = getPlatform();

my $maxClients;
my $maxSpareServers;
my $minSpareServers;

if ($platform eq 'windows')
{
    $maxClients = peek($$hash{'ThreadsPerChild'});
}
else # unix
{
    $maxClients = peek($$hash{'MaxClients'});
    $maxSpareServers = peek($$hash{'MaxSpareServers'});
    $minSpareServers = peek($$hash{'MinSpareServers'});
}

printResult(
    $maxClients,                            'number',
    peek($$hash{'MaxRequestsPerChild'}),     'number',
    $maxSpareServers,                       'number',
    $minSpareServers,                       'number',
    peek($$hash{'StartServers'}),            'number',
    peek($$hash{'Timeout'}),                 'number',
    peek($$hash{'ListenBackLog'}),           'number',
    peek($$hash{'KeepAlive'}),               'string',
    peek($$hash{'MaxKeepAliveRequests'}),    'number',
    peek($$hash{'KeepAliveTimeout'}),        'number',
    peek($$hash{'SSLSessionCacheTimeout'}),  'number',
    peek($$hash{'HostnameLookups'}),         'string',
    peek($$hash{'LogLevel'}),                'string',
);
