#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/generic_apache/getRoutingInfo.pl /main/3 2009/10/12 04:38:31 djoly Exp $
#
# getRoutingInfo.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getRoutingInfo.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vaudinar    07/28/08 - 
#    akmahesh    07/10/08 - 
#    spandita    08/14/06 - use Apache_confFileParser.
#    spandita    08/08/06 - Creation
# 
use strict;
use ias::Apache_confFileParser;
use ias::asecm;
use ias::simpleXPath;
require "emd_common.pl";

my $rootConfFile = $ARGV[0];
my $binPath = $ARGV[1];
my $hash = parseApacheVer2xConf($rootConfFile,$binPath);

#my @modules = ("mod_weblogic.c");
#my $hash = parseConfFile( $rootConfFile,undef,\@modules);

my $apacheHome =     peek($$hash{'ServerRoot'});

#get WebLogic Routings
my @wlRoutings = getWLRoutings($hash);

#get WebSphere routings
my @wasRoutings = getWASRoutings($hash,"WebSpherePluginConfig");

my @allRoutings;
push (@allRoutings,@wlRoutings);
push (@allRoutings,@wasRoutings);

my $alllen = scalar(@allRoutings);

EMD_PERL_DEBUG("No of Routings=$alllen");



for(my $i=0; $i < $alllen; $i++)
{
    my $arrVal = $allRoutings[$i];
    my %location = %$arrVal;
    printResult(
        $location{'host'},           'string',
        $location{'port'},           'number',
        $location{'serverType'},     'string',
        $location{'appPath'},        'string',
        $location{'servername'},        'string',
    );

}

sub getWLRoutings
{
    my @results;
    my $hashRef = @_[0];
    EMD_PERL_DEBUG("getWLRoutings Entered");
    my @locs = getLocations($hashRef,"Location");
    my $lenLocs = @locs;
    EMD_PERL_DEBUG("Length of Locations Directive array=$lenLocs");

    push(@results,@locs);
    
    my @locsmatch = getLocations($hashRef,"LocationMatch");
    my $lenLocMatch = @locsmatch;
    EMD_PERL_DEBUG("Length of LocationMatch Directive array=$lenLocMatch");
    push(@results,@locsmatch);
    
    my $ifModulesRef = $$hashRef{'IfModule'};
    EMD_PERL_DEBUG("IfModulesRef=$ifModulesRef");
    
    return @results;
}

sub getWASRoutings
{
    EMD_PERL_DEBUG("getWASRoutings called");
    my $hash = @_[0];
    my $pluginDirective = @_[1];

    my $pluginConfigFile = peek($$hash{$pluginDirective});
    my @results;

    my $fileToParse = checkWebSpherePlugin($pluginConfigFile);
    
    if (!defined($fileToParse))
    {
        return;
    }
    else
    {
        my @allRoutes = getAllRoutes($fileToParse);

        my $allRoutesLen = scalar(@allRoutes);
        for(my $j=0; $j < $allRoutesLen ; $j++)
        {
            my $routeMap = $allRoutes[$j];
            my $clusterName = $$routeMap{'serverCluster'};
            my $uriGroup = $$routeMap{'uriGroup'};
            
            EMD_PERL_DEBUG("route cluster name = $clusterName");
            EMD_PERL_DEBUG("route uri group = $uriGroup");
            my @alltransports = simpleXPathQueryForNodes(
                            $fileToParse, 
                            'Config/ServerCluster[@Name="'.$clusterName.'"]/Server/Transport');
            my $len = scalar(@alltransports);
            EMD_PERL_DEBUG("All transports length = $len");
            my @allUris = simpleXPathQueryForNodes(
                            $fileToParse,
                            'Config/UriGroup[@Name="'.$uriGroup.'"]/Uri');
            my $urilen = scalar(@allUris);
            EMD_PERL_DEBUG("All Uris length = $urilen");
                        
                

            for(my $i=0; $i < $len ; $i++)
            {
                my $appPath = '';
                $appPath = getAppPath(@allUris);
                my $serverType = "websphere_j2eeserver";
                my $arrVal = $alltransports[$i];
                my %transportRef = %$arrVal;
                my $transportAttributes = $transportRef{'attributes'};
                my $host = $$transportAttributes{'Hostname'};
                my $port = $$transportAttributes{'Port'};
                my $protocol = $$transportAttributes{'Protocol'};

                #parent of the transport
                my $serverRef = $transportRef{'parent'};
                my $serverAttributes = $$serverRef{'attributes'};
                my $serverName = $$serverAttributes{'Name'};

                EMD_PERL_DEBUG("Host = $host");
                EMD_PERL_DEBUG("Port = $port");
                EMD_PERL_DEBUG("Protocol = $protocol");
                EMD_PERL_DEBUG("Server Name = $serverName");

                my $loc = {
                    'appPath' => $appPath,
                    'serverType' => $serverType,
                    'port' => $port,
                    'host' => $host,
                    'servername' => $serverName
                    
                };            
                push(@results,$loc);

            }            
        }
    }
    return @results;
}

sub checkWebSpherePlugin
{
    my $pluginConfigFile = @_[0];
    my $fileToParse;

    if (!defined($pluginConfigFile))
    {
        #no websphere plugin
        EMD_PERL_DEBUG("Plug in File is not defined=$pluginConfigFile***");
        return;
    }
    else
    {
        EMD_PERL_DEBUG("Plug in File is =$pluginConfigFile");
        if(-e $pluginConfigFile)
        {
            EMD_PERL_DEBUG("Plug in File exists $pluginConfigFile");
            $fileToParse = $pluginConfigFile;

        }
        else
        {
            EMD_PERL_DEBUG("$pluginConfigFile does not exist");
            #it might be a relative path try to check absolute path by prepending apacheHome
            my $absPath = $apacheHome."/".$pluginConfigFile;
            if (-e $absPath)
            {
                EMD_PERL_DEBUG("$absPath exists");
                $fileToParse = $absPath;

            }
            else
            {
                return;
            }

        }
    }
    return $fileToParse;
}

sub getLocations
{
    my $hash = @_[0];
    my $pattern = @_[1];

    my @results;
    my $locs = $$hash{$pattern};
    EMD_PERL_DEBUG("getLocations ********* $locs");
    if (!$locs)
    {
        return ();
    }

    my %hashRef  = %$locs;

    for my $locExpr (keys %hashRef)
    {
        my $appPath = $locExpr;
        my $host;
        my $port;
        my $serverType = "weblogic_j2eeserver";
        my $serverName = "";

        my $locHash = $hashRef{$locExpr};

        if(peek($$locHash{'WebLogicHost'}))
        {

            $host = peek($$locHash{'WebLogicHost'});
            $port = peek($$locHash{'WebLogicPort'});
            my $loc = {
                'appPath' => $appPath,
                'serverType' => $serverType,
                'port' => $port,
                'host' => $host,
                'servername' => $serverName
            };
            push(@results, $loc);

        }
        elsif(peek($$locHash{'WebLogicCluster'}))
        {
            my $cluster = peek($$locHash{'WebLogicCluster'});

            my @hostporttokens = split(/,/,$cluster);
            foreach my $hostport (@hostporttokens)
            {
                ($host,$port) = split(/:/,$hostport);
                my $loc = {
                    'appPath' => $appPath,
                    'serverType' => $serverType,
                    'port' => $port,
                    'host' => $host,
                    'servername' => $serverName
                };
                push(@results, $loc);

            }
        }

    }

    return @results;
}

#The Route element in the plugin-cfg.xml file tells how the plugin will
#handle the request . the function resturns the list of clusters to which th
#request is routed.
sub getAllRoutes
{
    my $plugInFile = @_[0];
    my @routes = simpleXPathQuery($plugInFile, 'Config/Route');
    my @results;
    foreach my $route (@routes)
    {
        my $serverCluster = $$route{'ServerCluster'};
        my $uriGroup = $$route{'UriGroup'};

        my $routeMap = {
                    'serverCluster' => $serverCluster,
                    'uriGroup' => $uriGroup
                };
        EMD_PERL_DEBUG("getAllRoutes ********* serverCluster= $serverCluster");
        EMD_PERL_DEBUG("getAllRoutes ********* uriGroup = $uriGroup");
        push(@results,$routeMap);
    }
    return @results;
    
    
}

sub getAppPath
{
    my $appPath;
    my @uris = @_;
    my $len = scalar(@uris);
        EMD_PERL_DEBUG("getAppPath ********* $len");
    if($len <= 0)
    {
        return;
    }

    for(my $i=0; $i < $len; $i++)
    {
        my $arrVal = $uris[$i];
        my %uriRef = %$arrVal;
        my $uriAttributes = $uriRef{'attributes'};
        my $name = $$uriAttributes{'Name'};
        $appPath = $appPath.":".$name;
    }
        EMD_PERL_DEBUG("getAppPath ********* $appPath");
    return $appPath;
}

