#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/generic_apache/getVirtualHosts.pl /main/4 2011/12/15 18:05:50 smariswa Exp $
#
# getVirtualHosts.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getVirtualHosts.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    smariswa    12/12/11 - Use Java Based Parser
#    vaudinar    07/28/08 - 
#    akmahesh    07/10/08 - 
#    spandita    08/08/06 - Creation
# 
use strict;
use ias::Apache_JavaConfParser;
use ias::asecm;

my $rootConfFile = $ARGV[0];
my $binPath = $ARGV[1];

my @vHostArr = getConfFileProperties('oracle.sysman.emas.model.ohs.VirtualHostParser', $rootConfFile);
my $arrLen = @vHostArr;
for (my $ctr=0; $ctr < ($arrLen-1); $ctr++ )
{
    my $singleVhostStr = $vHostArr[$ctr];    
    my %vhostProps = parsePropertyValues($singleVhostStr) ;
    my $ip = $vhostProps{'ip'};
    my $port = $vhostProps{'port'};
    my $serverName = $vhostProps{'ServerName'};
    my $serverType = $vhostProps{'ServerType'};
 
  printResult(
        $ip,            'string',
        $port,          'number',
        $serverName,    'string',
        $serverType,    'number',
    );
}
