#!/usr/local/bin/perl
#
# $Header: emas/sysman/admin/scripts/iam/dseeProcessControl.pl /main/2 2011/04/20 13:21:08 rayleung Exp $
#
# dseeProcessControl.pl
#
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dseeProcessControl.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    04/13/11 - Bug 12360167
#    rayleung    01/10/11 - Creation
#

use File::Spec;
my $oper = $ARGV[0];
my $instance = $ARGV[1];
my $command = "";
require "emd_common.pl";

my $sep = "/";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $sep = "\\";
}
EMD_PERL_DEBUG("ODSEE process control: $oper operation on server $instance");

my $ldiffile = $instance.$sep."config".$sep."dse.ldif";
open FILE, "<".$ldiffile or die "dse.ldif cannot be found";

my $volume;
my $directory;
my $fileName;
my %uniquePath;
# Get all unique plugin paths
while ($file = <FILE>)
{
    chomp($file);
    if($file =~ /\bnsslapd-pluginPath:/) 
    {
        $pathInfo = $file;
        @fileInfo = split(/:\s/, $pathInfo);
        $pluginFile = $fileInfo[1];
        $pluginFile =~ s/^\s+//;
        $pluginFile =~ s/\s+$//;
        # File path can be longer than a line in ldif file.  Need to concatenate the path.
        $nextline = <FILE>;
	while(!($nextline =~ /:/))
	{
            $nextline =~ s/^\s+//;
            $nextline =~ s/\s+$//;
	    $pluginFile = $pluginFile.$nextline;
            $nextline = <FILE>;
	}
        ($volume,$directory,$fileName) = File::Spec->splitpath($pluginFile);        
        $uniquePath{$directory} = $directory;
    }
}

my @pathList = values %uniquePath;
# Check if dsadm is available
foreach $path (@pathList)
{
    $dsadmLoc = $path."..".$sep."bin".$sep."dsadm";
    if(-e $dsadmLoc)
    {
        $command = $dsadmLoc;
        EMD_PERL_DEBUG("ODSEE process control: dsadm found.");
        last;
    }
}

# Die if dsadm cannot be found.
if($command eq "") 
{
    EMD_PERL_DEBUG("ODSEE process control: dsadm cannot be found.");
    die "dsadm cannot be found";
}

$fullCommand = $command." ".$oper." ".$instance; 
# Execute stop/start process
my $result =`$fullCommand`;
if($result =~ /\b$oper/) 
{
    exit 0;
}
else 
{
    if($oper =~ /stop/)
    {
        $fullCommand = $command." ".$oper." --force ".$instance; 
        $result = `$fullCommand`;
        if($result =~ /\b$oper/)
        {
            exit 0;
        }
        else
        {
           die $result;
        }
    }
    else 
    {
        die $result;
    }
}
