#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/iam/dumpOIDconfig.pl /main/1 2011/04/15 11:42:43 kchander Exp $
#
# dumpOIDconfig.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dumpOIDconfig.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/05/10 - Creation
# 

use strict;
use ias::simpleXPath;

require "emd_common.pl";

my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $host = $ARGV[2];
my $port = $ARGV[3];
my $username = $ARGV[4];
my $password = $ARGV[5];
my $oracleHome = $ARGV[6];
my $os = $^O;
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);

my $xmlFile;
EMAGENT_PERL_DEBUG("Dump OID Config gets called");
$xmlFile = "$oracleInstance/config/OID/$displayName/oidconfig_xml";

my $cm;
if(($os =~ "Win") || ($os =~ "MSWin32")) {
	EMAGENT_PERL_DEBUG("OS is Windows");
	$cm = $oracleHome."\\bin\\ldapsearch -U 1 -h $host -p $port -D \"$username\" -w $password -b \"cn=$displayName,cn=osdldapd,cn=subconfigsubentry\" -s sub \"(objectclass=*)\"";
}
else
{
	if(($os eq "hpux") || ($os eq "HPUX") || ($os eq "HP-UX"))
	{
		EMAGENT_PERL_DEBUG("OS is HPUX");
		$ENV{LD_LIBRARY_PATH} = $oracleHome."/ldap/lib/:".$oracleHome."/lib/:";
		$ENV{SHLIB_PATH} = $oracleHome."/ldap/lib/:".$oracleHome."/lib/:";
	}
	if(($os eq "aix") || ($os eq "AIX"))
	{
		EMAGENT_PERL_DEBUG("OS is AIX");
		$ENV{LIBPATH} = $oracleHome."/ldap/lib/:".$oracleHome."/lib/:";
	}
	$cm = $oracleHome."/bin/ldapsearch -U 1 -h $host -p $port -D \"$username\" -w $password -b \"cn=$displayName,cn=osdldapd,cn=subconfigsubentry\" -s sub \"(objectclass=*)\"";
}

my $out = `$cm > $xmlFile`;
print "em_result=$out\n";