#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/iam/dumpOIMconfig.pl /main/1 2012/04/15 03:56:27 rahgupta Exp $
#
# dumpOIMconfig.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dumpOIMconfig.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    01/03/12 - Creation
#

use IPC::Open2; 
use ParseStdin;
require "emd_common.pl";

ParseStdin::initStdin();
my $userName = ParseStdin::getParameter("userName");
my $password = ParseStdin::getParameter("password");    
my $oracleHome = $ARGV[0];
my $agentState = $ARGV[1];
my $serverURL = $ARGV[2];
my $serverName = $ARGV[3];
my $targetName = $ARGV[4];
my $slash = '/';
my $indexOfSlash = index($targetName,$slash);
my $displayName = substr($targetName,$indexOfSlash+1);
#EMD_PERL_DEBUG('$serverURL = '.$serverURL);
#EMD_PERL_DEBUG('$serverName = '.$serverName);
#EMD_PERL_DEBUG('$oracleHome = '.$oracleHome);

my $agentState = $ARGV[1];
my $sep = "/";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $sep = "\\";
  $displayName =~ s/\//\\/;
}

$serverURL =~ s/service:jmx://;
$serverURL =~ s/\/jndi\/weblogic\.management\.mbeanservers\.domainruntime//;
#EMD_PERL_DEBUG('serverURL = '.$serverURL.' ');

my $exportMetadataScriptFile = $agentState.$sep."oimExportMetadata.py";
my $metadataToLocation = $agentState.$sep."oim_config".$sep.$displayName;
my $metadataFile = $sep."db".$sep."oim-config.xml";

#EMD_PERL_DEBUG('exportMetadataScriptFile = '.$exportMetadataScriptFile.' ');
#EMD_PERL_DEBUG('metadataToLocation = '.$metadataToLocation.' ');
#EMD_PERL_DEBUG('metadataFile = '.$metadataFile.' ');

#generate py script for later wlst call
open EXPORT, ">$exportMetadataScriptFile";
print EXPORT "print \'Starting export metadata script .... \'\n";
print EXPORT "input = BufferedReader(InputStreamReader(System.in))\n";
print EXPORT "userName = input.readLine()\n";
print EXPORT "password = input.readLine()\n";
print EXPORT "serverURL = input.readLine()\n";
print EXPORT "connect(userName,password,serverURL)\n";
print EXPORT "exportMetadata(application=\'OIMMetadata\', server=\'$serverName\', toLocation=\'$metadataToLocation\', docs=\'$metadataFile\', applicationVersion=\'*\')\n";
print EXPORT "disconnect ()\n";
print EXPORT "print \'End of export metadata script ...\'\n";
print EXPORT "exit()\n";
close EXPORT;

#construct the wlst path
my $WLST_CMD = $oracleHome.$sep."common".$sep."bin".$sep."wlst.sh";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $WLST_CMD = $oracleHome.$sep."common".$sep."bin".$sep."wlst.cmd";
}

#construct the wlst command
my $execScript = $WLST_CMD." ".$exportMetadataScriptFile;
#EMD_PERL_DEBUG('wlst command = '.$execScript.' ');
#execute the wlst command
my($OUT, $IN);
my $pid = open2($OUT, $IN, $execScript);
print $IN "$userName\r\n";
print $IN "$password\r\n";
print $IN "$serverURL\r\n";
close($IN);
my @result = <$OUT>;
close($OUT);

my $line;
foreach $line (@result)
{
   if ($line =~ /End of export metadata script .../)
   {
     print "em_result=1";
     exit(0);
   }
}
print "em_result=0";
